/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.lut;

import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.lut.DicomLookupTable;
import com.agfa.pacs.data.shared.lut.IColorLookupTableSource;
import com.agfa.pacs.data.shared.lut.ILookupTable;
import com.agfa.pacs.logging.ALogger;
import org.dcm4che3.data.Attributes;

public class ColorLookupTableSource
extends DatasetAccessor
implements IColorLookupTableSource {
    private int[] redPaletteColorLookupTableDescriptor;
    private int[] greenPaletteColorLookupTableDescriptor;
    private int[] bluePaletteColorLookupTableDescriptor;
    private byte[] redPaletteColorLookupTableData;
    private byte[] bluePaletteColorLookupTableData;
    private byte[] greenPaletteColorLookupTableData;
    private byte[] segmentedRedPaletteColorLookupTableData;
    private byte[] segmentedGreenPaletteColorLookupTableData;
    private byte[] segmentedBluePaletteColorLookupTableData;

    protected ColorLookupTableSource() {
    }

    public ColorLookupTableSource(Attributes attributes) {
        try {
            this.redPaletteColorLookupTableDescriptor = this.getIntegers(attributes, 2625793);
            this.greenPaletteColorLookupTableDescriptor = this.getIntegers(attributes, 2625794);
            this.bluePaletteColorLookupTableDescriptor = this.getIntegers(attributes, 2625795);
            this.redPaletteColorLookupTableData = attributes.getBytes(2626049);
            this.greenPaletteColorLookupTableData = attributes.getBytes(2626050);
            this.bluePaletteColorLookupTableData = attributes.getBytes(2626051);
            this.segmentedRedPaletteColorLookupTableData = attributes.getBytes(0x281221);
            this.segmentedGreenPaletteColorLookupTableData = attributes.getBytes(0x281222);
            this.segmentedBluePaletteColorLookupTableData = attributes.getBytes(2626083);
        }
        catch (Exception exception) {
            ALogger.getLogger(ColorLookupTableSource.class).error("Reading color lookup table data failed", (Throwable)exception);
        }
    }

    public byte[] getBluePaletteColorLookupTableData() {
        return this.bluePaletteColorLookupTableData;
    }

    public void setBluePaletteColorLookupTableData(byte[] byArray) {
        this.bluePaletteColorLookupTableData = byArray;
    }

    public int[] getBluePaletteColorLookupTableDescriptor() {
        return this.bluePaletteColorLookupTableDescriptor;
    }

    public void setBluePaletteColorLookupTableDescriptor(int[] nArray) {
        this.bluePaletteColorLookupTableDescriptor = nArray;
    }

    public byte[] getGreenPaletteColorLookupTableData() {
        return this.greenPaletteColorLookupTableData;
    }

    public void setGreenPaletteColorLookupTableData(byte[] byArray) {
        this.greenPaletteColorLookupTableData = byArray;
    }

    public int[] getGreenPaletteColorLookupTableDescriptor() {
        return this.greenPaletteColorLookupTableDescriptor;
    }

    public void setGreenPaletteColorLookupTableDescriptor(int[] nArray) {
        this.greenPaletteColorLookupTableDescriptor = nArray;
    }

    public byte[] getRedPaletteColorLookupTableData() {
        return this.redPaletteColorLookupTableData;
    }

    public void setRedPaletteColorLookupTableData(byte[] byArray) {
        this.redPaletteColorLookupTableData = byArray;
    }

    public int[] getRedPaletteColorLookupTableDescriptor() {
        return this.redPaletteColorLookupTableDescriptor;
    }

    public void setRedPaletteColorLookupTableDescriptor(int[] nArray) {
        this.redPaletteColorLookupTableDescriptor = nArray;
    }

    public byte[] getSegmentedBluePaletteColorLookupTableData() {
        return this.segmentedBluePaletteColorLookupTableData;
    }

    public void setSegmentedBluePaletteColorLookupTableData(byte[] byArray) {
        this.segmentedBluePaletteColorLookupTableData = byArray;
    }

    public byte[] getSegmentedGreenPaletteColorLookupTableData() {
        return this.segmentedGreenPaletteColorLookupTableData;
    }

    public void setSegmentedGreenPaletteColorLookupTableData(byte[] byArray) {
        this.segmentedGreenPaletteColorLookupTableData = byArray;
    }

    public byte[] getSegmentedRedPaletteColorLookupTableData() {
        return this.segmentedRedPaletteColorLookupTableData;
    }

    public void setSegmentedRedPaletteColorLookupTableData(byte[] byArray) {
        this.segmentedRedPaletteColorLookupTableData = byArray;
    }

    @Override
    public ILookupTable getLookupTable(IColorLookupTableSource.Channel channel) {
        switch (channel) {
            case Red: {
                return new DicomLookupTable(this.redPaletteColorLookupTableDescriptor, this.redPaletteColorLookupTableData, this.segmentedRedPaletteColorLookupTableData, channel.toString());
            }
            case Green: {
                return new DicomLookupTable(this.greenPaletteColorLookupTableDescriptor, this.greenPaletteColorLookupTableData, this.segmentedGreenPaletteColorLookupTableData, channel.toString());
            }
            case Blue: {
                return new DicomLookupTable(this.bluePaletteColorLookupTableDescriptor, this.bluePaletteColorLookupTableData, this.segmentedBluePaletteColorLookupTableData, channel.toString());
            }
        }
        throw new IllegalArgumentException("Unsupported channel: " + (Object)((Object)channel));
    }

    @Override
    public boolean hasLookupTable() {
        return this.redPaletteColorLookupTableDescriptor != null && this.greenPaletteColorLookupTableDescriptor != null && this.bluePaletteColorLookupTableDescriptor != null;
    }

    @Override
    public void setTo(IColorLookupTableSource.Channel channel, ILookupTable iLookupTable) {
        switch (channel) {
            case Red: {
                if (!(iLookupTable instanceof DicomLookupTable)) break;
                DicomLookupTable dicomLookupTable = (DicomLookupTable)iLookupTable;
                this.redPaletteColorLookupTableDescriptor = dicomLookupTable.getLUTDescriptor();
                if (dicomLookupTable.getLUTSegmentedData() != null) {
                    this.segmentedRedPaletteColorLookupTableData = dicomLookupTable.getLUTSegmentedData();
                    break;
                }
                this.redPaletteColorLookupTableData = dicomLookupTable.getLUTData();
                break;
            }
            case Green: {
                if (!(iLookupTable instanceof DicomLookupTable)) break;
                DicomLookupTable dicomLookupTable = (DicomLookupTable)iLookupTable;
                this.greenPaletteColorLookupTableDescriptor = dicomLookupTable.getLUTDescriptor();
                if (dicomLookupTable.getLUTSegmentedData() != null) {
                    this.segmentedGreenPaletteColorLookupTableData = dicomLookupTable.getLUTSegmentedData();
                    break;
                }
                this.greenPaletteColorLookupTableData = dicomLookupTable.getLUTData();
                break;
            }
            case Blue: {
                if (!(iLookupTable instanceof DicomLookupTable)) break;
                DicomLookupTable dicomLookupTable = (DicomLookupTable)iLookupTable;
                this.bluePaletteColorLookupTableDescriptor = dicomLookupTable.getLUTDescriptor();
                if (dicomLookupTable.getLUTSegmentedData() != null) {
                    this.segmentedBluePaletteColorLookupTableData = dicomLookupTable.getLUTSegmentedData();
                    break;
                }
                this.bluePaletteColorLookupTableData = dicomLookupTable.getLUTData();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported channel: " + (Object)((Object)channel));
            }
        }
    }
}

