/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.lw.impl;

import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.instanceinfo.Availability;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IIntermediateDataInfo;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;

public abstract class AdaptedDataInfo<T extends IDataInfo>
implements IIntermediateDataInfo {
    private static final ALogger log = ALogger.getLogger(AdaptedDataInfo.class);
    protected final T adapter;

    public AdaptedDataInfo(T t) {
        this.adapter = t;
    }

    @Override
    public boolean addChild(IDataInfo iDataInfo) {
        boolean bl = this.adapter.addChild(iDataInfo);
        if (bl) {
            iDataInfo.setTreeParent(this);
        }
        return bl;
    }

    @Override
    public void addChildren(Collection<? extends IDataInfo> collection) {
        this.adapter.addChildren(collection);
        for (IDataInfo iDataInfo : collection) {
            iDataInfo.setTreeParent(this);
        }
    }

    @Override
    public void removeChild(IDataInfo iDataInfo) {
        this.adapter.removeChild(iDataInfo);
    }

    @Override
    public List<? extends IDataInfo> children() {
        return this.adapter.children();
    }

    @Override
    public List<IDataInfo> children(Level level, IDataInfo iDataInfo) {
        return ((IIntermediateDataInfo)this.adapter).children(level, iDataInfo);
    }

    @Override
    public void resetChildren() {
        ((IIntermediateDataInfo)this.adapter).resetChildren();
    }

    @Override
    public List<IDataInfo> children(Level level) {
        return ((IIntermediateDataInfo)this.adapter).children(level, this);
    }

    @Override
    public boolean childrenAvailable() {
        return this.adapter.childrenAvailable();
    }

    protected IDataInfo copyAdapter(boolean bl) {
        return this.adapter.copy(bl);
    }

    @Override
    public IDataInfo deepCopy(boolean bl) {
        IDataInfo iDataInfo;
        block5: {
            iDataInfo = this.copy(bl);
            if (iDataInfo != null) break block5;
            return null;
        }
        try {
            if (this.childrenAvailable()) {
                List<? extends IDataInfo> list = this.adapter.children();
                ArrayList<IDataInfo> arrayList = new ArrayList<IDataInfo>(list.size());
                for (IDataInfo iDataInfo2 : list) {
                    arrayList.add(iDataInfo2.deepCopy(bl));
                }
                iDataInfo.addChildren(arrayList);
            }
            return iDataInfo;
        }
        catch (Exception exception) {
            log.error("DataInfo deep copy error", (Throwable)exception);
            return null;
        }
    }

    @Override
    public boolean equalsKey(IDataInfo iDataInfo) {
        return this.adapter.equalsKey(iDataInfo);
    }

    @Override
    public Availability getAvailability() {
        return this.adapter.getAvailability();
    }

    public List<Attributes> getItems(int n, String string) {
        return this.adapter.getItems(n, string);
    }

    @Override
    public String getKey() {
        return this.adapter.getKey();
    }

    @Override
    public Level getHierarchyLevel() {
        return this.adapter.getHierarchyLevel();
    }

    @Override
    public IDataInfoSource getSource() {
        return this.adapter.getSource();
    }

    @Override
    public IDataInfo getTreeParent() {
        return this.adapter.getTreeParent();
    }

    @Override
    public Attributes getDicomObjectMerged() {
        return this.adapter.getDicomObjectMerged();
    }

    @Override
    public boolean hasChildren() {
        return this.adapter.hasChildren();
    }

    @Override
    public void setSource(IDataInfoSource iDataInfoSource) {
        this.adapter.setSource(iDataInfoSource);
    }

    @Override
    public void setTreeParent(IDataInfo iDataInfo) {
        this.adapter.setTreeParent(iDataInfo);
    }

    public Attributes getAttributes() {
        return this.adapter.getAttributes();
    }

    @Override
    public Date getDate(int n) {
        return this.adapter.getDate(n);
    }

    @Override
    public String getString(int n) {
        return this.adapter.getString(n);
    }

    @Override
    public int getInt(int n) {
        return this.adapter.getInt(n);
    }

    @Override
    public boolean containsValue(int n) {
        return this.adapter.containsValue(n);
    }

    public void setAttributes(Attributes attributes) {
        this.adapter.setAttributes(attributes);
    }
}

