/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.node;

import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IDataProviderIdentifier;
import com.agfa.pacs.data.shared.lw.IPublicCloneable;
import com.agfa.pacs.data.shared.node.DataInfoNodeProviderFactory;
import com.agfa.pacs.data.shared.node.IAETResolver;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.node.IDataInfoNodeProvider;
import com.agfa.pacs.data.shared.properties.PropertiesOwner;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class DataInfoNodeUtilities {
    private static final ALogger log = ALogger.getLogger(DataInfoNodeUtilities.class);
    private static IAETResolver resolver = null;

    public static IDataInfoNode createDataInfoNode(IDataProviderIdentifier iDataProviderIdentifier) throws Exception {
        IDataInfoNodeProvider iDataInfoNodeProvider;
        if (iDataProviderIdentifier != null && (iDataInfoNodeProvider = DataInfoNodeProviderFactory.getInstance().getDataNodeProvider(iDataProviderIdentifier.getType())) != null) {
            IDataProviderIdentifier iDataProviderIdentifier2 = iDataProviderIdentifier.derive();
            PropertiesOwner propertiesOwner = iDataProviderIdentifier2.getPropertiesOwner();
            return iDataInfoNodeProvider.createDataNode(iDataProviderIdentifier2.getName(), propertiesOwner.properties());
        }
        return null;
    }

    public static IDicomNode resolveAET(String string) {
        if (resolver == null) {
            return null;
        }
        return resolver.resolveAET(string);
    }

    public static void setAETResolver(IAETResolver iAETResolver) {
        resolver = iAETResolver;
    }

    public static IDataInfoSource cloneIfPossible(IDataInfoSource iDataInfoSource) {
        if (iDataInfoSource instanceof IPublicCloneable) {
            try {
                return (IDataInfoSource)((IPublicCloneable)((Object)iDataInfoSource)).clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                log.warn("Clone failed", (Throwable)cloneNotSupportedException);
                return iDataInfoSource;
            }
        }
        return iDataInfoSource;
    }

    public static List<IDataInfoNode> getSearchNodes(List<IDataInfoNode> list, boolean bl) {
        if (!bl) {
            return list;
        }
        ArrayList<IDataInfoNode> arrayList = new ArrayList<IDataInfoNode>();
        for (IDataInfoNode iDataInfoNode : list) {
            IDataInfoNode iDataInfoNode2 = null;
            try {
                try {
                    PropertiesOwner propertiesOwner;
                    String string;
                    IDataProviderIdentifier iDataProviderIdentifier = iDataInfoNode.getIdentifier();
                    if (iDataProviderIdentifier instanceof IDicomNode && (string = (propertiesOwner = iDataProviderIdentifier.getPropertiesOwner()).properties().getProperty("callingAET 2")) != null && string.length() > 0) {
                        IDataProviderIdentifier iDataProviderIdentifier2 = iDataProviderIdentifier.derive();
                        iDataProviderIdentifier2.getPropertiesOwner().properties().setProperty("callingAET", string);
                        iDataInfoNode2 = DataInfoNodeUtilities.createDataInfoNode(iDataProviderIdentifier2);
                    }
                }
                catch (Exception exception) {
                    log.warn("Inferring cloned dicom node having alternative calling AET failed!");
                    if (iDataInfoNode2 == null) {
                        iDataInfoNode2 = iDataInfoNode;
                    }
                    arrayList.add(iDataInfoNode2);
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (iDataInfoNode2 == null) {
                    iDataInfoNode2 = iDataInfoNode;
                }
                arrayList.add(iDataInfoNode2);
                throw throwable;
            }
            if (iDataInfoNode2 == null) {
                iDataInfoNode2 = iDataInfoNode;
            }
            arrayList.add(iDataInfoNode2);
        }
        return arrayList;
    }

    public static boolean containsNodeOfType(List<IDataInfoNode> list, String ... stringArray) {
        for (IDataInfoNode iDataInfoNode : list) {
            if (!ArrayUtils.contains((Object[])stringArray, (Object)iDataInfoNode.getIdentifier().getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNodeWeak(List<IDataInfoNode> list, IDataInfoNode iDataInfoNode) {
        if (iDataInfoNode == null) {
            return false;
        }
        return DataInfoNodeUtilities.containsNodeWeak(list, iDataInfoNode.getIdentifier().getType(), iDataInfoNode.getIdentifier().getName());
    }

    public static boolean containsNodeWeak(List<IDataInfoNode> list, String string, String string2) {
        if (list == null) {
            return false;
        }
        for (IDataInfoNode iDataInfoNode : list) {
            if (!string2.equals(iDataInfoNode.getIdentifier().getName()) || !string.equals(iDataInfoNode.getIdentifier().getType())) continue;
            return true;
        }
        return false;
    }
}

