/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.pixel;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.data.shared.pixel.ICacheStorageDecision;
import com.agfa.pacs.data.shared.pixel.IImagePixel;
import com.agfa.pacs.tools.Trilean;
import java.util.List;

public abstract class CacheStorageDecisionFactory {
    private static CacheStorageDecisionFactory implementation;

    public static synchronized CacheStorageDecisionFactory getInstance() {
        if (implementation == null) {
            CacheStorageDecisionFactory.initialize();
        }
        return implementation;
    }

    public boolean cacheDecompressedImages(IImagePixel iImagePixel) {
        List<ICacheStorageDecision> list = this.getStorageHandlerInt();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Trilean trilean = list.get(n2).cacheDecompressedImages(iImagePixel);
            if (trilean != Trilean.UNDEFINED) {
                return Trilean.toPrimitiveBoolean((Trilean)trilean);
            }
            ++n2;
        }
        return true;
    }

    public boolean cacheCompressedImages(IImagePixel iImagePixel) {
        for (ICacheStorageDecision iCacheStorageDecision : this.getStorageHandlerInt()) {
            Trilean trilean = iCacheStorageDecision.cacheCompressedImages(iImagePixel);
            if (trilean == Trilean.UNDEFINED) continue;
            return Trilean.toPrimitiveBoolean((Trilean)trilean);
        }
        return true;
    }

    public abstract List<ICacheStorageDecision> getStorageHandlerInt();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)CacheStorageDecisionFactory.class.getName()));
            implementation = (CacheStorageDecisionFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException2) {
            reflectiveOperationException = reflectiveOperationException2;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + CacheStorageDecisionFactory.class.getName(), reflectiveOperationException);
        }
    }
}

