/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.pixel;

import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.shared.pixel.PixelDataFrameProvider;
import com.agfa.pacs.logging.ALogger;
import java.util.HashMap;
import java.util.Map;

public class PixelDataConfiguration {
    private static final ALogger log = ALogger.getLogger(PixelDataConfiguration.class);
    public static final String CONFIG_ROOT = "com.agfa.pacs.data.pixeldata";
    public static final PixelDataConfiguration instance = PixelDataFrameProvider.getInstance().loadPixelDataConfiguration();
    private final String DECODER = "decoder";
    private final String ENCODER = "encoder";
    private final String MAPPING = "mapping";
    private IConfigurationProvider provider;
    private Map<String, String> decoderType;
    private Map<String, String> encoderType;

    public PixelDataConfiguration(IConfigurationProvider iConfigurationProvider) {
        this.provider = iConfigurationProvider;
    }

    public String getDecoderType(String string) {
        if (this.decoderType == null) {
            this.initDecoderType();
        }
        return this.decoderType.get(string);
    }

    public String getEncoderType(String string) {
        if (this.encoderType == null) {
            this.initEncoderType();
        }
        return this.encoderType.get(string);
    }

    private void initDecoderType() {
        try {
            IConfigurationProvider iConfigurationProvider = this.provider.getNode("decoder");
            this.decoderType = this.getMapping(iConfigurationProvider.getList("mapping"));
        }
        catch (Exception exception) {
            log.error("Exception during initDecoderType", (Throwable)exception);
        }
    }

    private void initEncoderType() {
        try {
            IConfigurationProvider iConfigurationProvider = this.provider.getNode("encoder");
            this.encoderType = this.getMapping(iConfigurationProvider.getList("mapping"));
        }
        catch (Exception exception) {
            log.error("Exception during initEncoderType", (Throwable)exception);
        }
    }

    private Map<String, String> getMapping(IConfigurationList iConfigurationList) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (IConfigurationProvider iConfigurationProvider : iConfigurationList) {
            String string = iConfigurationProvider.getString("transferSyntaxUID");
            String string2 = iConfigurationProvider.getString("providerType");
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public void reset() {
        this.decoderType = null;
        this.encoderType = null;
    }
}

