/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.pixel.decoder;

import com.agfa.pacs.cache.ByteArrayContainer;

public abstract class FixLSJpegData {
    private static final int SOI = 65496;
    private static final int SOF55 = 65527;
    private static final int SOS = 65498;
    private static final byte[] LSE_13;
    private static final byte[] LSE_14;
    private static final byte[] LSE_15;
    private static final byte[] LSE_16;
    private static final int LSE_INJECT_INDEX = 15;

    static {
        byte[] byArray = new byte[15];
        byArray[0] = -1;
        byArray[1] = -8;
        byArray[3] = 13;
        byArray[4] = 1;
        byArray[5] = 31;
        byArray[6] = -1;
        byArray[8] = 34;
        byArray[10] = -125;
        byArray[11] = 2;
        byArray[12] = 36;
        byArray[14] = 64;
        LSE_13 = byArray;
        byte[] byArray2 = new byte[15];
        byArray2[0] = -1;
        byArray2[1] = -8;
        byArray2[3] = 13;
        byArray2[4] = 1;
        byArray2[5] = 63;
        byArray2[6] = -1;
        byArray2[8] = 66;
        byArray2[9] = 1;
        byArray2[10] = 3;
        byArray2[11] = 4;
        byArray2[12] = 68;
        byArray2[14] = 64;
        LSE_14 = byArray2;
        byte[] byArray3 = new byte[15];
        byArray3[0] = -1;
        byArray3[1] = -8;
        byArray3[3] = 13;
        byArray3[4] = 1;
        byArray3[5] = 127;
        byArray3[6] = -1;
        byArray3[8] = -126;
        byArray3[9] = 2;
        byArray3[10] = 3;
        byArray3[11] = 8;
        byArray3[12] = -124;
        byArray3[14] = 64;
        LSE_15 = byArray3;
        byte[] byArray4 = new byte[15];
        byArray4[0] = -1;
        byArray4[1] = -8;
        byArray4[3] = 13;
        byArray4[4] = 1;
        byArray4[5] = -1;
        byArray4[6] = -1;
        byArray4[7] = 1;
        byArray4[8] = 2;
        byArray4[9] = 4;
        byArray4[10] = 3;
        byArray4[11] = 17;
        byArray4[12] = 4;
        byArray4[14] = 64;
        LSE_16 = byArray4;
    }

    public static byte[] patchJpegData(ByteArrayContainer byteArrayContainer) {
        byte[] byArray = FixLSJpegData.selectPatch(byteArrayContainer);
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byteArrayContainer.getDataLength() + byArray.length];
        System.arraycopy(byteArrayContainer.getData(), byteArrayContainer.getOffset(), byArray2, 0, 15);
        System.arraycopy(byArray, 0, byArray2, 15, byArray.length);
        System.arraycopy(byteArrayContainer.getData(), byteArrayContainer.getOffset() + 15, byArray2, 15 + byArray.length, byteArrayContainer.getDataLength() - 15);
        return byArray2;
    }

    public static byte[] patchJpegData(byte[] byArray) {
        return FixLSJpegData.patchJpegData(new ByteArrayContainer(byArray));
    }

    private static int toInt(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    private static byte[] selectPatch(ByteArrayContainer byteArrayContainer) {
        if (FixLSJpegData.toInt(byteArrayContainer.getData(), 0 + byteArrayContainer.getOffset()) != 65496) {
            return null;
        }
        if (FixLSJpegData.toInt(byteArrayContainer.getData(), 2 + byteArrayContainer.getOffset()) != 65527) {
            return null;
        }
        if (FixLSJpegData.toInt(byteArrayContainer.getData(), 4 + byteArrayContainer.getOffset()) != 11) {
            return null;
        }
        if (FixLSJpegData.toInt(byteArrayContainer.getData(), 15 + byteArrayContainer.getOffset()) != 65498) {
            return null;
        }
        switch (byteArrayContainer.getData()[6 + byteArrayContainer.getOffset()]) {
            case 13: {
                return LSE_13;
            }
            case 14: {
                return LSE_14;
            }
            case 15: {
                return LSE_15;
            }
            case 16: {
                return LSE_16;
            }
        }
        return null;
    }
}

