/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.pixel.decoder;

import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.data.shared.pixel.IImagePixel;
import com.agfa.pacs.data.shared.pixel.PixelDataConfiguration;
import com.agfa.pacs.data.shared.pixel.PixelDataException;
import com.agfa.pacs.data.shared.pixel.decoder.FixLSJpegData;
import com.agfa.pacs.data.shared.pixel.decoder.IPixelDataDecoder;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class PixelDataDecoderFactory {
    private static final ALogger log = ALogger.getLogger(PixelDataDecoderFactory.class);
    private static PixelDataDecoderFactory implementation;
    private Map<String, List<IPixelDataDecoder>> providerCache = new ConcurrentHashMap<String, List<IPixelDataDecoder>>();
    protected PixelDataConfiguration config = PixelDataConfiguration.instance;

    public static synchronized PixelDataDecoderFactory getInstance() {
        if (implementation == null) {
            PixelDataDecoderFactory.initialize();
        }
        return implementation;
    }

    public List<String> getSupportedTransferSyntaxUIDs() {
        return implementation.getSupportedTransferSyntaxUIDsInt();
    }

    public List<String> filterTransferSyntaxUIDs(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = this.getSupportedTransferSyntaxUIDs();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (list.contains(string)) {
                arrayList.add(string);
            }
            ++n2;
        }
        return arrayList;
    }

    public Object decode(IImagePixel iImagePixel, ByteArrayContainer byteArrayContainer, String string) throws PixelDataException {
        byte[] byArray;
        List<IPixelDataDecoder> list = this.getProvider(string);
        if (list == null) {
            throw new PixelDataException("no decoder for " + string);
        }
        Object object = list.get(0).decode(iImagePixel, byteArrayContainer, string);
        if (object == null) {
            log.warn("Could not decode image.Trying different decoder");
            int n = 1;
            while (object == null && n < list.size()) {
                object = list.get(n).decode(iImagePixel, byteArrayContainer, string);
                ++n;
            }
        }
        if (object == null && string.equals("1.2.840.10008.1.2.4.80") && (byArray = FixLSJpegData.patchJpegData(byteArrayContainer)) != null) {
            log.warn("Patched LS jpeg pixel data");
            int n = 0;
            while (object == null && n < list.size()) {
                object = list.get(n).decode(iImagePixel, byArray, string);
                ++n;
            }
        }
        return object;
    }

    public Object decode(IImagePixel iImagePixel, byte[] byArray, String string) throws PixelDataException {
        byte[] byArray2;
        List<IPixelDataDecoder> list = this.getProvider(string);
        if (list == null) {
            throw new PixelDataException("no decoder for " + string);
        }
        Object object = list.get(0).decode(iImagePixel, byArray, string);
        if (object == null) {
            log.warn("Could not decode image.Trying different decoder");
            int n = 1;
            while (object == null && n < list.size()) {
                object = list.get(n).decode(iImagePixel, byArray, string);
                ++n;
            }
        }
        if (object == null && string.equals("1.2.840.10008.1.2.4.80") && (byArray2 = FixLSJpegData.patchJpegData(byArray)) != null) {
            log.warn("Patched LS jpeg pixel data");
            int n = 0;
            while (object == null && n < list.size()) {
                object = list.get(n).decode(iImagePixel, byArray2, string);
                ++n;
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IPixelDataDecoder> getProvider(String string) {
        List<IPixelDataDecoder> list = this.providerCache.get(string);
        if (list != null) {
            return list;
        }
        List<IPixelDataDecoder> list2 = implementation.getIPixelDataDecoderFactoryInt(string);
        if (list2 == null || list2.size() == 0) {
            return null;
        }
        PixelDataDecoderFactory pixelDataDecoderFactory = this;
        synchronized (pixelDataDecoderFactory) {
            if (!this.providerCache.containsKey(string)) {
                this.providerCache.put(string, list2);
            }
        }
        return list2;
    }

    protected abstract List<String> getSupportedTransferSyntaxUIDsInt();

    protected abstract List<IPixelDataDecoder> getIPixelDataDecoderFactoryInt(String var1);

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)PixelDataDecoderFactory.class.getName()));
            implementation = (PixelDataDecoderFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException2) {
            reflectiveOperationException = reflectiveOperationException2;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + PixelDataDecoderFactory.class.getName(), reflectiveOperationException);
        }
    }
}

