/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.pixel.decoder;

import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.pixel.decoder.IPixelDataDecoder;
import com.agfa.pacs.data.shared.pixel.decoder.PixelDataDecoderFactory;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class PixelDataDecoderFactoryEclipseImpl
extends PixelDataDecoderFactory {
    private static final ALogger log = ALogger.getLogger(PixelDataDecoderFactoryEclipseImpl.class);
    private Hashtable<String, List<IPixelDataDecoder>> pixelDataDecoderFactories = new Hashtable();

    public PixelDataDecoderFactoryEclipseImpl() {
        Object object;
        Object object2;
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.agfa.pacs.data.shared.PixelDataDecoderProvider");
        Object object4 = iExtensionPoint.getExtensions();
        int n = ((IExtension[])object4).length;
        int n2 = 0;
        while (n2 < n) {
            IExtension object32 = object4[n2];
            object2 = object32.getConfigurationElements();
            int n3 = ((IConfigurationElement[])object2).length;
            int iPixelDataDecoder = 0;
            while (iPixelDataDecoder < n3) {
                object = object2[iPixelDataDecoder];
                try {
                    IPixelDataDecoder iPixelDataDecoder2 = (IPixelDataDecoder)object.createExecutableExtension("class");
                    if (iPixelDataDecoder2.getSupportedTransferSyntaxUIDs() != null) {
                        for (String string : iPixelDataDecoder2.getSupportedTransferSyntaxUIDs()) {
                            if (!this.pixelDataDecoderFactories.containsKey(string)) {
                                this.pixelDataDecoderFactories.put(string, new ArrayList());
                            }
                            this.pixelDataDecoderFactories.get(string).add(iPixelDataDecoder2);
                        }
                    }
                }
                catch (CoreException coreException) {
                    log.error("Factory exception", (Throwable)coreException);
                }
                ++iPixelDataDecoder;
            }
            ++n2;
        }
        for (Map.Entry<String, List<IPixelDataDecoder>> entry : this.pixelDataDecoderFactories.entrySet()) {
            List<IPixelDataDecoder> list = entry.getValue();
            if (list == null) continue;
            Collections.sort(list, new DecoderSorter(this.config.getDecoderType(entry.getKey())));
        }
        if (log.isDebugEnabled()) {
            Object object52;
            log.debug("--- PixelDataDecoder --- (begin)");
            List<String> list = this.getSupportedTransferSyntaxUIDsInt();
            log.debug("--- Available ---");
            for (Object object52 : list) {
                object4 = this.pixelDataDecoderFactories.get(object52);
                object = new StringBuffer();
                ((StringBuffer)object).append((String)object52);
                ((StringBuffer)object).append(" ... ");
                Iterator iterator = object4.iterator();
                while (iterator.hasNext()) {
                    IPixelDataDecoder iPixelDataDecoder = (IPixelDataDecoder)iterator.next();
                    ((StringBuffer)object).append(iPixelDataDecoder.getType());
                    ((StringBuffer)object).append(" ");
                }
                log.debug(((StringBuffer)object).toString());
            }
            log.debug("--- Configured ---");
            for (Object object52 : list) {
                object4 = this.getIPixelDataDecoderFactoryInt((String)object52);
                if (object4 == null || object4.size() == 0) {
                    log.debug(String.valueOf(object52) + " - ERROR - no decoder for this Transfer Syntax UID");
                    continue;
                }
                object = this.config.getDecoderType((String)object52);
                if (object == null) {
                    log.debug(String.valueOf(object52) + " ...... " + ((IPixelDataDecoder)object4.get(0)).getType() + " (default)");
                    continue;
                }
                IPixelDataDecoder iPixelDataDecoder = null;
                object2 = object4.iterator();
                while (object2.hasNext()) {
                    IPixelDataDecoder iPixelDataDecoder3 = (IPixelDataDecoder)object2.next();
                    if (!((String)object).equals(iPixelDataDecoder3.getType())) continue;
                    iPixelDataDecoder = iPixelDataDecoder3;
                    break;
                }
                if (iPixelDataDecoder != null) {
                    log.debug(String.valueOf(object52) + " ... " + iPixelDataDecoder.getType() + " (configured)");
                    continue;
                }
                log.debug(String.valueOf(object52) + " ...... " + ((IPixelDataDecoder)object4.get(0)).getType() + " (default, configured " + (String)object + " not found)");
            }
            log.debug("--- Not supported ---");
            object52 = UIDUtilities.getTransferSyntaxUIDs();
            object4 = object52.iterator();
            while (object4.hasNext()) {
                String object6 = (String)object4.next();
                if (list.contains(object6) || !UIDUtilities.isTransferSyntaxType(object6, UIDType.Image)) continue;
                log.info(String.valueOf(object6) + " is not supported by any decoder");
            }
            log.debug("--- PixelDataDecoder --- (end)");
        }
    }

    @Override
    protected List<String> getSupportedTransferSyntaxUIDsInt() {
        return new ArrayList<String>(this.pixelDataDecoderFactories.keySet());
    }

    @Override
    protected List<IPixelDataDecoder> getIPixelDataDecoderFactoryInt(String string) {
        return this.pixelDataDecoderFactories.get(string);
    }

    private static class DecoderSorter
    implements Comparator<IPixelDataDecoder> {
        private static final String SERVER = "SERVER";
        private String defaultType;

        public DecoderSorter(String string) {
            this.defaultType = string;
        }

        @Override
        public int compare(IPixelDataDecoder iPixelDataDecoder, IPixelDataDecoder iPixelDataDecoder2) {
            int n = 0;
            int n2 = 0;
            if (Objects.equals(this.defaultType, iPixelDataDecoder.getType())) {
                n = 1;
            }
            if (iPixelDataDecoder.getType().contains(SERVER)) {
                n = -1;
            }
            if (Objects.equals(this.defaultType, iPixelDataDecoder2.getType())) {
                n2 = 1;
            }
            if (iPixelDataDecoder2.getType().contains(SERVER)) {
                n2 = -1;
            }
            return n2 - n;
        }
    }
}

