/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.primitives;

import com.agfa.pacs.data.shared.primitives.IntCollection;
import com.agfa.pacs.data.shared.primitives.IntIterator;

abstract class AbstractIntCollection
implements IntCollection {
    protected AbstractIntCollection() {
    }

    @Override
    public boolean add(int n) {
        throw new UnsupportedOperationException("add(int) is not supported.");
    }

    @Override
    public boolean addAll(IntCollection intCollection) {
        boolean bl = false;
        IntIterator intIterator = intCollection.iterator();
        while (intIterator.hasNext()) {
            bl |= this.add(intIterator.next());
        }
        return bl;
    }

    @Override
    public void clear() {
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            intIterator.next();
            intIterator.remove();
        }
    }

    @Override
    public boolean contains(int n) {
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            if (intIterator.next() != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(IntCollection intCollection) {
        IntIterator intIterator = intCollection.iterator();
        while (intIterator.hasNext()) {
            if (this.contains(intIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean removeElement(int n) {
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            if (intIterator.next() != n) continue;
            intIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(IntCollection intCollection) {
        boolean bl = false;
        IntIterator intIterator = intCollection.iterator();
        while (intIterator.hasNext()) {
            bl |= this.removeElement(intIterator.next());
        }
        return bl;
    }

    @Override
    public boolean retainAll(IntCollection intCollection) {
        boolean bl = false;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            if (intCollection.contains(intIterator.next())) continue;
            intIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public int[] toArray() {
        int[] nArray = new int[this.size()];
        int n = 0;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            nArray[n] = intIterator.next();
            ++n;
        }
        return nArray;
    }

    @Override
    public int[] toArray(int[] nArray) {
        if (nArray.length < this.size()) {
            return this.toArray();
        }
        int n = 0;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            nArray[n] = intIterator.next();
            ++n;
        }
        return nArray;
    }
}

