/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.primitives;

import com.agfa.pacs.data.shared.primitives.PrimeFinder;
import org.apache.commons.lang3.exception.CloneFailedException;

public abstract class Hash
implements Cloneable {
    protected transient int _size;
    protected transient int _free;
    protected static final float DEFAULT_LOAD_FACTOR = 0.5f;
    protected static final int DEFAULT_INITIAL_CAPACITY = 10;
    protected float _loadFactor;
    protected int _maxSize;
    protected int _autoCompactRemovesRemaining;
    protected float _autoCompactionFactor;
    private boolean _autoCompactTemporaryDisable = false;

    public Hash() {
        this(10, 0.5f);
    }

    public Hash(int n) {
        this(n, 0.5f);
    }

    public Hash(int n, float f) {
        this._loadFactor = f;
        this._autoCompactionFactor = f;
        this.setUp((int)Math.ceil((float)n / f));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CloneFailedException("Cloning Hash failed", (Throwable)cloneNotSupportedException);
        }
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public int size() {
        return this._size;
    }

    protected abstract int capacity();

    public void ensureCapacity(int n) {
        if (n > this._maxSize - this.size()) {
            this.rehash(PrimeFinder.nextPrime((int)Math.ceil((float)n + (float)this.size() / this._loadFactor) + 1));
            this.computeMaxSize(this.capacity());
        }
    }

    public void compact() {
        this.rehash(PrimeFinder.nextPrime((int)Math.ceil((float)this.size() / this._loadFactor) + 1));
        this.computeMaxSize(this.capacity());
        if (this._autoCompactionFactor != 0.0f) {
            this.computeNextAutoCompactionAmount(this.size());
        }
    }

    public void setAutoCompactionFactor(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Factor must be >= 0: " + f);
        }
        this._autoCompactionFactor = f;
    }

    public float getAutoCompactionFactor() {
        return this._autoCompactionFactor;
    }

    public final void trimToSize() {
        this.compact();
    }

    protected void removeAt(int n) {
        --this._size;
        if (this._autoCompactionFactor != 0.0f) {
            --this._autoCompactRemovesRemaining;
            if (!this._autoCompactTemporaryDisable && this._autoCompactRemovesRemaining <= 0) {
                this.compact();
            }
        }
    }

    public void clear() {
        this._size = 0;
        this._free = this.capacity();
    }

    protected int setUp(int n) {
        int n2 = PrimeFinder.nextPrime(n);
        this.computeMaxSize(n2);
        this.computeNextAutoCompactionAmount(n);
        return n2;
    }

    protected abstract void rehash(int var1);

    protected void tempDisableAutoCompaction() {
        this._autoCompactTemporaryDisable = true;
    }

    protected void reenableAutoCompaction(boolean bl) {
        this._autoCompactTemporaryDisable = false;
        if (bl && this._autoCompactRemovesRemaining <= 0 && this._autoCompactionFactor != 0.0f) {
            this.compact();
        }
    }

    private final void computeMaxSize(int n) {
        this._maxSize = Math.min(n - 1, (int)Math.floor((float)n * this._loadFactor));
        this._free = n - this._size;
    }

    private void computeNextAutoCompactionAmount(int n) {
        if (this._autoCompactionFactor != 0.0f) {
            this._autoCompactRemovesRemaining = Math.round((float)n * this._autoCompactionFactor);
        }
    }

    protected final void postInsertHook(boolean bl) {
        if (bl) {
            --this._free;
        }
        if (++this._size > this._maxSize || this._free == 0) {
            int n = this._size > this._maxSize ? PrimeFinder.nextPrime(this.capacity() << 1) : this.capacity();
            this.rehash(n);
            this.computeMaxSize(this.capacity());
        }
    }

    protected int calculateGrownCapacity() {
        return this.capacity() << 1;
    }
}

