/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.properties;

import com.agfa.pacs.data.shared.properties.PropertiesOwner;
import java.util.Properties;

public abstract class AbstractPropertiesOwner
implements PropertiesOwner {
    protected static final String trueValue = "true";
    protected static final String falseValue = "false";
    protected static final String[] booleanValues = new String[]{"true", "false"};
    protected Properties properties;

    public AbstractPropertiesOwner(Properties properties) {
        this.properties = properties == null ? new Properties() : (Properties)properties.clone();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PropertiesOwner)) {
            return false;
        }
        PropertiesOwner propertiesOwner = (PropertiesOwner)object;
        return this.properties().equals(propertiesOwner.properties());
    }

    public int hashCode() {
        return this.properties.hashCode();
    }

    @Override
    public Properties properties() {
        return this.properties;
    }

    @Override
    public final boolean onlyOptionalProperties() {
        return this.getMandatoryPropertyList() == null;
    }

    @Override
    public final boolean requiresProperties() {
        return this.getMandatoryPropertyList() != null || this.getOptionalPropertyList() != null;
    }

    public String toString() {
        Object object;
        int n;
        if (this.getMandatoryPropertyList() == null) {
            return "[no mandatory properties]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.getMandatoryPropertyList();
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = stringArray2[n2];
                stringBuffer.append("*");
                stringBuffer.append((String)object);
                stringBuffer.append("=");
                stringBuffer.append(this.properties.getProperty((String)object));
                stringBuffer.append(" ");
                ++n2;
            }
        }
        if ((object = this.getOptionalPropertyList()) != null) {
            String[] stringArray3 = object;
            int n3 = ((String[])object).length;
            n = 0;
            while (n < n3) {
                String string = stringArray3[n];
                stringBuffer.append(string);
                stringBuffer.append("=");
                stringBuffer.append(this.properties.getProperty(string));
                stringBuffer.append(" ");
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    protected boolean resolveBoolean(String string) {
        String string2 = this.properties.getProperty(string);
        if (string2 == null) {
            string2 = this.getDefaultValue(string);
        }
        return trueValue.equals(string2);
    }

    protected String booleanToString(boolean bl) {
        return bl ? trueValue : falseValue;
    }
}

