/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.util;

import com.agfa.pacs.cache.ByteArrayContainer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ByteArrayOutputStreamNonCopying
extends ByteArrayOutputStream {
    public ByteArrayOutputStreamNonCopying(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n);
        }
        this.buf = new byte[n];
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) {
        if (this.buf == null) {
            throw new IllegalStateException("Closed");
        }
        super.write(byArray, n, n2);
    }

    @Override
    public synchronized void write(int n) {
        if (this.buf == null) {
            throw new IllegalStateException("Closed");
        }
        super.write(n);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        if (this.buf == null) {
            throw new IllegalStateException("Closed");
        }
        super.write(byArray);
    }

    @Override
    public synchronized void writeTo(OutputStream outputStream) throws IOException {
        if (this.buf == null) {
            throw new IllegalStateException("Closed");
        }
        super.writeTo(outputStream);
    }

    public synchronized ByteArrayContainer toByteContainerAndClose() {
        ByteArrayContainer byteArrayContainer = new ByteArrayContainer(this.buf, 0, this.count);
        this.buf = null;
        return byteArrayContainer;
    }

    @Override
    public synchronized byte[] toByteArray() {
        if (this.buf == null) {
            throw new IllegalStateException("Closed");
        }
        return super.toByteArray();
    }
}

