/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.util;

import com.agfa.pacs.data.shared.util.IDicomObjectCoercer;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class LWDataCorrection {
    private static final ALogger log = ALogger.getLogger(LWDataCorrection.class);
    private static List<IDicomObjectCoercer> coercers = LWDataCorrection.initCoercers();

    public static void correctHeader(Attributes attributes) {
        List<IDicomObjectCoercer> list = coercers;
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            list.get(n2).coerce(attributes);
            ++n2;
        }
    }

    private static List<IDicomObjectCoercer> initCoercers() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.agfa.pacs.data.shared.DicomObjectCoercer");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        if (iExtensionArray == null) {
            return Collections.emptyList();
        }
        ArrayList<IDicomObjectCoercer> arrayList = new ArrayList<IDicomObjectCoercer>(iExtensionArray.length);
        IExtension[] iExtensionArray2 = iExtensionArray;
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension iExtension = iExtensionArray2[n2];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            if (iConfigurationElementArray != null) {
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray;
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n4];
                    String string = iConfigurationElement.getAttribute("class");
                    try {
                        arrayList.add((IDicomObjectCoercer)iConfigurationElement.createExecutableExtension("class"));
                        log.debug("initialized coercer: " + string);
                    }
                    catch (CoreException coreException) {
                        log.error("failed to initialize coercer: " + string, (Throwable)coreException);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return arrayList;
    }

    public static void postProcessHeaderUncoerced(Attributes attributes) {
        String string = attributes.getString(131088);
        if ("1.2.840.10008.1.2.1.99".equals(string)) {
            attributes.setString(131088, VR.UI, "1.2.840.10008.1.2.1");
        }
        if (attributes.containsValue(2621697)) {
            LWDataCorrection.prepareHeader(attributes);
        } else if (attributes.containsValue(2621698)) {
            attributes.setInt(2621697, VR.US, new int[]{attributes.getInt(2621698, 1) + 1});
            LWDataCorrection.prepareHeader(attributes);
        }
    }

    private static void prepareHeader(Attributes attributes) {
        int n;
        String string;
        int n2 = attributes.getInt(2621697, 0);
        int n3 = attributes.getInt(2621698, 0);
        int n4 = n3;
        if (n4 != n2 - 1) {
            n4 = n2 - 1;
        }
        if ((string = attributes.getString(2621444)) != null && string.equals("YBR_RCT")) {
            attributes.setString(2621444, VR.CS, "RGB");
        }
        if ((n = attributes.getInt(2621699, 0)) == 1) {
            attributes.setInt("AgilityRuntime", 2686996, VR.US, new int[]{n});
            attributes.setInt(2621699, VR.US, new int[]{0});
            attributes.setInt("AgilityRuntime", 2686992, VR.UL, new int[]{1 << n4});
        }
        if (n4 != n3) {
            attributes.setInt(2621698, VR.US, new int[]{n4});
            attributes.setInt("AgilityRuntime", 2686995, VR.US, new int[]{n3});
        }
    }
}

