/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.util;

import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.cache.IDataCacheProvider;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.Arrays;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class OverlayUtils {
    private static final ALogger LOGGER = ALogger.getLogger(OverlayUtils.class);
    private static final IDataCacheProvider cache = DataCacheProviderFactory.getCache();

    public static void extractBitmapOverlays(Attributes attributes) {
        if (!attributes.containsTagInRange(0x60003000, 1612591104)) {
            return;
        }
        int n = 0;
        while (n < 16) {
            int n2 = n * 2 << 16;
            int n3 = 0x60003000 + n2;
            if (attributes.contains(n3)) {
                byte[] byArray;
                try {
                    byArray = attributes.getBytes(n3);
                }
                catch (IOException iOException) {
                    LOGGER.error("Bulk data error", (Throwable)iOException);
                    return;
                }
                if (byArray != null) {
                    CacheID cacheID = OverlayUtils.getOverlayCacheID(attributes, n2);
                    if (byArray.length != 0) {
                        if (!OverlayUtils.isAlreadyInCache(attributes, n2, cacheID)) {
                            VR vR = attributes.getVR(n3);
                            if (vR == VR.OW && attributes.bigEndian()) {
                                byArray = OverlayUtils.changeByteOrderToLittleEndian(byArray);
                            }
                            cache.addPersistentObject((Object)new ByteArrayContainer(byArray), cacheID);
                            byArray = null;
                        }
                        attributes.setNull(n3, VR.OB);
                    }
                }
            }
            ++n;
        }
    }

    private static boolean isAlreadyInCache(Attributes attributes, int n, CacheID cacheID) {
        return cache.exists(ByteArrayContainer.class, cacheID);
    }

    private static byte[] changeByteOrderToLittleEndian(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        short s = 0;
        int n = 0;
        while (n < byArray.length) {
            if (n % 2 != 0) {
                s = (short)(s | byArray[n]);
                shortBuffer.put(s);
            } else {
                s = (short)(byArray[n] << 8);
            }
            ++n;
        }
        byte[] byArray2 = byteBuffer.array();
        return byArray2;
    }

    public static CacheID getOverlayCacheID(String string, String string2, int n) {
        return cache.createID(string, String.valueOf(string2) + "o" + n, 1);
    }

    private static CacheID getOverlayCacheID(Attributes attributes, int n) {
        String string = attributes.getString(524312);
        String string2 = attributes.getString(0x20000D);
        if (string2 == null) {
            throw new IllegalArgumentException("Study Instance UID must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("UID must not be null");
        }
        return OverlayUtils.getOverlayCacheID(string2, string, n);
    }

    public static boolean containsBitmapOverlays(Attributes attributes) {
        return attributes.containsTagInRange(1610612994, 1612579074);
    }

    public static void addCachedOverlayData(Attributes attributes) {
        if (!attributes.containsTagInRange(0x60000040, 1612578880)) {
            return;
        }
        int n = 0;
        while (n < 16) {
            int n2;
            int n3 = n * 2 << 16;
            if (attributes.contains(0x60000040 + n3) && !attributes.containsValue(0x60003000 + n3) && (n2 = attributes.getInt(1610612994 + n3, 0)) == 0) {
                CacheID cacheID = OverlayUtils.getOverlayCacheID(attributes, n3);
                ByteArrayContainer byteArrayContainer = null;
                if (cache.exists(ByteArrayContainer.class, cacheID)) {
                    byteArrayContainer = (ByteArrayContainer)cache.referencePersistentObject(cacheID, ByteArrayContainer.class);
                }
                if (byteArrayContainer != null) {
                    try {
                        attributes.setBytes(0x60003000 + n3, VR.OB, Arrays.copyOfRange(byteArrayContainer.data, byteArrayContainer.offset, byteArrayContainer.length + byteArrayContainer.offset));
                        byteArrayContainer = null;
                    }
                    finally {
                        cache.releaseReference(cacheID);
                    }
                } else {
                    LOGGER.error("Overlay bitplane '{}' for '{} / {} / {}' not found in cache.", new Object[]{n3, attributes.getString(0x20000D, null), attributes.getString(0x20000E, null), attributes.getString(524312, null)});
                }
            }
            ++n;
        }
    }

    public static ByteArrayContainer getBitmapOverlay(CacheID cacheID) {
        String string = cacheID.getGroup();
        if (string != null) {
            return (ByteArrayContainer)cache.referencePersistentObject(cacheID, ByteArrayContainer.class);
        }
        return new ByteArrayContainer(cache.referencePersistentBytes(cacheID));
    }

    public static void putBitmapOverlay(CacheID cacheID, byte[] byArray) {
        String string = cacheID.getGroup();
        if (string != null) {
            cache.addPersistentObject((Object)new ByteArrayContainer(byArray), cacheID);
        } else {
            cache.addPersistentBytes(byArray, cacheID);
        }
    }
}

