/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.util;

import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.tools.CompareUtils;
import java.util.Comparator;
import java.util.Locale;
import org.dcm4che3.data.Attributes;

public class PatientComparatorFactory {
    private PatientComparatorFactory() {
    }

    public static Comparator<Attributes> getPatientAttributesComparator() {
        return PatientAttributesComparator.INSTANCE;
    }

    public static Comparator<IPatientInfo> getPatientInfoComparator() {
        return PatientInfoComparator.INSTANCE;
    }

    private static abstract class AbstractPatientComparator<T>
    implements Comparator<T> {
        private AbstractPatientComparator() {
        }

        @Override
        public int compare(T t, T t2) {
            if (t == null && t2 == null) {
                return 0;
            }
            if (t == null) {
                return -1;
            }
            if (t2 == null) {
                return 1;
            }
            return this.compareInt(t, t2);
        }

        abstract int compareInt(T var1, T var2);
    }

    private static class PatientAttributesComparator
    extends AbstractPatientComparator<Attributes> {
        static final PatientAttributesComparator INSTANCE = new PatientAttributesComparator();

        private PatientAttributesComparator() {
        }

        @Override
        int compareInt(Attributes attributes, Attributes attributes2) {
            int n = this.compareByTag(attributes, attributes2, 0x100010);
            if (n == 0 && (n = this.compareByTag(attributes, attributes2, 0x100020)) == 0) {
                n = this.compareByTag(attributes, attributes2, 0x100021);
            }
            return n;
        }

        private int compareByTag(Attributes attributes, Attributes attributes2, int n) {
            return CompareUtils.compareAdvanced((Comparable)((Object)PatientAttributesComparator.toUpperCase(attributes.getString(n))), (Comparable)((Object)PatientAttributesComparator.toUpperCase(attributes2.getString(n))));
        }

        private static String toUpperCase(String string) {
            if (string == null) {
                return null;
            }
            return string.toUpperCase(Locale.getDefault());
        }
    }

    private static class PatientInfoComparator
    extends AbstractPatientComparator<IPatientInfo> {
        static final PatientInfoComparator INSTANCE = new PatientInfoComparator();

        private PatientInfoComparator() {
        }

        @Override
        int compareInt(IPatientInfo iPatientInfo, IPatientInfo iPatientInfo2) {
            Attributes attributes = iPatientInfo.getAttributes();
            Attributes attributes2 = iPatientInfo2.getAttributes();
            return PatientAttributesComparator.INSTANCE.compare(attributes, attributes2);
        }
    }
}

