/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.util;

import com.agfa.pacs.tools.DoubleEquals;
import java.util.Arrays;

public class SliceDistanceChecker {
    private static final double SLICE_DISTANCE_TOLERANCE = 0.02;

    public static SliceDistanceType getUniqueSliceDistances(double[] dArray, double[] dArray2, Double d) {
        return SliceDistanceChecker.getUniqueSliceDistances(dArray, dArray2, d, false);
    }

    public static SliceDistanceType getUniqueSliceDistances(double[] dArray, double[] dArray2, Double d, boolean bl) {
        double d2 = d == null ? 0.02 : d;
        int n = 0;
        int n2 = 1;
        while (n2 < dArray.length) {
            double d3 = dArray[n2] - dArray[n2 - 1];
            if (!bl || !DoubleEquals.equals((double)d3, (double)0.0)) {
                int n3 = 0;
                while (n3 < n) {
                    double d4 = Math.abs(d3 - dArray2[n3]);
                    if (d4 < d2) break;
                    ++n3;
                }
                if (n3 == n) {
                    dArray2[n] = d3;
                    ++n;
                }
            }
            ++n2;
        }
        return SliceDistanceChecker.evaluateAndSortDistances(n, dArray2);
    }

    private static SliceDistanceType evaluateAndSortDistances(int n, double[] dArray) {
        boolean bl = SliceDistanceChecker.checkForMultiples(n, dArray);
        if (!bl && n > 1) {
            return SliceDistanceType.IRREGULAR;
        }
        if (bl) {
            return SliceDistanceType.ALL_MULTIPLE_OF_SMALLEST;
        }
        return SliceDistanceType.ALL_EQUAL;
    }

    private static boolean checkForMultiples(int n, double[] dArray) {
        if (dArray == null || dArray.length < n || n == 1) {
            return false;
        }
        Arrays.sort(dArray, 0, n);
        double d = dArray[0];
        int n2 = 1;
        while (n2 < n) {
            double d2 = dArray[n2] - (double)Math.round(dArray[n2] / d) * d;
            if (d2 > 0.02 || d2 < -0.02) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static enum SliceDistanceType {
        ALL_EQUAL,
        ALL_MULTIPLE_OF_SMALLEST,
        IRREGULAR;

    }
}

