/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.util;

import com.agfa.pacs.data.shared.util.ISplittedOutputStreamListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SplittedOutputStream
extends OutputStream {
    private OutputStream outputStream;
    private ISplittedOutputStreamListener listener;
    private int index;
    private int limit;
    private int written;
    private boolean split;
    private ByteArrayOutputStream splitOutputStream;

    public SplittedOutputStream(ISplittedOutputStreamListener iSplittedOutputStreamListener, int n) {
        this.listener = iSplittedOutputStreamListener;
        this.index = -1;
        this.limit = n;
        this.split = true;
        this.splitOutputStream = null;
        this.outputStream = null;
        this.getNextOutputStream();
    }

    private synchronized void getNextOutputStream() {
        if (this.outputStream != null) {
            this.listener.finishOutputStream(this.index, false);
        }
        ++this.index;
        this.outputStream = this.listener.getOutputStream(this.index);
        this.written = 0;
    }

    public void setSplit(boolean bl) throws IOException {
        if (this.split == bl) {
            return;
        }
        this.split = bl;
        if (bl) {
            if (this.splitOutputStream != null) {
                byte[] byArray = this.splitOutputStream.toByteArray();
                if (this.written + byArray.length > this.limit) {
                    this.getNextOutputStream();
                }
                this.outputStream.write(byArray, 0, byArray.length);
                this.written += byArray.length;
            }
            this.splitOutputStream = null;
        } else {
            this.splitOutputStream = new ByteArrayOutputStream();
        }
    }

    public boolean isSplit() {
        return this.split;
    }

    @Override
    public void write(int n) throws IOException {
        if (this.split) {
            if (this.written > this.limit) {
                this.getNextOutputStream();
            }
            this.outputStream.write(n);
            ++this.written;
        } else {
            this.splitOutputStream.write(n);
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.split) {
            if (this.written + n2 > this.limit) {
                int n3 = this.limit - this.written;
                this.outputStream.write(byArray, n, n3);
                this.getNextOutputStream();
                n += n3;
                n2 -= n3;
            }
            this.outputStream.write(byArray, n, n2);
            this.written += n2;
        } else {
            this.splitOutputStream.write(byArray, n, n2);
        }
    }

    @Override
    public void close() throws IOException {
        this.listener.finishOutputStream(this.index, true);
        ++this.index;
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }
}

