/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.auditing;

import com.agfa.pacs.auditing.IAuditing;
import com.agfa.pacs.auditing.ReferencedData;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.URLProviderFactory;
import com.agfa.pacs.tools.ComputerName;
import java.io.IOException;
import java.net.InetAddress;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.AuditSourceIdentification;
import org.dcm4che3.audit.EventID;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.EventTypeCode;
import org.dcm4che3.audit.ParticipantObjectIDTypeCode;
import org.dcm4che3.audit.ParticipantObjectIdentification;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DeviceExtension;
import org.dcm4che3.net.IncompatibleConnectionException;
import org.dcm4che3.net.audit.AuditLogger;
import org.dcm4che3.net.audit.AuditRecordRepository;

public class Auditing
implements IAuditing {
    private static final ALogger LOG = ALogger.getLogger(Auditing.class);
    private static final String APPLICATION_NAME = "IMPAX_EE";
    private static final String APPLICATION_CODE_SYSTEM_NAME = "IMPAXEE";
    private static final String APPLICATION_DISPLAY_NAME = "ImpaxEE";
    private static final String CUSTOM_EVENTID_CODE = "AGFA99999";
    private static final String CUSTOM_EVENTID__CodeSystemName = "AGFA_IMPAXEE_ERROR";
    private static final String CUSTOM_EVENTID__DisplayName = "Agfa ImpaxEE Error";
    private static final String CustomParticipantObject_Id = "Custom ImpaxEE Error";
    private static final String CustomParticipantObject_Name = "Custom ImpaxEE Error";
    private static final String CustomParticipantObject_TypeCode_Code = "CUSTOM_IMPAXEE_ERROR_99999";
    private static final String CustomParticipantObject_TypeCode_CodeSystemName = "CUSTOM_IMPAXEE_ERROR_99999";
    private static final String CustomParticipantObject_TypeCode_DisplayName = "Custom ImpaxEE Error";
    private static final AuditMessages.ParticipantObjectIDTypeCode OVERALL_TIME_PARTICIPANT_OBJECT_ID_TYPE_CODE = new AuditMessages.ParticipantObjectIDTypeCode("1001001", "ImpaxEE", "Overall Transfer Time");
    private String[] callingAETs = null;
    private boolean useable = false;
    private String userID;
    private String processID;
    private String computerName;
    private boolean emergencyMode;
    private AuditLogger audit = new AuditLogger();
    private TrustManager tm = null;
    private KeyManager km = null;

    public Auditing() {
        this.audit.setApplicationName(APPLICATION_NAME);
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig().getNode("auditing");
        String string = iConfigurationProvider.getString("host");
        int n = (int)iConfigurationProvider.getLong("port");
        String string2 = iConfigurationProvider.getString("protocol");
        Connection.Protocol protocol = Connection.Protocol.SYSLOG_UDP;
        if (!string2.equalsIgnoreCase("UDP")) {
            protocol = Connection.Protocol.SYSLOG_TLS;
        }
        this.init(string, n, protocol);
    }

    public Auditing(String string, String string2, int n, Connection.Protocol protocol) {
        this.audit.setApplicationName(string);
        this.init(string2, n, protocol);
    }

    private void init(String string, int n, Connection.Protocol protocol) {
        this.audit.setFormatXML(true);
        AuditLogger.setDefaultLogger((AuditLogger)this.audit);
        this.userID = Auditing.getUserID();
        this.processID = AuditLogger.processID();
        this.computerName = Auditing.getComputerName();
        if (string.contains(":")) {
            string = string.substring(0, string.indexOf(58));
            LOG.info("Incorrect host, port information cutted out.");
        }
        if (string.length() > 0) {
            try {
                InetAddress.getByName(string);
                Device device = new Device("ARR");
                AuditRecordRepository auditRecordRepository = new AuditRecordRepository();
                device.addDeviceExtension((DeviceExtension)auditRecordRepository);
                Connection connection = new Connection("audit", string, n);
                connection.setProtocol(protocol);
                Connection connection2 = new Connection("audit-udp", "localhost", -1);
                connection2.setClientBindAddress("0.0.0.0");
                connection2.setProtocol(protocol);
                device.addConnection(connection2);
                device.addConnection(connection);
                auditRecordRepository.addConnection(connection);
                if (this.tm != null) {
                    device.setTrustManager(this.tm);
                }
                if (this.km != null) {
                    device.setKeyManager(this.km);
                }
                device.addDeviceExtension((DeviceExtension)this.audit);
                this.audit.addConnection(connection2);
                this.audit.setAuditSourceTypeCodes(new String[]{"4"});
                this.audit.setAuditRecordRepositoryDevice(device);
                this.useable = true;
                this.audit.setAuditLoggerInstalled(Boolean.valueOf(true));
            }
            catch (Exception exception) {
                this.useable = false;
                LOG.error("AuditLogger instantiation failed: Configured host not resolvable!", (Throwable)exception);
            }
        } else {
            this.useable = false;
            LOG.warn("Not sending Syslog packages as target a localhost");
        }
    }

    public void setTLSEnabled(TrustManager trustManager, KeyManager keyManager) {
        this.tm = trustManager;
        this.km = keyManager;
    }

    public boolean isUseable() {
        return this.useable;
    }

    public boolean isEmergencyModeEnabled() {
        return this.emergencyMode;
    }

    public void setEmergencyModeEnabled(boolean bl) {
        this.emergencyMode = bl;
    }

    public void logApplicationShutdown(String string) {
        this.logApplicationActivity(string, false);
    }

    public void logApplicationStartup(String string) {
        this.logApplicationActivity(string, true);
    }

    public void logStudyUsed(List<? extends Attributes> list) {
        if (this.useable) {
            try {
                AuditMessage auditMessage = new AuditMessage();
                EventIdentification eventIdentification = AuditMessages.createEventIdentification((AuditMessages.EventID)AuditMessages.EventID.DICOMInstancesAccessed, (String)"R", (Calendar)Calendar.getInstance(), (String)"0", null, (EventTypeCode[])new EventTypeCode[0]);
                if (this.emergencyMode) {
                    eventIdentification.getEventTypeCode().add(AuditMessages.EventTypeCode.UseOfRestrictedFunction);
                }
                auditMessage.setEventIdentification(eventIdentification);
                this.addReferencedData(list, auditMessage);
                this.sendAuditMessage(auditMessage);
            }
            catch (Exception exception) {
                LOG.error("Study used logging failed", (Throwable)exception);
            }
        }
    }

    private void logApplicationActivity(String string, boolean bl) {
        if (this.useable) {
            AuditMessage auditMessage = new AuditMessage();
            EventIdentification eventIdentification = AuditMessages.createEventIdentification((AuditMessages.EventID)AuditMessages.EventID.ApplicationActivity, (String)"E", null, (String)"0", null, (EventTypeCode[])new EventTypeCode[0]);
            eventIdentification.getEventTypeCode().add(bl ? AuditMessages.EventTypeCode.ApplicationStart : AuditMessages.EventTypeCode.ApplicationStop);
            auditMessage.setEventIdentification(eventIdentification);
            String string2 = System.getProperty("user.name");
            ActiveParticipant activeParticipant = new ActiveParticipant();
            activeParticipant.setUserID(string2);
            activeParticipant.setUserIsRequestor(true);
            auditMessage.getActiveParticipant().add(activeParticipant);
            ActiveParticipant activeParticipant2 = new ActiveParticipant();
            activeParticipant2.setUserID(string);
            if (this.getCallingAETs() != null) {
                activeParticipant2.setAlternativeUserID(AuditMessages.alternativeUserIDForAETitle((String[])this.getCallingAETs()));
            }
            auditMessage.getActiveParticipant().add(activeParticipant2);
            this.sendAuditMessage(auditMessage);
        }
    }

    public void logBeginSendDICOMInstances(String string, String string2, String string3, String string4, String string5, String string6, List<? extends Attributes> list) {
        if (this.useable) {
            AuditMessage auditMessage = this.createDICOMSendAuditMessage(AuditMessages.EventID.BeginTransferringDICOMInstances, string, string2, string3, string4, string5, string6);
            this.addReferencedData(list, auditMessage);
            this.sendAuditMessage(auditMessage);
        }
    }

    public void logNodeAuthenticationFailure(String string, String string2) {
        if (this.useable) {
            AuditMessage auditMessage = new AuditMessage();
            EventIdentification eventIdentification = AuditMessages.createEventIdentification((AuditMessages.EventID)AuditMessages.EventID.SecurityAlert, (String)"E", null, (String)"4", null, (EventTypeCode[])new EventTypeCode[0]);
            eventIdentification.getEventTypeCode().add(AuditMessages.EventTypeCode.NodeAuthentication);
            auditMessage.setEventIdentification(eventIdentification);
            ActiveParticipant activeParticipant = new ActiveParticipant();
            activeParticipant.setNetworkAccessPointID(string);
            activeParticipant.setUserID(string);
            activeParticipant.setUserName(string2);
            auditMessage.getActiveParticipant().add(activeParticipant);
            this.sendAuditMessage(auditMessage);
        }
    }

    public AuditMessage logSendedDICOMInstances(String string, String string2, String string3, String string4, String string5, String string6, List<? extends Attributes> list) {
        return this.logSendedDICOMInstances(string, string2, string3, string4, string5, string6, list, null);
    }

    public AuditMessage logSendedDICOMInstances(String string, String string2, String string3, String string4, String string5, String string6, List<? extends Attributes> list, Long l) {
        ReferencedData referencedData = this.prepareReferencedData(list);
        AuditMessage auditMessage = this.createDICOMSendAuditMessage(AuditMessages.EventID.DICOMInstancesTransferred, string, string2, string3, string4, string5, string6);
        referencedData.addToMessage(auditMessage);
        if (l != null) {
            ParticipantObjectIdentification participantObjectIdentification = new ParticipantObjectIdentification();
            participantObjectIdentification.setParticipantObjectID(l + " ms");
            participantObjectIdentification.setParticipantObjectIDTypeCode((ParticipantObjectIDTypeCode)OVERALL_TIME_PARTICIPANT_OBJECT_ID_TYPE_CODE);
            participantObjectIdentification.setParticipantObjectTypeCode("2");
            participantObjectIdentification.setParticipantObjectTypeCodeRole("3");
            auditMessage.getParticipantObjectIdentification().add(participantObjectIdentification);
        }
        return auditMessage;
    }

    private AuditMessage createDICOMSendAuditMessage(AuditMessages.EventID eventID, String string, String string2, String string3, String string4, String string5, String string6) {
        AuditMessage auditMessage = new AuditMessage();
        EventIdentification eventIdentification = AuditMessages.createEventIdentification((AuditMessages.EventID)eventID, (String)"E", null, (String)"0", null, (EventTypeCode[])new EventTypeCode[0]);
        if (this.emergencyMode) {
            eventIdentification.getEventTypeCode().add(AuditMessages.EventTypeCode.UseOfRestrictedFunction);
        }
        auditMessage.setEventIdentification(eventIdentification);
        ActiveParticipant activeParticipant = new ActiveParticipant();
        activeParticipant.setUserID(string);
        activeParticipant.setAlternativeUserID(AuditMessages.alternativeUserIDForAETitle((String[])new String[]{string3}));
        activeParticipant.setNetworkAccessPointID(string2);
        activeParticipant.getRoleIDCode().add(AuditMessages.RoleIDCode.Destination);
        auditMessage.getActiveParticipant().add(activeParticipant);
        if (string6 == null) {
            string6 = this.callingAETs[0];
        }
        ActiveParticipant activeParticipant2 = new ActiveParticipant();
        activeParticipant2.setUserID(string4 != null ? string4 : string6);
        activeParticipant2.setNetworkAccessPointID(string5 != null ? string5 : this.computerName);
        activeParticipant2.setAlternativeUserID(AuditMessages.alternativeUserIDForAETitle((String[])new String[]{string6}));
        activeParticipant2.getRoleIDCode().add(AuditMessages.RoleIDCode.Source);
        if (Arrays.asList(this.callingAETs).contains(string6)) {
            activeParticipant2.setUserIsRequestor(true);
        }
        auditMessage.getActiveParticipant().add(activeParticipant2);
        return auditMessage;
    }

    public AuditMessage logDataExportToPerson(List<? extends Attributes> list, String string, String string2, String string3) {
        AuditMessage auditMessage = new AuditMessage();
        ActiveParticipant activeParticipant = new ActiveParticipant();
        activeParticipant.setUserID(string);
        activeParticipant.setUserName(string2);
        activeParticipant.setNetworkAccessPointID(string3);
        auditMessage.getActiveParticipant().add(activeParticipant);
        return this.logDataExportImpl(list, auditMessage);
    }

    public void logAuditMessage(AuditMessage auditMessage, String string) {
        if (this.useable && auditMessage != null) {
            auditMessage.getEventIdentification().setEventOutcomeIndicator(string);
            this.sendAuditMessage(auditMessage);
        }
    }

    private void sendAuditMessage(AuditMessage auditMessage) {
        AuditSourceIdentification auditSourceIdentification = new AuditSourceIdentification();
        auditSourceIdentification.setAuditSourceID(this.computerName);
        auditSourceIdentification.getAuditSourceTypeCode().add(AuditMessages.AuditSourceTypeCode.EndUserDisplayDevice);
        auditMessage.getAuditSourceIdentification().add(auditSourceIdentification);
        ActiveParticipant activeParticipant = new ActiveParticipant();
        activeParticipant.setUserID(this.userID);
        activeParticipant.setAlternativeUserID(this.processID);
        activeParticipant.setUserIsRequestor(true);
        activeParticipant.setNetworkAccessPointID(this.computerName);
        activeParticipant.setNetworkAccessPointTypeCode("1");
        auditMessage.getActiveParticipant().add(activeParticipant);
        try {
            this.audit.write(Calendar.getInstance(), auditMessage);
        }
        catch (IncompatibleConnectionException incompatibleConnectionException) {
            LOG.error("Could not find connection", (Throwable)incompatibleConnectionException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            LOG.error("Encryption error", (Throwable)generalSecurityException);
        }
        catch (IOException iOException) {
            LOG.error("IOException error", (Throwable)iOException);
        }
    }

    public AuditMessage logDataExport(List<? extends Attributes> list, String string, String string2) {
        AuditMessage auditMessage = new AuditMessage();
        ActiveParticipant activeParticipant = new ActiveParticipant();
        activeParticipant.setUserID(string2);
        activeParticipant.getRoleIDCode().add(AuditMessages.RoleIDCode.DestinationMedia);
        auditMessage.getActiveParticipant().add(activeParticipant);
        ActiveParticipant activeParticipant2 = new ActiveParticipant();
        activeParticipant2.setUserID(string);
        activeParticipant2.getRoleIDCode().add(AuditMessages.RoleIDCode.Source);
        auditMessage.getActiveParticipant().add(activeParticipant2);
        return this.logDataExportImpl(list, auditMessage);
    }

    private void addReferencedData(List<? extends Attributes> list, AuditMessage auditMessage) {
        ReferencedData referencedData = new ReferencedData();
        referencedData.addData(list);
        referencedData.addToMessage(auditMessage);
    }

    public ReferencedData prepareReferencedData(List<? extends Attributes> list) {
        ReferencedData referencedData = new ReferencedData();
        referencedData.addData(list);
        return referencedData;
    }

    private AuditMessage logDataExportImpl(List<? extends Attributes> list, AuditMessage auditMessage) {
        EventIdentification eventIdentification = AuditMessages.createEventIdentification((AuditMessages.EventID)AuditMessages.EventID.Export, (String)"E", null, (String)"0", null, (EventTypeCode[])new EventTypeCode[0]);
        if (this.emergencyMode) {
            eventIdentification.getEventTypeCode().add(AuditMessages.EventTypeCode.UseOfRestrictedFunction);
        }
        auditMessage.setEventIdentification(eventIdentification);
        this.addReferencedData(list, auditMessage);
        return auditMessage;
    }

    public AuditMessage logDataImport(List<? extends Attributes> list, String string, String string2) {
        AuditMessage auditMessage = new AuditMessage();
        EventIdentification eventIdentification = AuditMessages.createEventIdentification((AuditMessages.EventID)AuditMessages.EventID.Import, (String)"E", null, (String)"0", null, (EventTypeCode[])new EventTypeCode[0]);
        auditMessage.setEventIdentification(eventIdentification);
        ActiveParticipant activeParticipant = new ActiveParticipant();
        activeParticipant.setUserID(string);
        activeParticipant.getRoleIDCode().add(AuditMessages.RoleIDCode.SourceMedia);
        auditMessage.getActiveParticipant().add(activeParticipant);
        ActiveParticipant activeParticipant2 = new ActiveParticipant();
        activeParticipant2.setUserID(string2);
        activeParticipant2.getRoleIDCode().add(AuditMessages.RoleIDCode.Destination);
        auditMessage.getActiveParticipant().add(activeParticipant2);
        this.addReferencedData(list, auditMessage);
        return auditMessage;
    }

    public void logUserAuthentication(String string, String string2, boolean bl) {
        if (this.useable) {
            AuditMessage auditMessage = new AuditMessage();
            EventIdentification eventIdentification = AuditMessages.createEventIdentification((AuditMessages.EventID)AuditMessages.EventID.UserAuthentication, (String)"E", null, (String)"0", null, (EventTypeCode[])new EventTypeCode[0]);
            if (bl) {
                eventIdentification.getEventTypeCode().add(AuditMessages.EventTypeCode.Login);
            } else {
                eventIdentification.getEventTypeCode().add(AuditMessages.EventTypeCode.Logout);
            }
            auditMessage.setEventIdentification(eventIdentification);
            ActiveParticipant activeParticipant = new ActiveParticipant();
            activeParticipant.setUserID(this.processID);
            activeParticipant.getRoleIDCode().add(AuditMessages.RoleIDCode.Application);
            activeParticipant.setNetworkAccessPointID(this.computerName);
            auditMessage.getActiveParticipant().add(activeParticipant);
            this.sendAuditMessage(auditMessage);
        }
    }

    public void logCustomError(String string, String string2) {
        if (this.useable) {
            AuditMessage auditMessage = new AuditMessage();
            EventIdentification eventIdentification = new EventIdentification();
            EventID eventID = new EventID();
            eventID.setCode(CUSTOM_EVENTID_CODE);
            eventID.setCodeSystem(CUSTOM_EVENTID__CodeSystemName);
            eventID.setDisplayName(CUSTOM_EVENTID__DisplayName);
            eventIdentification.setEventID(eventID);
            eventIdentification.setEventDateTime(Calendar.getInstance());
            eventIdentification.setEventActionCode("E");
            eventIdentification.setEventOutcomeIndicator("12");
            eventIdentification.setEventOutcomeDescription(string2);
            auditMessage.setEventIdentification(eventIdentification);
            ParticipantObjectIdentification participantObjectIdentification = new ParticipantObjectIdentification();
            participantObjectIdentification.setParticipantObjectID(string != null ? string : "Custom ImpaxEE Error");
            AuditMessages.ParticipantObjectIDTypeCode participantObjectIDTypeCode = new AuditMessages.ParticipantObjectIDTypeCode("CUSTOM_IMPAXEE_ERROR_99999", "CUSTOM_IMPAXEE_ERROR_99999", "Custom ImpaxEE Error");
            participantObjectIdentification.setParticipantObjectIDTypeCode((ParticipantObjectIDTypeCode)participantObjectIDTypeCode);
            participantObjectIdentification.setParticipantObjectName(string != null ? string : "Custom ImpaxEE Error");
            auditMessage.getParticipantObjectIdentification().add(participantObjectIdentification);
            this.sendAuditMessage(auditMessage);
        }
    }

    public void logInstancesDeleted(List<? extends Attributes> list) {
        if (this.useable) {
            try {
                AuditMessage auditMessage = new AuditMessage();
                EventIdentification eventIdentification = AuditMessages.createEventIdentification((AuditMessages.EventID)AuditMessages.EventID.DICOMInstancesAccessed, (String)"D", (Calendar)Calendar.getInstance(), (String)"0", null, (EventTypeCode[])new EventTypeCode[0]);
                if (this.emergencyMode) {
                    eventIdentification.getEventTypeCode().add(AuditMessages.EventTypeCode.UseOfRestrictedFunction);
                }
                auditMessage.setEventIdentification(eventIdentification);
                this.addReferencedData(list, auditMessage);
                this.sendAuditMessage(auditMessage);
            }
            catch (Exception exception) {
                LOG.error("Instance deletion logging failed", (Throwable)exception);
            }
        }
    }

    public void logStudiesDeleted(List<? extends Attributes> list) {
        if (this.useable) {
            try {
                AuditMessage auditMessage = new AuditMessage();
                EventIdentification eventIdentification = AuditMessages.createEventIdentification((AuditMessages.EventID)AuditMessages.EventID.DICOMStudyDeleted, (String)"D", (Calendar)Calendar.getInstance(), (String)"0", null, (EventTypeCode[])new EventTypeCode[0]);
                if (this.emergencyMode) {
                    eventIdentification.getEventTypeCode().add(AuditMessages.EventTypeCode.UseOfRestrictedFunction);
                }
                auditMessage.setEventIdentification(eventIdentification);
                this.addReferencedData(list, auditMessage);
                this.sendAuditMessage(auditMessage);
            }
            catch (Exception exception) {
                LOG.error("Study deletion logging failed", (Throwable)exception);
            }
        }
    }

    public void logPermissionModification(String string, String string2, String string3) {
        if (this.useable) {
            String string4 = "U";
            AuditMessages.EventTypeCode eventTypeCode = AuditMessages.EventTypeCode.UserSecurityAttributesChanged;
            AuditMessage auditMessage = this.createBasicSecurityAuditMessage(string4, eventTypeCode);
            ParticipantObjectIdentification participantObjectIdentification = new ParticipantObjectIdentification();
            participantObjectIdentification.setParticipantObjectID("role");
            participantObjectIdentification.setParticipantObjectTypeCode("2");
            participantObjectIdentification.setParticipantObjectTypeCodeRole("6");
            participantObjectIdentification.setParticipantObjectName(string);
            auditMessage.getParticipantObjectIdentification().add(participantObjectIdentification);
            ParticipantObjectIdentification participantObjectIdentification2 = new ParticipantObjectIdentification();
            participantObjectIdentification2.setParticipantObjectID("path");
            participantObjectIdentification2.setParticipantObjectTypeCode("2");
            participantObjectIdentification2.setParticipantObjectTypeCodeRole("4");
            participantObjectIdentification2.setParticipantObjectName(string2);
            auditMessage.getParticipantObjectIdentification().add(participantObjectIdentification2);
            ParticipantObjectIdentification participantObjectIdentification3 = new ParticipantObjectIdentification();
            participantObjectIdentification3.setParticipantObjectID("permission");
            participantObjectIdentification3.setParticipantObjectTypeCode("2");
            participantObjectIdentification3.setParticipantObjectTypeCodeRole("4");
            participantObjectIdentification3.setParticipantObjectName(string3);
            auditMessage.getParticipantObjectIdentification().add(participantObjectIdentification3);
            this.logAuditMessage(auditMessage, "0");
        }
    }

    public void logRoleConfiguration(String string, String ... stringArray) {
        if (this.useable) {
            String string2 = "E";
            AuditMessages.EventTypeCode eventTypeCode = AuditMessages.EventTypeCode.SecurityRolesChanged;
            AuditMessage auditMessage = this.createBasicSecurityAuditMessage(string2, eventTypeCode);
            ParticipantObjectIdentification participantObjectIdentification = new ParticipantObjectIdentification();
            participantObjectIdentification.setParticipantObjectID("action");
            participantObjectIdentification.setParticipantObjectTypeCode("2");
            participantObjectIdentification.setParticipantObjectTypeCodeRole("4");
            participantObjectIdentification.setParticipantObjectName(string);
            auditMessage.getParticipantObjectIdentification().add(participantObjectIdentification);
            int n = 1;
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string3 = stringArray2[n3];
                ParticipantObjectIdentification participantObjectIdentification2 = new ParticipantObjectIdentification();
                participantObjectIdentification2.setParticipantObjectID("role" + (stringArray.length > 1 ? Integer.valueOf(n++) : ""));
                participantObjectIdentification2.setParticipantObjectTypeCode("2");
                participantObjectIdentification2.setParticipantObjectTypeCodeRole("6");
                participantObjectIdentification2.setParticipantObjectName(string3);
                auditMessage.getParticipantObjectIdentification().add(participantObjectIdentification2);
                ++n3;
            }
            this.logAuditMessage(auditMessage, "0");
        }
    }

    public void logSecurityConfiguration(String string, String ... stringArray) {
        if (this.useable) {
            String string2 = "E";
            AuditMessages.EventTypeCode eventTypeCode = AuditMessages.EventTypeCode.SecurityConfiguration;
            AuditMessage auditMessage = this.createBasicSecurityAuditMessage(string2, eventTypeCode);
            ParticipantObjectIdentification participantObjectIdentification = new ParticipantObjectIdentification();
            participantObjectIdentification.setParticipantObjectID("action");
            participantObjectIdentification.setParticipantObjectTypeCode("2");
            participantObjectIdentification.setParticipantObjectTypeCodeRole("4");
            participantObjectIdentification.setParticipantObjectName(string);
            auditMessage.getParticipantObjectIdentification().add(participantObjectIdentification);
            int n = 1;
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string3 = stringArray2[n3];
                ParticipantObjectIdentification participantObjectIdentification2 = new ParticipantObjectIdentification();
                participantObjectIdentification2.setParticipantObjectID("participant" + (stringArray.length > 1 ? Integer.valueOf(n++) : ""));
                participantObjectIdentification2.setParticipantObjectTypeCode("2");
                participantObjectIdentification2.setParticipantObjectTypeCodeRole("6");
                participantObjectIdentification2.setParticipantObjectName(string3);
                auditMessage.getParticipantObjectIdentification().add(participantObjectIdentification2);
                ++n3;
            }
            this.logAuditMessage(auditMessage, "0");
        }
    }

    private AuditMessage createBasicSecurityAuditMessage(String string, AuditMessages.EventTypeCode eventTypeCode) {
        String string2 = URLProviderFactory.getProvider().getLoginInformation().getUserID();
        String string3 = ComputerName.getComputerId();
        String string4 = URLProviderFactory.getProvider().getHost();
        AuditMessage auditMessage = new AuditMessage();
        EventIdentification eventIdentification = new EventIdentification();
        eventIdentification.setEventID((EventID)AuditMessages.EventID.ApplicationActivity);
        eventIdentification.getEventTypeCode().add(eventTypeCode);
        eventIdentification.setEventActionCode(string);
        eventIdentification.setEventDateTime(Calendar.getInstance());
        eventIdentification.setEventOutcomeIndicator("0");
        auditMessage.setEventIdentification(eventIdentification);
        ActiveParticipant activeParticipant = new ActiveParticipant();
        activeParticipant.setUserID(string2);
        activeParticipant.setUserIsRequestor(true);
        activeParticipant.getRoleIDCode().add(AuditMessages.RoleIDCode.Source);
        if (string3 != null) {
            activeParticipant.setNetworkAccessPointID(string3);
            activeParticipant.setNetworkAccessPointTypeCode("1");
        }
        auditMessage.getActiveParticipant().add(activeParticipant);
        ActiveParticipant activeParticipant2 = new ActiveParticipant();
        activeParticipant2.setUserID(string4);
        activeParticipant2.setAlternativeUserID(AuditLogger.processID());
        activeParticipant2.getRoleIDCode().add(AuditMessages.RoleIDCode.Destination);
        if (string4 != null) {
            activeParticipant2.setNetworkAccessPointID(string4);
            activeParticipant2.setNetworkAccessPointTypeCode("1");
        }
        auditMessage.getActiveParticipant().add(activeParticipant2);
        return auditMessage;
    }

    private String[] getCallingAETs() {
        return this.callingAETs;
    }

    private static String getComputerName() {
        return ComputerName.getComputerId();
    }

    private static String getUserID() {
        return URLProviderFactory.getProvider().getLoginInformation().getUserID();
    }

    public void setCallingAET(String string) {
        this.callingAETs = new String[]{string};
    }

    public IAuditing createAlternativeAuditing(String string, String string2, int n, Connection.Protocol protocol) {
        return new Auditing(string, string2, n, protocol);
    }
}

