/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.geometry.impl.threed;

import com.agfa.hap.geometry.impl.threed.PolyLine;
import javax.vecmath.Vector3f;

public class BSpline {
    private static final int BUFFER = 80;
    private final int numberOfControlPoints;
    private final int numberOfIntervals;
    private final int k;
    private final PolyLine controlPoints;
    private final float[] controlPointsX;
    private final float[] controlPointsY;
    private final float[] controlPointsZ;
    private float[] N;
    private float[] ta;

    public BSpline(PolyLine polyLine, int n) {
        this.numberOfControlPoints = polyLine.getCount();
        if (this.numberOfControlPoints < n) {
            n = this.numberOfControlPoints;
        }
        this.controlPoints = new PolyLine(polyLine);
        this.controlPointsX = this.controlPoints.getXPoints();
        this.controlPointsY = this.controlPoints.getYPoints();
        this.controlPointsZ = this.controlPoints.getZPoints();
        this.k = n;
        this.N = new float[n];
        this.ta = new float[n + this.numberOfControlPoints + 80];
        this.calculateNodeVector();
        this.numberOfIntervals = this.numberOfControlPoints - n + 1;
    }

    protected void calculateNodeVector() {
        int n = this.k + this.numberOfControlPoints + 80;
        int n2 = 0;
        while (n2 < n) {
            this.ta[n2] = n2 < this.k ? 0.0f : (n2 <= this.numberOfControlPoints ? (float)(n2 - this.k + 1) : (float)(this.numberOfControlPoints - this.k + 1));
            ++n2;
        }
    }

    public void getConstantSampledCurve(PolyLine polyLine, float f, float f2, float f3) {
        polyLine.clear();
        float f4 = 0.0f;
        float f5 = 0.5f;
        float f6 = f2;
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f(this.controlPointsX[this.numberOfControlPoints - 1], this.controlPointsY[this.numberOfControlPoints - 1], this.controlPointsZ[this.numberOfControlPoints - 1]);
        this.makeWeights(f4);
        this.calculatePoint(f4, vector3f2);
        while (f4 < (float)this.numberOfIntervals) {
            polyLine.add(vector3f2.x, vector3f2.y, vector3f2.z);
            vector3f.x = vector3f2.x;
            vector3f.y = vector3f2.y;
            vector3f.z = vector3f2.z;
            int n = 0;
            while (!(f4 + (f5 *= f2 / f6) >= (float)this.numberOfIntervals)) {
                if (f5 < 0.001f) {
                    f5 = 0.001f;
                    break;
                }
                this.makeWeights(f4 + f5);
                this.calculatePoint(f4 + f5, vector3f2);
                f6 = this.getDist(vector3f2, vector3f, f);
                if (n++ <= 30 && (f6 > f2 + f3 || f6 < f2 - f3)) continue;
            }
            f4 += f5;
        }
        polyLine.add(vector3f3.x, vector3f3.y, vector3f3.z);
    }

    protected float getDist(Vector3f vector3f, Vector3f vector3f2, float f) {
        return (float)Math.sqrt((vector3f.x - vector3f2.x) * (vector3f.x - vector3f2.x) + (vector3f.y - vector3f2.y) * (vector3f.y - vector3f2.y) + (vector3f.z - vector3f2.z) * (vector3f.z - vector3f2.z) * f * f);
    }

    protected void makeWeights(float f) {
        int n = (int)f + this.k - 1;
        this.N[0] = 1.0f;
        int n2 = 2;
        while (n2 <= this.k) {
            int n3 = n;
            while (n3 >= n - n2 + 1) {
                float f2 = n3 == n ? 0.0f : (this.ta[n3 + n2] - f) * this.N[n3 - n + n2 - 1] / (this.ta[n3 + n2] - this.ta[n3 + 1]);
                if (n3 != n - n2 + 1) {
                    f2 += (f - this.ta[n3]) * this.N[n3 - n + n2 - 2] / (this.ta[n3 + n2 - 1] - this.ta[n3]);
                }
                this.N[n3 - n + n2 - 1] = f2;
                --n3;
            }
            ++n2;
        }
    }

    protected void calculatePoint(float f, Vector3f vector3f) {
        vector3f.x = 0.0f;
        vector3f.y = 0.0f;
        vector3f.z = 0.0f;
        int n = 0;
        while (n < this.k) {
            vector3f.x += this.controlPointsX[(int)f + n] * this.N[n];
            vector3f.y += this.controlPointsY[(int)f + n] * this.N[n];
            vector3f.z += this.controlPointsZ[(int)f + n] * this.N[n];
            ++n;
        }
    }
}

