/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.geometry.impl.threed;

import com.agfa.hap.geometry.api.threed.ILine;
import com.agfa.hap.mathematics.MathExtended;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class Line
implements ILine {
    private static final double EPSILON = 1.0E-6;
    private Point3d point = null;
    private Vector3d direction = null;
    private boolean lineSegment = false;

    public Line(Point3d point3d, Point3d point3d2) {
        this(point3d, point3d2, false);
    }

    public Line(Point3d point3d, Point3d point3d2, boolean bl) {
        this.point = new Point3d(point3d);
        this.direction = new Vector3d(point3d2);
        this.direction.sub(point3d);
        this.lineSegment = bl;
    }

    public Line(Point3d point3d, Vector3d vector3d) {
        this.point = new Point3d(point3d);
        this.direction = new Vector3d(vector3d);
        this.lineSegment = false;
    }

    @Override
    public Point3d getPoint0() {
        return this.point;
    }

    @Override
    public Point3d getPoint(double d) {
        Vector3d vector3d = new Vector3d(this.direction);
        vector3d.scale(d);
        vector3d.add(this.point);
        return new Point3d(vector3d);
    }

    @Override
    public Vector3d getDirection() {
        return this.direction;
    }

    @Override
    public boolean islineSegment() {
        return this.lineSegment;
    }

    @Override
    public Point3d intersect(ILine iLine) {
        Point3d point3d = iLine.getPoint0();
        Vector3d vector3d = iLine.getDirection();
        boolean bl = iLine.islineSegment();
        double[] dArray = new double[]{this.direction.x, -vector3d.x, this.direction.y, -vector3d.y};
        double[] dArray2 = new double[]{point3d.x - this.point.x, point3d.y - this.point.y};
        double[] dArray3 = MathExtended.solveLinaerSystem2by2(dArray, dArray2);
        if (dArray3 != null) {
            double d = this.point.z + dArray3[0] * this.direction.z - (point3d.z + dArray3[1] * vector3d.z);
            if (this.checkIntersection(d, dArray3[0], dArray3[1], this.lineSegment, bl, 1.0E-6)) {
                return this.getPoint(dArray3[0]);
            }
            return null;
        }
        dArray = new double[]{this.direction.x, -vector3d.x, this.direction.z, -vector3d.z};
        dArray2 = new double[]{point3d.x - this.point.x, point3d.z - this.point.z};
        dArray3 = MathExtended.solveLinaerSystem2by2(dArray, dArray2);
        if (dArray3 != null) {
            double d = this.point.y + dArray3[0] * this.direction.y - (point3d.y + dArray3[1] * vector3d.y);
            if (this.checkIntersection(d, dArray3[0], dArray3[1], this.lineSegment, bl, 1.0E-6)) {
                return this.getPoint(dArray3[0]);
            }
            return null;
        }
        dArray = new double[]{this.direction.y, -vector3d.y, this.direction.z, -vector3d.z};
        dArray2 = new double[]{point3d.y - this.point.y, point3d.z - this.point.z};
        dArray3 = MathExtended.solveLinaerSystem2by2(dArray, dArray2);
        if (dArray3 != null) {
            double d = this.point.x + dArray3[0] * this.direction.x - (point3d.x + dArray3[1] * vector3d.x);
            if (this.checkIntersection(d, dArray3[0], dArray3[1], this.lineSegment, bl, 1.0E-6)) {
                return this.getPoint(dArray3[0]);
            }
            return null;
        }
        return null;
    }

    private boolean checkIntersection(double d, double d2, double d3, boolean bl, boolean bl2, double d4) {
        return Math.abs(d) <= d4 && (!bl || bl && 0.0 <= d2 && d2 <= 1.0) && (!bl2 || bl2 && 0.0 <= d3 && d3 <= 1.0);
    }

    @Override
    public Double getParametric(Point3d point3d) {
        double d = 0.0;
        double d2 = Math.abs(this.direction.x);
        double d3 = Math.abs(this.direction.y);
        double d4 = Math.abs(this.direction.z);
        d = d2 > d3 && d2 > d4 ? (point3d.x - this.point.x) / this.direction.x : (d3 > d2 && d3 > d4 ? (point3d.y - this.point.y) / this.direction.y : (point3d.z - this.point.z) / this.direction.z);
        Point3d point3d2 = this.getPoint(d);
        if (Math.abs(point3d2.x - point3d.x) > 1.0E-6 || Math.abs(point3d2.y - point3d.y) > 1.0E-6 || Math.abs(point3d2.z - point3d.z) > 1.0E-6) {
            return null;
        }
        return new Double(d);
    }
}

