/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.geometry.impl.threed;

public class PolyLine {
    public float[] xPoint;
    public float[] yPoint;
    public float[] zPoint;
    protected int bufferSize;
    protected int validItems;
    int addValue;
    protected float truLength = 0.0f;
    private boolean zScaled = true;

    public PolyLine() {
        this(5);
    }

    public PolyLine(int n) {
        this(n, 5);
    }

    public PolyLine(int n, int n2) {
        this.bufferSize = n;
        this.validItems = 0;
        this.addValue = n2;
        this.xPoint = new float[this.bufferSize];
        this.yPoint = new float[this.bufferSize];
        this.zPoint = new float[this.bufferSize];
    }

    public PolyLine(PolyLine polyLine) {
        this.bufferSize = polyLine.bufferSize;
        this.validItems = polyLine.validItems;
        this.addValue = polyLine.addValue;
        this.truLength = polyLine.truLength;
        this.xPoint = new float[this.bufferSize];
        this.yPoint = new float[this.bufferSize];
        this.zPoint = new float[this.bufferSize];
        int n = 0;
        while (n < this.validItems) {
            this.xPoint[n] = polyLine.xPoint[n];
            this.yPoint[n] = polyLine.yPoint[n];
            this.zPoint[n] = polyLine.zPoint[n];
            ++n;
        }
        this.zScaled = polyLine.zScaled;
    }

    public synchronized void copyPointsTo(PolyLine polyLine) {
        if (polyLine == null) {
            return;
        }
        polyLine.clear();
        int n = 0;
        while (n < this.validItems) {
            polyLine.add(this.xPoint[n], this.yPoint[n], this.zPoint[n]);
            ++n;
        }
    }

    public void cleanUp() {
        this.xPoint = null;
        this.yPoint = null;
        this.zPoint = null;
    }

    public synchronized void add(float f, float f2, float f3) {
        if (this.validItems == this.bufferSize) {
            this.grow();
        }
        this.xPoint[this.validItems] = f;
        this.yPoint[this.validItems] = f2;
        this.zPoint[this.validItems] = f3;
        ++this.validItems;
    }

    public void add(PolyLine polyLine) {
        int n = 0;
        while (n < polyLine.validItems) {
            this.add(polyLine.xPoint[n], polyLine.yPoint[n], polyLine.zPoint[n]);
            ++n;
        }
    }

    public void clear() {
        this.validItems = 0;
    }

    public void swappXYZ() {
        int n = this.validItems / 2;
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.validItems - n2 - 1;
            float f = this.xPoint[n2];
            this.xPoint[n2] = this.xPoint[n3];
            this.xPoint[n3] = f;
            f = this.yPoint[n2];
            this.yPoint[n2] = this.yPoint[n3];
            this.yPoint[n3] = f;
            f = this.zPoint[n2];
            this.zPoint[n2] = this.zPoint[n3];
            this.zPoint[n3] = f;
            ++n2;
        }
    }

    public float[] getXPoints() {
        return this.xPoint;
    }

    public float[] getYPoints() {
        return this.yPoint;
    }

    public float[] getZPoints() {
        return this.zPoint;
    }

    public int getCount() {
        return this.validItems;
    }

    public void setCount(int n) {
        if (n <= this.bufferSize) {
            this.validItems = n;
        }
    }

    protected synchronized void grow() {
        this.bufferSize += this.addValue;
        if (this.bufferSize <= this.validItems) {
            new Exception("Invalid state : validItems will be out of bufferSize").printStackTrace();
        }
        float[] fArray = new float[this.bufferSize];
        float[] fArray2 = new float[this.bufferSize];
        float[] fArray3 = new float[this.bufferSize];
        int n = 0;
        while (n < this.validItems) {
            fArray[n] = this.xPoint[n];
            fArray2[n] = this.yPoint[n];
            fArray3[n] = this.zPoint[n];
            ++n;
        }
        this.xPoint = fArray;
        this.yPoint = fArray2;
        this.zPoint = fArray3;
    }

    public void setZScaled(boolean bl) {
        this.zScaled = bl;
    }

    public boolean isZscaled() {
        return this.zScaled;
    }

    public void updateLineLength(double d) {
        int n = this.getCount() - 1;
        float f = 0.0f;
        if (this.zScaled) {
            d = 1.0;
        }
        int n2 = 0;
        while (n2 < n) {
            float f2 = this.xPoint[n2] - this.xPoint[n2 + 1];
            f2 *= f2;
            float f3 = this.yPoint[n2] - this.yPoint[n2 + 1];
            f3 *= f3;
            float f4 = this.zPoint[n2] - this.zPoint[n2 + 1];
            f4 = (float)((double)f4 * d);
            f4 *= f4;
            f += (float)Math.sqrt(f2 + f3 + f4);
            ++n2;
        }
        this.truLength = f;
    }

    public float getLineLength() {
        return this.truLength;
    }
}

