/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.mathematics;

import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

public class MathExtended {
    public static double[] solveQuadraticEquation(double d, double d2, double d3) {
        double d4;
        double[] dArray = null;
        if (d == 0.0 && d2 != 0.0) {
            dArray = new double[]{-d3 / d2};
        } else if (d != 0.0 && (d4 = d2 * d2 - 4.0 * d * d3) >= 0.0) {
            dArray = new double[2];
            double d5 = Math.sqrt(d4);
            double d6 = 1.0 / (2.0 * d);
            dArray[0] = (-d2 - d5) * d6;
            dArray[1] = (-d2 + d5) * d6;
        }
        return dArray;
    }

    public static double[] solveLinaerSystem2by2(double[] dArray, double[] dArray2) {
        double d = dArray[0] * dArray[3] - dArray[1] * dArray[2];
        if (d == 0.0) {
            return null;
        }
        d = 1.0 / d;
        double d2 = dArray[3] * dArray2[0] - dArray[1] * dArray2[1];
        double d3 = -dArray[2] * dArray2[0] + dArray[0] * dArray2[1];
        return new double[]{d2 * d, d3 * d};
    }

    public static double[] solveLinearSystem3by3(double[] dArray, double[] dArray2) {
        Matrix3d matrix3d = new Matrix3d(dArray);
        matrix3d.invert();
        Vector3d vector3d = new Vector3d(dArray2[0], dArray2[1], dArray2[2]);
        matrix3d.transform(vector3d);
        return new double[]{vector3d.x, vector3d.y, vector3d.z};
    }

    public static int pad(int n, int n2) {
        int n3 = n / n2;
        if (n % n2 != 0) {
            ++n3;
        }
        return n3 * n2;
    }

    public static double clamp(double d, double d2, double d3) {
        return Math.max(d, Math.min(d2, d3));
    }

    public static int clamp(int n, int n2, int n3) {
        return Math.max(n, Math.min(n2, n3));
    }

    public static int divideContained(int n, int n2) {
        int n3 = n / n2;
        if (n % n2 != 0) {
            ++n3;
        }
        return n3;
    }

    public static double[] linearFit(double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            return null;
        }
        if (dArray.length <= 0 || dArray2.length <= 0) {
            return null;
        }
        if (dArray.length != dArray2.length) {
            return null;
        }
        int n = dArray.length;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d += dArray[n2];
            d2 += dArray[n2] * dArray[n2];
            d3 += dArray2[n2];
            d4 += dArray2[n2] * dArray2[n2];
            d5 += dArray[n2] * dArray2[n2];
            ++n2;
        }
        double d6 = n;
        double d7 = (d6 * d5 - d * d3) / (d6 * d2 - d * d);
        double d8 = (d3 - d7 * d) / d6;
        double d9 = (d6 * d5 - d * d3) / Math.sqrt((d6 * d2 - d * d) * (d6 * d4 - d3 * d3));
        return new double[]{d7, d8, d9};
    }

    public static double[][] solveNonLinearSystem2by2(double[] dArray, double[] dArray2) {
        double d = dArray[2] * dArray[4] - dArray[1] * dArray[5];
        double d2 = dArray[5] * dArray2[0] - dArray[2] * dArray2[1] + dArray[0] * dArray[4] - dArray[1] * dArray[3];
        double d3 = dArray[3] * dArray2[0] - dArray[0] * dArray2[1];
        double[] dArray3 = MathExtended.solveQuadraticEquation(d, d2, d3);
        if (dArray3 == null) {
            return null;
        }
        int n = dArray3.length;
        double[][] dArray4 = new double[n][2];
        int n2 = 0;
        while (n2 < n) {
            dArray4[n2][0] = (dArray2[0] - dArray3[n2] * dArray[1]) / (dArray[0] + dArray3[n2] * dArray[2]);
            dArray4[n2][1] = dArray3[n2];
            ++n2;
        }
        return dArray4;
    }

    public static Vector3d[] getPerpendicularSet(Vector3d vector3d) {
        Vector3d vector3d2 = new Vector3d(vector3d);
        vector3d2.normalize();
        Vector3d vector3d3 = new Vector3d(1.0, 1.0, 1.0);
        if (Math.abs(vector3d2.x) > Math.abs(vector3d2.y) && Math.abs(vector3d2.x) > Math.abs(vector3d2.z)) {
            vector3d3.x = -(vector3d2.y + vector3d2.z) / vector3d2.x;
        } else if (Math.abs(vector3d2.y) > Math.abs(vector3d2.x) && Math.abs(vector3d2.y) > Math.abs(vector3d2.z)) {
            vector3d3.y = -(vector3d2.x + vector3d2.z) / vector3d2.y;
        } else {
            vector3d3.z = -(vector3d2.x + vector3d2.y) / vector3d2.z;
        }
        vector3d3.normalize();
        Vector3d vector3d4 = new Vector3d();
        vector3d4.cross(vector3d2, vector3d3);
        return new Vector3d[]{vector3d3, vector3d4, vector3d2};
    }
}

