/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.math;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class Plane {
    public Point3d p;
    public Vector3d u;
    public Vector3d v;
    public Vector3d n;
    public Matrix4d projLocalToSpace;
    private double[] normalizedCoefficients;

    public Plane(Point3d point3d, Vector3d vector3d, Vector3d vector3d2) {
        this.p = point3d;
        this.u = vector3d;
        this.v = vector3d2;
        this.n = new Vector3d();
        this.n.cross(vector3d, vector3d2);
        this.n.normalize();
        this.projLocalToSpace = new Matrix4d(vector3d.x, vector3d2.x, this.n.x, point3d.x, vector3d.y, vector3d2.y, this.n.y, point3d.y, vector3d.z, vector3d2.z, this.n.z, point3d.z, 0.0, 0.0, 0.0, 0.0);
    }

    public double[] getNormalisedCoefficients() {
        if (this.normalizedCoefficients == null) {
            this.computeCoefficients();
        }
        return this.normalizedCoefficients;
    }

    private void computeCoefficients() {
        this.normalizedCoefficients = new double[4];
        this.normalizedCoefficients[0] = this.n.x;
        this.normalizedCoefficients[1] = this.n.y;
        this.normalizedCoefficients[2] = this.n.z;
        this.normalizedCoefficients[3] = (this.n.x * this.p.x + this.n.y * this.p.y + this.n.z * this.p.z) * -1.0;
    }

    public String toString() {
        return "plane: p=" + this.p + " n=" + this.n;
    }
}

