/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls;

import com.agfa.pacs.listtext.swingx.controls.AbstractComponent;
import com.agfa.pacs.listtext.swingx.controls.IDateEditor;
import com.agfa.pacs.listtext.swingx.controls.plaf.DateChooserUI;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.swing.JComponent;

public class DateChooser
extends AbstractComponent
implements IDateEditor {
    private static final long serialVersionUID = 7187338796897692577L;
    public static final String DATE_CHANGED_EVENT = "DATE_CHANGED";
    public static final String UPDATE_UI = "UPDATE_UI";
    private Calendar calendar;
    private Date date;

    public DateChooser(Date date) {
        this.date = date != null ? date : new Date();
        this.calendar = Calendar.getInstance();
        this.initUI();
    }

    public DateChooser() {
        this(null);
    }

    public Class getComponentUIClass() {
        return DateChooserUI.class;
    }

    @Override
    public String getUIClassID() {
        return "DateChooserUI";
    }

    @Override
    public void registerUIClassPaths(Map<String, String> map) {
        map.put("Basic", "com.agfa.pacs.listtext.swingx.controls.plaf.basic.BasicDateChooserUI");
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setDate(Date date) throws IllegalArgumentException {
        if (date != null) {
            this.calendar.setTime(date);
            this.updateDate();
        }
    }

    @Override
    public JComponent getRootAWTComponent() {
        return this;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void updateDate() {
        this.date = this.calendar.getTime();
        this.firePropertyChange(DATE_CHANGED_EVENT, null, this.date);
    }
}

