/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls;

import com.agfa.pacs.listtext.swingx.controls.DateAcronyms;
import com.agfa.pacs.listtext.swingx.controls.DateValue;
import com.agfa.pacs.listtext.swingx.controls.IDateEditor;
import com.agfa.pacs.listtext.swingx.controls.IDateValue;
import com.agfa.pacs.listtext.swingx.controls.MyDate;
import com.agfa.pacs.listtext.swingx.controls.MyDateRange;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DateFormattedField
implements IDateEditor {
    private final SimpleDateFormat shortFormat = new SimpleDateFormat("ddMMyy");
    private final SimpleDateFormat shortFormat2 = new SimpleDateFormat("ddMMyyyy");
    private final SimpleDateFormat shortFormatWithDots = new SimpleDateFormat("dd.MM.yy");
    private final SimpleDateFormat shortFormat2WithDots = new SimpleDateFormat("dd.MM.yyyy");
    private DateValue value;
    private JFormattedTextField textField;
    private DateFormat dateFormat;
    private DateFormat tooltipFormat;
    private PropertyChangeSupport pcSupport;
    public static final String DATE_VALUE_CHANGED_EVENT = "DATE_VALUE_CHANGED";
    public static final String INT_VALUE_CHANGED_EVENT = "INT_VALUE_CHANGED";
    public static final String RANGE_VALUE_CHANGED_EVENT = "RANGE_VALUE_CHANGED";
    public static final String VALUE_CHANGED_EVENT = "VALUE_CHANGED";
    public static final String INPUT_CHANGED_EVENT = "INPUT_CHANGED";

    public DateFormattedField(Date date, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.value = new DateValue(date, bl3, bl4, bl5);
        this.dateFormat = this.createFormat(bl, bl2, true);
        this.tooltipFormat = this.createFormat(bl, bl2, false);
        this.pcSupport = new PropertyChangeSupport(this);
        InputListener inputListener = new InputListener();
        this.textField = new JFormattedTextField(new InternalFormatter(this.dateFormat, this.value.isEmptyInputAllowed()));
        this.textField.addKeyListener(new myAction());
        this.textField.setValue(this.value.getDate());
        this.textField.setToolTipText(this.tooltipFormat.format(this.value.getDate()));
        this.textField.addFocusListener(inputListener);
        this.textField.addPropertyChangeListener(inputListener);
        this.textField.getDocument().addDocumentListener(inputListener);
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -99);
        Date date2 = calendar.getTime();
        this.shortFormat.set2DigitYearStart(date2);
        this.shortFormatWithDots.set2DigitYearStart(date2);
    }

    public DateFormattedField(int n, boolean bl) {
        this(null, true, false, bl, true, false);
        this.value.setIntValue(n);
    }

    public DateFormattedField(Date date, boolean bl, boolean bl2, boolean bl3) {
        this(date, bl, bl2, bl3, false, false);
    }

    public DateFormattedField(Date date, boolean bl, boolean bl2) {
        this(date, bl, bl2, false);
    }

    public DateFormattedField(Date date) {
        this(date, true, false);
    }

    public DateFormattedField() {
        this(null);
    }

    @Override
    public Date getDate() {
        return this.value.getDate();
    }

    @Override
    public void setDate(Date date) throws IllegalArgumentException {
        if (!this.value.isEmptyInputAllowed() && date == null) {
            throw new IllegalArgumentException("Setting the date attribute failed: Date is null!");
        }
        this.textField.setValue(date);
        Object object = this.textField.getValue();
        if (object instanceof Date) {
            this.textField.setToolTipText(this.tooltipFormat.format((Date)object));
        } else {
            this.textField.setToolTipText(null);
        }
        this.updateDateValue();
    }

    public void setIntValue(int n) throws UnsupportedOperationException {
        if (!this.value.isIntValueAllowed()) {
            throw new UnsupportedOperationException("Integer values not allowed! You have to explicitly enable this feature");
        }
        if (n == 0 || n == 1) {
            for (MyDate myDate : DateAcronyms.getAcronyms()) {
                Integer n2 = myDate.getIntegerRepresentation();
                if (n2 == null || n2 != n) continue;
                this.textField.setValue(myDate.name);
                this.textField.setToolTipText(null);
                this.updateStringValue();
                return;
            }
        } else {
            this.textField.setValue(n);
            this.textField.setToolTipText(null);
            this.updateIntValue(n);
        }
    }

    public void setRangeValue(MyDateRange myDateRange) throws UnsupportedOperationException {
        if (!this.value.isRangeValueAllowed()) {
            throw new UnsupportedOperationException("Date range values not allowed! You have to explicitly enable this feature");
        }
        this.textField.setValue(myDateRange);
        this.textField.setToolTipText(null);
        this.updateRangeValue(myDateRange);
    }

    public Object getValue() {
        return this.value.getValue();
    }

    public IDateValue.Types getType() {
        return this.value.getType();
    }

    @Override
    public JComponent getRootAWTComponent() {
        return this.textField;
    }

    public Color getBackground() {
        return this.textField.getBackground();
    }

    public void setBackground(Color color) {
        this.textField.setBackground(color);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null && !this.isListener(propertyChangeListener)) {
            this.pcSupport.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null && this.isListener(propertyChangeListener)) {
            this.pcSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private boolean isListener(PropertyChangeListener propertyChangeListener) {
        return Arrays.asList(this.pcSupport.getPropertyChangeListeners()).contains(propertyChangeListener);
    }

    private void updateDateValue() {
        Object object = this.textField.getValue();
        Date date = this.value.getDate();
        Object object2 = this.getValue();
        this.value.setDate((Date)object);
        this.fireDateChanged(date, this.value.getDate());
        this.fireValueChanged(object2, this.getValue());
    }

    private void updateStringValue() {
        Object object = this.textField.getValue();
        Date date = this.value.getDate();
        Object object2 = this.getValue();
        this.value.setDate(object != null ? DateAcronyms.detectDateToDate((String)object) : null);
        this.fireDateChanged(date, this.value.getDate());
        this.fireValueChanged(object2, this.getValue());
    }

    private void updateIntValue(Integer n) {
        if (n == null) {
            n = (Integer)this.textField.getValue();
        }
        int n2 = this.value.getIntValue();
        Object object = this.getValue();
        this.value.setIntValue(n == null ? 0 : n);
        this.fireIntValueChanged(n2, this.value.getIntValue());
        this.fireValueChanged(object, this.getValue());
    }

    private void updateRangeValue(MyDateRange myDateRange) {
        if (myDateRange == null) {
            myDateRange = (MyDateRange)this.textField.getValue();
        }
        MyDateRange myDateRange2 = this.value.getRangeValue();
        Object object = this.getValue();
        this.value.setRangeValue(myDateRange);
        this.fireRangeValueChanged(myDateRange2, this.value.getRangeValue());
        this.fireValueChanged(object, this.getValue());
    }

    private void fireDateChanged(Date date, Date date2) {
        this.pcSupport.firePropertyChange(DATE_VALUE_CHANGED_EVENT, date, date2);
    }

    private void fireIntValueChanged(int n, int n2) {
        this.pcSupport.firePropertyChange(INT_VALUE_CHANGED_EVENT, n, n2);
    }

    private void fireRangeValueChanged(MyDateRange myDateRange, MyDateRange myDateRange2) {
        this.pcSupport.firePropertyChange(RANGE_VALUE_CHANGED_EVENT, myDateRange, myDateRange2);
    }

    private void fireValueChanged(Object object, Object object2) {
        this.pcSupport.firePropertyChange(VALUE_CHANGED_EVENT, object, object2);
    }

    private DateFormat createFormat(boolean bl, boolean bl2, boolean bl3) {
        DateFormat dateFormat = null;
        int n = 3;
        int n2 = 2;
        if (!bl3) {
            n2 = 1;
            n = 1;
        }
        dateFormat = bl && bl2 ? DateFormat.getDateTimeInstance(n2, n) : (!bl && bl2 ? DateFormat.getTimeInstance(n) : DateFormat.getDateInstance(n2));
        dateFormat.setLenient(false);
        return dateFormat;
    }

    private class InputListener
    implements PropertyChangeListener,
    FocusListener,
    DocumentListener {
        private InputListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("value".equals(propertyChangeEvent.getPropertyName())) {
                Object object = DateFormattedField.this.textField.getValue();
                if (object == null || object instanceof Date) {
                    DateFormattedField.this.updateDateValue();
                } else if (object instanceof Integer) {
                    DateFormattedField.this.updateIntValue(null);
                } else if (object instanceof MyDateRange) {
                    DateFormattedField.this.updateRangeValue(null);
                } else if (object instanceof String) {
                    MyDate myDate = DateAcronyms.detect((String)object);
                    if (myDate.getIntegerRepresentation() != null) {
                        DateFormattedField.this.updateIntValue(myDate.getIntegerRepresentation());
                    } else {
                        DateFormattedField.this.updateStringValue();
                    }
                }
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DateFormattedField.this.textField.selectAll();
                }
            });
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.inputChanged(DateFormattedField.this.textField.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.inputChanged(DateFormattedField.this.textField.getText());
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.inputChanged(DateFormattedField.this.textField.getText());
        }

        private void inputChanged(String string) {
            DateFormattedField.this.pcSupport.firePropertyChange(DateFormattedField.INPUT_CHANGED_EVENT, (Object)false, string);
        }
    }

    private class InternalFormatter
    extends JFormattedTextField.AbstractFormatter {
        private DateFormat dateFormatToUse;
        private boolean allowEmptyInput;

        public InternalFormatter(DateFormat dateFormat, boolean bl) {
            this.dateFormatToUse = dateFormat;
            this.allowEmptyInput = bl;
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            if (this.allowEmptyInput && string.length() == 0) {
                return null;
            }
            try {
                if (string.length() >= 6) {
                    throw new NumberFormatException();
                }
                Integer n = Integer.parseInt(string);
                if (!DateFormattedField.this.value.isIntValueAllowed()) {
                    throw new ParseException("Unsupported input: Integer!", 0);
                }
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                return this.nonIntegerToValue(string);
            }
        }

        private Object nonIntegerToValue(String string) throws ParseException {
            try {
                MyDateRange myDateRange = this.parseDateRange(string);
                if (!DateFormattedField.this.value.isRangeValueAllowed()) {
                    throw new ParseException("Unsupported input: date range!", 0);
                }
                return myDateRange;
            }
            catch (NumberFormatException numberFormatException) {
                if (DateAcronyms.detect(string) != null) {
                    return string;
                }
                return this.parseDate(string);
            }
        }

        private MyDateRange parseDateRange(String string) throws NumberFormatException {
            try {
                String[] stringArray = string.split("-", 2);
                return new MyDateRange(this.parseRangeDate(stringArray[0]), this.parseRangeDate(stringArray[1]));
            }
            catch (Exception exception) {
                throw new NumberFormatException();
            }
        }

        private Date parseRangeDate(String string) throws ParseException {
            if (string == null || string.length() == 0) {
                return null;
            }
            return this.parseDate(string);
        }

        private Date parseDate(String string) throws ParseException {
            if (string.length() == 6) {
                return DateFormattedField.this.shortFormat.parse(string);
            }
            if (string.length() == 8) {
                try {
                    return DateFormattedField.this.shortFormat2.parse(string);
                }
                catch (ParseException parseException) {
                    return DateFormattedField.this.shortFormatWithDots.parse(string);
                }
            }
            if (string.length() == 10) {
                return DateFormattedField.this.shortFormat2WithDots.parse(string);
            }
            return this.dateFormatToUse.parse(string);
        }

        @Override
        public String valueToString(Object object) throws ParseException {
            if (object == null) {
                if (this.allowEmptyInput) {
                    return "";
                }
                return null;
            }
            if (object instanceof Integer) {
                return ((Integer)object).toString();
            }
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof MyDateRange) {
                return ((MyDateRange)object).toString(this.dateFormatToUse);
            }
            return this.dateFormatToUse.format(object);
        }
    }

    private class myAction
    extends KeyAdapter {
        private myAction() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                try {
                    DateFormattedField.this.textField.commitEdit();
                }
                catch (ParseException parseException) {}
            }
        }
    }
}

