/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls;

import com.agfa.pacs.listtext.swingx.controls.CaseInsensitiveComparator;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuListener;

public class EditableComboBox<T>
extends JComboBox<T> {
    public EditableComboBox(StringFilterTypeEnum stringFilterTypeEnum, boolean bl) {
        this(Collections.emptyList(), stringFilterTypeEnum, bl);
    }

    public EditableComboBox(List<T> list, StringFilterTypeEnum stringFilterTypeEnum, boolean bl) {
        this.setModel(new FilterableComboBoxModel<T>(list, bl));
        this.setEditor(new MyEditor(stringFilterTypeEnum));
        this.setEditable(true);
    }

    public EditableComboBox(List<T> list, boolean bl) {
        this.setModel(new FilterableComboBoxModel<T>(list, bl));
        this.setEditable(true);
    }

    public static class ContainsFilter
    implements Filter {
        private String prefix;

        public ContainsFilter(String string) {
            this.prefix = string;
        }

        @Override
        public boolean accept(Object object) {
            return object.toString().toLowerCase(Locale.getDefault()).contains(this.prefix.toLowerCase(Locale.getDefault()));
        }
    }

    public static interface Filter {
        public boolean accept(Object var1);
    }

    public static class FilterableComboBoxModel<U>
    extends AbstractListModel<U>
    implements MutableComboBoxModel<U> {
        private List<U> items;
        private boolean sortEntries;
        private Filter filter;
        private List<U> filteredItems;
        private Object selectedItem;

        public FilterableComboBoxModel(List<U> list, boolean bl) {
            this.items = new ArrayList<U>(list);
            this.sortEntries = bl;
            this.filteredItems = new ArrayList<U>(list.size());
            this.updateFilteredItems();
        }

        @Override
        public void addElement(U u) {
            this.items.add(u);
            this.updateFilteredItems();
        }

        @Override
        public void removeElement(Object object) {
            this.items.remove(object);
            this.updateFilteredItems();
        }

        public void clear() {
            this.items.clear();
            this.updateFilteredItems();
        }

        @Override
        public void removeElementAt(int n) {
            this.items.remove(n);
            this.updateFilteredItems();
        }

        @Override
        public void insertElementAt(Object object, int n) {
            throw new UnsupportedOperationException();
        }

        public void setFilter(Filter filter) {
            this.filter = filter;
            this.updateFilteredItems();
        }

        protected void updateFilteredItems() {
            this.fireIntervalRemoved(this, 0, this.filteredItems.size());
            this.filteredItems.clear();
            if (this.sortEntries) {
                Collections.sort(this.items, new CaseInsensitiveComparator());
            }
            if (this.filter == null) {
                this.filteredItems.addAll(this.items);
            } else {
                for (U u : this.items) {
                    if (!this.filter.accept(u)) continue;
                    this.filteredItems.add(u);
                }
            }
            this.fireIntervalAdded(this, 0, this.filteredItems.size());
        }

        @Override
        public int getSize() {
            return this.filteredItems.size();
        }

        @Override
        public U getElementAt(int n) {
            return this.filteredItems.get(n);
        }

        public Object getElementWithName(String string) {
            if (string == null) {
                return null;
            }
            for (U u : this.filteredItems) {
                if (!u.toString().equals(string)) continue;
                return u;
            }
            return null;
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public void setSelectedItem(Object object) {
            if (this.selectedItem == null && object == null) {
                return;
            }
            if (this.selectedItem != null && Objects.equals(this.selectedItem, object)) {
                return;
            }
            this.selectedItem = object;
            this.fireContentsChanged(this, -1, -1);
        }

        public void setElements(List<U> list) {
            this.items.clear();
            this.items.addAll(list);
            this.updateFilteredItems();
        }
    }

    public class MyEditor
    implements ComboBoxEditor,
    DocumentListener,
    FocusListener {
        private StringFilterTypeEnum stringFilterType;
        private JTextField textField;
        private volatile boolean filtering = false;
        private volatile boolean setting = false;
        private boolean init = true;

        public MyEditor(StringFilterTypeEnum stringFilterTypeEnum) {
            this.stringFilterType = stringFilterTypeEnum;
            this.textField = new JTextField(15);
            this.textField.setName("ComboBox.textField");
            this.textField.getDocument().addDocumentListener(this);
            this.textField.addFocusListener(this);
        }

        @Override
        public Component getEditorComponent() {
            return this.textField;
        }

        @Override
        public void setItem(Object object) {
            if (this.filtering) {
                return;
            }
            this.setting = true;
            String string = object == null ? "" : object.toString();
            this.textField.setText(string);
            this.setting = false;
        }

        @Override
        public Object getItem() {
            return this.textField.getText();
        }

        @Override
        public void selectAll() {
            this.textField.selectAll();
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
            this.textField.addActionListener(actionListener);
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
            this.textField.removeActionListener(actionListener);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.handleChange();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.handleChange();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        protected void handleChange() {
            if (this.setting) {
                return;
            }
            if (this.init) {
                this.init = false;
            }
            this.filtering = true;
            Filter filter = null;
            String string = this.textField.getText();
            if (string.length() > 0) {
                switch (this.stringFilterType) {
                    case CONTAINS: {
                        filter = new ContainsFilter(string);
                        break;
                    }
                    case STARTS_WITH: {
                        filter = new StartsWithFilter(string);
                    }
                }
            }
            PopupMenuListener[] popupMenuListenerArray = this.removePopupListeners();
            ((FilterableComboBoxModel)EditableComboBox.this.getModel()).setFilter(filter);
            if (((FilterableComboBoxModel)EditableComboBox.this.getModel()).getSize() > 0) {
                EditableComboBox.this.setPopupVisible(false);
                EditableComboBox.this.setPopupVisible(true);
            } else {
                EditableComboBox.this.setPopupVisible(false);
            }
            this.filtering = false;
            this.addPopupMenuListeners(popupMenuListenerArray);
        }

        private PopupMenuListener[] removePopupListeners() {
            PopupMenuListener[] popupMenuListenerArray;
            PopupMenuListener[] popupMenuListenerArray2 = popupMenuListenerArray = EditableComboBox.this.getPopupMenuListeners();
            int n = popupMenuListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                PopupMenuListener popupMenuListener = popupMenuListenerArray2[n2];
                EditableComboBox.this.removePopupMenuListener(popupMenuListener);
                ++n2;
            }
            return popupMenuListenerArray;
        }

        private void addPopupMenuListeners(PopupMenuListener[] popupMenuListenerArray) {
            PopupMenuListener[] popupMenuListenerArray2 = popupMenuListenerArray;
            int n = popupMenuListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                PopupMenuListener popupMenuListener = popupMenuListenerArray2[n2];
                EditableComboBox.this.addPopupMenuListener(popupMenuListener);
                ++n2;
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.textField.selectAll();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }

    public static class StartsWithFilter
    implements Filter {
        private String prefix;

        public StartsWithFilter(String string) {
            this.prefix = string;
        }

        @Override
        public boolean accept(Object object) {
            return object.toString().toLowerCase(Locale.getDefault()).startsWith(this.prefix.toLowerCase(Locale.getDefault()));
        }
    }

    public static enum StringFilterTypeEnum {
        STARTS_WITH,
        CONTAINS;

    }
}

