/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls;

import com.agfa.pacs.listtext.swingx.controls.IPopupWindowClosingCallback;
import com.agfa.pacs.listtext.swingx.controls.PopupWindow;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.Timer;

public class FadingPopupWindow
extends PopupWindow {
    private double fadingSpeed;

    public FadingPopupWindow(Window window) {
        this(window, 2000, 0.1, null);
    }

    public FadingPopupWindow(Window window, double d) {
        this(window, 2000, d, null);
    }

    public FadingPopupWindow(Window window, int n, double d, IPopupWindowClosingCallback iPopupWindowClosingCallback) {
        super(window, n, iPopupWindowClosingCallback);
        this.setOpacity(0.0f);
        this.addWindowListener(new FadingHandler());
        this.fadingSpeed = d;
    }

    private class FadingHandler
    implements WindowListener,
    ActionListener {
        private Timer windowFadingTimer = null;

        private FadingHandler() {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            if (this.windowFadingTimer == null) {
                this.windowFadingTimer = new Timer(50, this);
            }
            if (!this.windowFadingTimer.isRunning()) {
                this.windowFadingTimer.start();
            }
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            if (this.windowFadingTimer != null) {
                this.windowFadingTimer.stop();
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            float f;
            if (FadingPopupWindow.this.isVisible() && (f = FadingPopupWindow.this.getOpacity()) < 1.0f) {
                FadingPopupWindow.this.setOpacity((f = (float)((double)f + FadingPopupWindow.this.fadingSpeed)) <= 1.0f ? f : 1.0f);
            }
        }
    }
}

