/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.listtext.swingx.controls.Messages;
import com.agfa.pacs.listtext.swingx.icon.IconUtil;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MessageDialog
extends JDialog
implements ChangeListener {
    public static final int INFO_TYPE = 0;
    public static final int WARN_TYPE = 1;
    public static final int ERROR_TYPE = 2;
    public static final int PLAIN_TYPE = 3;
    public static final int QUESTION_TYPE = 4;
    public static final int ICON_HEIGHT = 54;
    public static final String NO_OPTIONS = "NO_OPTIONS";
    public static final String OK_OPTION = "OK_OPTION";
    public static final String OK_CANCEL_OPTION = "OK_CANCEL_OPTION";
    public static final String YES_OPTION = "YES_OPTION";
    public static final String YES_NO_OPTION = "YES_NO_OPTION";
    public static final String CANCEL_OPTION = "CANCEL_OPTION";
    public static final String NO_OPTION = "NO_OPTION";
    private ActionListener buttonHandler = new ButtonHandler();
    private WindowListener windowHandler = new WindowHandler();
    private ClosingCallback closingCallback = new ClosingCallback();
    private IOptionStateCallback stateCallback;
    private String selectedOption = "NO_OPTIONS";
    private Map<String, AbstractButton> optionMap;
    private int minBtnWidth = Math.max(GUI.getScaledInt((int)60), GUI.getScaledDiagnosticInt((int)60));
    private boolean dontShowDlgAgainValue = false;

    public MessageDialog(Dialog dialog, String string, Object object, boolean bl) {
        this(dialog, string, object, bl, 3, OK_OPTION, false, null);
    }

    public MessageDialog(Frame frame, String string, Object object, boolean bl) {
        this(frame, string, object, bl, 3, OK_OPTION, false, null);
    }

    public MessageDialog(Dialog dialog, String string, Object object, boolean bl, int n, String string2, boolean bl2, IComponentFactory iComponentFactory) {
        super(dialog, string, bl);
        this.initDialog(object, n, string2, bl2, iComponentFactory);
    }

    public MessageDialog(Frame frame, String string, Object object, boolean bl, int n, String string2, boolean bl2, IComponentFactory iComponentFactory) {
        super(frame, string, bl);
        this.initDialog(object, n, string2, bl2, iComponentFactory);
    }

    public String getSelectedOption() {
        return this.selectedOption;
    }

    public boolean isDontShowDlgAgainSelected() {
        return this.dontShowDlgAgainValue;
    }

    public void setClosingCallback(ClosingCallback closingCallback) {
        if (closingCallback != null) {
            this.closingCallback = closingCallback;
        }
    }

    public void setOptionStateCallback(IOptionStateCallback iOptionStateCallback) {
        if (this.stateCallback != null) {
            this.stateCallback.uninstallListener();
        }
        this.stateCallback = iOptionStateCallback;
        if (this.stateCallback != null) {
            this.stateCallback.installListener(this);
            this.updateOptionState(this.stateCallback);
        }
    }

    public static MessageDialog createMessageDialog(Component component, String string, Object object, boolean bl, int n, String string2) {
        return MessageDialog.createMessageDialog(component, string, object, bl, n, string2, false, null);
    }

    public static MessageDialog createMessageDialog(Component component, String string, Object object, boolean bl, int n, String string2, boolean bl2) {
        return MessageDialog.createMessageDialog(component, string, object, bl, n, string2, bl2, null);
    }

    public static MessageDialog createMessageDialog(Component component, String string, Object object, boolean bl, int n, String string2, boolean bl2, IComponentFactory iComponentFactory) {
        Dialog dialog = SwingUtilities2.findNextDialogOwner(component);
        if (dialog != null) {
            return new MessageDialog(dialog, string, object, bl, n, string2, bl2, iComponentFactory);
        }
        Frame frame = SwingUtilities2.frameForComponent(component);
        return new MessageDialog(frame, string, object, bl, n, string2, bl2, iComponentFactory);
    }

    public void showCenteredInRectangle(Rectangle rectangle) {
        SwingUtilities2.showDialogCentered(rectangle, (JDialog)this);
    }

    public void showCenteredInComponent(Component component) {
        SwingUtilities2.showDialogCentered(component, (JDialog)this);
    }

    public void showCenteredInOwner() {
        SwingUtilities2.centerOnWindow(this.getOwner(), this);
        this.setVisible(true);
    }

    @Override
    public void setMaximumSize(Dimension dimension) {
        super.setMaximumSize(dimension);
        Dimension dimension2 = this.getSize();
        boolean bl = false;
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
            bl = true;
        }
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
            bl = true;
        }
        if (bl) {
            this.setSize(dimension2);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() instanceof IOptionStateCallback) {
            this.updateOptionState((IOptionStateCallback)changeEvent.getSource());
        }
    }

    private void initDialog(Object object, int n, String string, boolean bl, IComponentFactory iComponentFactory) {
        JComponent jComponent;
        Object object2;
        Icon icon = this.getIconForType(n);
        JLabel jLabel = icon == null ? null : (iComponentFactory != null ? iComponentFactory.createLabel(icon) : SwingUtilities2.createLabel(null, null, icon, null));
        JComponent jComponent2 = null;
        if (object instanceof JComponent) {
            jComponent2 = (JComponent)object;
        } else if (object instanceof String) {
            object2 = (String)object;
            if (((String)object2).startsWith("<html>") && ((String)object2).endsWith("</html>")) {
                jComponent2 = iComponentFactory != null ? iComponentFactory.createLabel((String)object2) : new JLabel((String)object2);
            } else {
                if (iComponentFactory != null) {
                    jComponent2 = iComponentFactory.createTextArea();
                    ((JTextArea)jComponent2).setText((String)object2);
                } else {
                    jComponent2 = SwingUtilities2.createTextArea((String)object2, null, null);
                }
                jComponent2.setEnabled(false);
            }
        } else {
            object2 = object == null ? null : object.toString();
            if (iComponentFactory != null) {
                jComponent2 = iComponentFactory.createTextArea();
                ((JTextArea)jComponent2).setText((String)object2);
            } else {
                jComponent2 = SwingUtilities2.createTextArea((String)object2, null, null);
            }
            jComponent2.setEnabled(false);
        }
        jComponent2.setName("MessageTextArea");
        jComponent2.setBorder(null);
        this.optionMap = this.createButtonsForOption(string, iComponentFactory);
        object2 = this.getDefaultButton();
        JPanel jPanel = SwingUtilities2.createPanel(false, null);
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        jPanel.setLayout(new BorderLayout(10, 15));
        jPanel.add((Component)jComponent2, "Center");
        if (!this.optionMap.isEmpty()) {
            if (object2 instanceof JButton) {
                this.getRootPane().setDefaultButton((JButton)object2);
            }
            jComponent = SwingUtilities2.createPanel(true, null);
            jComponent.setLayout(new FlowLayout(1, 20, 0));
            for (AbstractButton object3 : this.optionMap.values()) {
                jComponent.add(object3);
            }
            jPanel.add((Component)jComponent, "South");
        }
        jComponent = null;
        if (bl) {
            String string2 = this.getCaptionForDontShowDlgAgain();
            jComponent = iComponentFactory == null ? new JCheckBox(string2) : iComponentFactory.createCheckBox(string2);
            jComponent.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            jComponent.setFont(jComponent.getFont().deriveFont((float)jComponent.getFont().getSize() * 0.9f));
            ((AbstractButton)jComponent).setHorizontalAlignment(2);
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MessageDialog.this.dontShowDlgAgainValue = ((JCheckBox)actionEvent.getSource()).isSelected();
                }
            });
        }
        if (object instanceof IOptionStateCallback) {
            this.setOptionStateCallback((IOptionStateCallback)object);
            this.updateOptionState(this.stateCallback);
        }
        this.addWindowListener(this.windowHandler);
        if (jLabel != null) {
            jPanel.add((Component)jLabel, "West");
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        if (jComponent != null) {
            this.getContentPane().add((Component)jComponent, "South");
        }
        this.pack();
        if (object2 != null) {
            ((JComponent)object2).requestFocusInWindow();
        }
    }

    private AbstractButton getDefaultButton() {
        if (!this.optionMap.isEmpty()) {
            return this.optionMap.entrySet().iterator().next().getValue();
        }
        return null;
    }

    protected Icon getIconForType(int n) {
        switch (n) {
            case 0: {
                return IconUtil.getInformationIcon(54);
            }
            case 1: {
                return IconUtil.getWarningIcon(54);
            }
            case 2: {
                return IconUtil.getErrorIcon(54);
            }
            case 4: {
                return IconUtil.getQuestionIcon(54);
            }
        }
        return null;
    }

    protected Map<String, AbstractButton> createButtonsForOption(String string, IComponentFactory iComponentFactory) {
        LinkedHashMap<String, AbstractButton> linkedHashMap = new LinkedHashMap<String, AbstractButton>();
        if (OK_OPTION.equals(string)) {
            linkedHashMap.put(OK_OPTION, this.createOptionButton(OK_OPTION, iComponentFactory));
        } else if (NO_OPTION.equals(string)) {
            linkedHashMap.put(NO_OPTION, this.createOptionButton(NO_OPTION, iComponentFactory));
        } else if (YES_OPTION.equals(string)) {
            linkedHashMap.put(YES_OPTION, this.createOptionButton(YES_OPTION, iComponentFactory));
        } else if (CANCEL_OPTION.equals(string)) {
            linkedHashMap.put(CANCEL_OPTION, this.createOptionButton(CANCEL_OPTION, iComponentFactory));
        } else if (OK_CANCEL_OPTION.equals(string)) {
            linkedHashMap.put(OK_OPTION, this.createOptionButton(OK_OPTION, iComponentFactory));
            linkedHashMap.put(CANCEL_OPTION, this.createOptionButton(CANCEL_OPTION, iComponentFactory));
        } else if (YES_NO_OPTION.equals(string)) {
            linkedHashMap.put(YES_OPTION, this.createOptionButton(YES_OPTION, iComponentFactory));
            linkedHashMap.put(NO_OPTION, this.createOptionButton(NO_OPTION, iComponentFactory));
        }
        return linkedHashMap;
    }

    private JButton createOptionButton(String string, IComponentFactory iComponentFactory) {
        String string2 = this.getCaptionForOption(string);
        JButton jButton = iComponentFactory != null ? iComponentFactory.createButton(string2) : SwingUtilities2.createButton(string2);
        jButton.setActionCommand(string);
        jButton.addActionListener(this.buttonHandler);
        this.initOptionButton(jButton);
        return jButton;
    }

    protected void initOptionButton(JButton jButton) {
        Dimension dimension = jButton.getPreferredSize();
        if (dimension.width < this.minBtnWidth) {
            jButton.setPreferredSize(new Dimension(this.minBtnWidth, dimension.height));
        }
    }

    protected String getCaptionForOption(String string) {
        Locale locale = Locale.getDefault();
        if (OK_OPTION.equals(string)) {
            return UIManager.getString((Object)"OptionPane.okButtonText", locale);
        }
        if (NO_OPTION.equals(string)) {
            return UIManager.getString((Object)"OptionPane.noButtonText", locale);
        }
        if (YES_OPTION.equals(string)) {
            return UIManager.getString((Object)"OptionPane.yesButtonText", locale);
        }
        if (CANCEL_OPTION.equals(string)) {
            return UIManager.getString((Object)"OptionPane.cancelButtonText", locale);
        }
        return null;
    }

    protected String getCaptionForDontShowDlgAgain() {
        return Messages.getString("MessageDialog.DontShowDialogAgain.Text");
    }

    protected void optionSelected(String string) {
        boolean bl = true;
        if (this.closingCallback != null && (OK_OPTION.equals(this.selectedOption) || YES_OPTION.equals(this.selectedOption))) {
            bl = this.closingCallback.canCloseDialog(this);
        }
        if (bl) {
            this.setVisible(false);
            this.dispose();
        } else {
            this.selectedOption = NO_OPTIONS;
        }
    }

    private void updateOptionState(IOptionStateCallback iOptionStateCallback) {
        for (Map.Entry<String, AbstractButton> entry : this.optionMap.entrySet()) {
            entry.getValue().setEnabled(iOptionStateCallback.isOptionEnabled(entry.getKey()));
        }
    }

    public static abstract class AbstractOptionStateCallback
    implements IOptionStateCallback {
        private ChangeListener l;

        @Override
        public void installListener(ChangeListener changeListener) {
            if (this.l != null) {
                this.uninstallListener();
            }
            this.l = changeListener;
        }

        @Override
        public void uninstallListener() {
            this.l = null;
        }

        @Override
        public void notifyListener() {
            if (this.l != null) {
                this.l.stateChanged(new ChangeEvent(this));
            }
        }
    }

    protected class ButtonHandler
    implements ActionListener {
        protected ButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MessageDialog.this.selectedOption = actionEvent.getActionCommand();
            MessageDialog.this.optionSelected(MessageDialog.this.selectedOption);
        }
    }

    public static class ClosingCallback {
        public boolean canCloseDialog(MessageDialog messageDialog) {
            return true;
        }
    }

    public static interface IOptionStateCallback {
        public void installListener(ChangeListener var1);

        public void uninstallListener();

        public void notifyListener();

        public boolean isOptionEnabled(String var1);
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            boolean bl = true;
            if (MessageDialog.this.closingCallback != null) {
                bl = MessageDialog.this.closingCallback.canCloseDialog(MessageDialog.this);
            }
            if (bl) {
                if (MessageDialog.this.optionMap != null && MessageDialog.NO_OPTIONS.equals(MessageDialog.this.selectedOption)) {
                    if (MessageDialog.this.optionMap.containsKey(MessageDialog.NO_OPTION)) {
                        MessageDialog.this.selectedOption = MessageDialog.NO_OPTION;
                    } else if (MessageDialog.this.optionMap.containsKey(MessageDialog.CANCEL_OPTION)) {
                        MessageDialog.this.selectedOption = MessageDialog.CANCEL_OPTION;
                    } else if (MessageDialog.this.optionMap.size() == 1) {
                        MessageDialog.this.selectedOption = (String)MessageDialog.this.optionMap.keySet().iterator().next();
                    }
                }
                MessageDialog.this.setDefaultCloseOperation(2);
            } else {
                MessageDialog.this.setDefaultCloseOperation(0);
            }
        }
    }
}

