/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls;

import com.agfa.pacs.listtext.swingx.controls.IMultiThumbSliderModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class MultiThumbSliderModel
extends DefaultBoundedRangeModel
implements IMultiThumbSliderModel,
ChangeListener {
    private int minimumValue;
    private int maximumValue;
    private final List<SingleThumbModel> models;

    MultiThumbSliderModel(int n, int n2, int ... nArray) {
        super(MultiThumbSliderModel.sum(nArray), 0, nArray.length * n, nArray.length * n2);
        this.minimumValue = n;
        this.maximumValue = n2;
        this.models = new ArrayList<SingleThumbModel>(nArray.length);
        int n3 = 0;
        while (n3 < nArray.length) {
            this.models.add(this.createModel(nArray[n3]));
            ++n3;
        }
        Collections.sort(this.models, SingleThumbModel::compare);
    }

    private static int sum(int ... nArray) {
        int n = 0;
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            n += n4;
            ++n3;
        }
        return n;
    }

    private SingleThumbModel createModel(int n) {
        SingleThumbModel singleThumbModel = new SingleThumbModel(n, this.minimumValue, this.maximumValue);
        singleThumbModel.addChangeListener(this);
        return singleThumbModel;
    }

    BoundedRangeModel getModel(int n) {
        return this.models.get(n);
    }

    public int getCount() {
        return this.models.size();
    }

    @Override
    @Deprecated
    public void setExtent(int n) {
    }

    @Override
    public int getMaximum() {
        return this.maximumValue;
    }

    @Override
    public int getMinimum() {
        return this.minimumValue;
    }

    @Override
    public void setMaximum(int n) {
        this.maximumValue = n;
        super.setMaximum(n * this.getCount());
    }

    @Override
    public void setMinimum(int n) {
        this.minimumValue = n;
        super.setMinimum(n * this.getCount());
    }

    @Override
    @Deprecated
    public int getValue() {
        return super.getValue();
    }

    @Override
    @Deprecated
    public void setValue(int n) {
        int[] nArray = new int[this.models.size()];
        Arrays.fill(nArray, n);
        this.setValues(nArray);
    }

    @Override
    public void setValues(int ... nArray) {
        if (nArray.length != this.models.size()) {
            throw new IllegalArgumentException("Illegal number of values specified (expected: " + this.models.size() + "; was: " + nArray.length + ')');
        }
        int n = 0;
        while (n < nArray.length) {
            SingleThumbModel singleThumbModel = this.models.get(n);
            singleThumbModel.removeChangeListener(this);
            singleThumbModel.setValue(nArray[n]);
            singleThumbModel.addChangeListener(this);
            ++n;
        }
        this.updateTotalValue();
        this.fireStateChanged();
    }

    @Override
    public int getValue(int n) {
        return this.models.get(n).getValue();
    }

    @Override
    public void setValue(int n, int n2) {
        this.models.get(n).setValue(n2);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateTotalValue();
    }

    private void updateTotalValue() {
        int n = 0;
        for (SingleThumbModel singleThumbModel : this.models) {
            n += singleThumbModel.getValue();
        }
        super.setValue(n);
        Collections.sort(this.models, SingleThumbModel::compare);
    }

    private static class SingleThumbModel
    extends DefaultBoundedRangeModel {
        private static final AtomicInteger COUNTER = new AtomicInteger();
        private final int id = COUNTER.incrementAndGet();

        SingleThumbModel(int n, int n2, int n3) {
            super(n, 0, n2, n3);
        }

        static int compare(SingleThumbModel singleThumbModel, SingleThumbModel singleThumbModel2) {
            int n = Integer.compare(singleThumbModel.getValue(), singleThumbModel2.getValue());
            if (n == 0) {
                n = Integer.compare(singleThumbModel.id, singleThumbModel2.id);
            }
            return n;
        }
    }
}

