/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls;

import com.agfa.pacs.listtext.swingx.controls.IPopupWindowClosingCallback;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class PopupWindow
extends JWindow {
    private WindowHandler windowHandler;
    private IPopupWindowClosingCallback closingCallback;
    private int initialCallbackLatency;
    private boolean adjustPopupLocationToFitScreen = false;

    public PopupWindow(Window window) {
        this(window, 1000, null);
    }

    public PopupWindow(Window window, int n, IPopupWindowClosingCallback iPopupWindowClosingCallback) {
        super(window);
        this.initialCallbackLatency = n;
        this.windowHandler = new WindowHandler();
        this.closingCallback = iPopupWindowClosingCallback != null ? iPopupWindowClosingCallback : new DefaultPopupWindowClosingCallback();
        this.addWindowListener(this.windowHandler);
        this.getRootPane().setBorder(BorderFactory.createLineBorder(ColorUtils.getPrimary2()));
    }

    public boolean getAdjustPopupLocationToFitScreen() {
        return this.adjustPopupLocationToFitScreen;
    }

    public void setAdjustPopupLocationToFitScreen(boolean bl) {
        this.adjustPopupLocationToFitScreen = bl;
    }

    public void show(Component component, int n, int n2) {
        this.setLocationInt(component, n, n2);
        this.pack();
        this.setVisible(true);
    }

    public void show(Component component, int n, int n2, int n3, int n4) {
        this.setLocationInt(component, n, n2);
        this.setSize(n3, n4);
        this.setVisible(true);
    }

    protected void finalize() throws Throwable {
        this.removeWindowListener(this.windowHandler);
        super.finalize();
    }

    private void setLocationInt(Component component, int n, int n2) {
        if (component != null) {
            Point point = component.getLocationOnScreen();
            point.x += n;
            point.y += n2;
            if (this.adjustPopupLocationToFitScreen) {
                this.setLocation(this.adjustPopupLocationToFitScreen(component, point));
            } else {
                this.setLocation(point);
            }
        } else {
            this.setLocation(n, n2);
        }
    }

    private Point adjustPopupLocationToFitScreen(Component component, Point point) {
        if (GraphicsEnvironment.isHeadless()) {
            return point;
        }
        GraphicsConfiguration graphicsConfiguration = PopupWindow.getCurrentGraphicsConfiguration(component, point);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Rectangle rectangle = graphicsConfiguration != null ? graphicsConfiguration.getBounds() : new Rectangle(toolkit.getScreenSize());
        Dimension dimension = this.getPreferredSize();
        long l = (long)point.x + (long)dimension.width;
        long l2 = (long)point.y + (long)dimension.height;
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = rectangle.x + n;
        int n4 = rectangle.y + n2;
        if (l > (long)n3) {
            point.x = n3 - dimension.width;
        }
        if (l2 > (long)n4) {
            point.y = n4 - dimension.height;
        }
        if (point.x < rectangle.x) {
            point.x = rectangle.x;
        }
        if (point.y < rectangle.y) {
            point.y = rectangle.y;
        }
        return point;
    }

    private static GraphicsConfiguration getCurrentGraphicsConfiguration(Component component, Point point) {
        GraphicsConfiguration graphicsConfiguration = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n = 0;
        while (n < graphicsDeviceArray.length) {
            GraphicsConfiguration graphicsConfiguration2;
            if (graphicsDeviceArray[n].getType() == 0 && (graphicsConfiguration2 = graphicsDeviceArray[n].getDefaultConfiguration()).getBounds().contains(point)) {
                graphicsConfiguration = graphicsConfiguration2;
                break;
            }
            ++n;
        }
        if (graphicsConfiguration == null && component != null) {
            graphicsConfiguration = component.getGraphicsConfiguration();
        }
        return graphicsConfiguration;
    }

    private static class DefaultPopupWindowClosingCallback
    implements IPopupWindowClosingCallback {
        private DefaultPopupWindowClosingCallback() {
        }

        @Override
        public boolean closeWindow(PopupWindow popupWindow) {
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            Point point = pointerInfo.getLocation();
            if (point != null) {
                SwingUtilities.convertPointFromScreen(point, popupWindow);
                return !popupWindow.contains(pointerInfo.getLocation());
            }
            return true;
        }
    }

    private class WindowHandler
    implements WindowListener,
    ActionListener {
        private Timer windowDisposingTimer = null;

        private WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            PopupWindow.this.requestFocus();
            if (this.windowDisposingTimer == null) {
                this.windowDisposingTimer = new Timer(250, this);
                this.windowDisposingTimer.setInitialDelay(PopupWindow.this.initialCallbackLatency);
            }
            if (!this.windowDisposingTimer.isRunning()) {
                this.windowDisposingTimer.start();
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PopupWindow.this.isVisible() && PopupWindow.this.closingCallback.closeWindow(PopupWindow.this)) {
                this.windowDisposingTimer.stop();
                PopupWindow.this.setVisible(false);
                PopupWindow.this.dispose();
            }
        }
    }
}

