/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls.plaf.basic;

import com.agfa.pacs.listtext.swingx.controls.DateBox;
import com.agfa.pacs.listtext.swingx.controls.DateChooser;
import com.agfa.pacs.listtext.swingx.controls.DateFormattedField;
import com.agfa.pacs.listtext.swingx.controls.IDateValue;
import com.agfa.pacs.listtext.swingx.controls.MyDateRange;
import com.agfa.pacs.listtext.swingx.controls.PopupWindow;
import com.agfa.pacs.listtext.swingx.controls.plaf.DateBoxUI;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class BasicDateBoxUI
extends DateBoxUI {
    protected DateBox dateBox = null;
    protected DateFormattedField dateField;
    protected DateChooser dateChooser;
    protected JButton arrowBtn;
    private DateFieldListener dateFieldListener;
    private DateChooserListener dateChooserListener;
    private DateBoxListener dateBoxListener;
    private DateButtonListener dateButtonListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDateBoxUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.dateBox = (DateBox)jComponent;
        this.installDefaults();
        this.createComponents();
        this.createListeners();
        this.installListeners();
        this.initComponents();
        this.installLayout();
    }

    public void uninstallUI() {
        this.uninstallLayout();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.dateBox = null;
    }

    protected void installDefaults() {
    }

    protected void uninstallDefaults() {
    }

    protected void createComponents() {
        this.arrowBtn = this.createDateButton();
        this.dateField = this.createDateFormattedField(this.dateBox.isDateFormatEnabled(), this.dateBox.isTimeFormatEnabled(), this.dateBox.getValue().isEmptyInputAllowed(), this.dateBox.getValue().isIntValueAllowed(), this.dateBox.getValue().isRangeValueAllowed());
        this.dateChooser = this.createDateChooser();
    }

    protected void createListeners() {
        this.dateBoxListener = new DateBoxListener();
        this.dateFieldListener = new DateFieldListener();
        this.dateChooserListener = new DateChooserListener();
        this.dateButtonListener = new DateButtonListener();
    }

    protected void installListeners() {
        this.dateBox.addPropertyChangeListener(this.dateBoxListener);
        this.dateField.addPropertyChangeListener(this.dateFieldListener);
        this.dateChooser.addPropertyChangeListener(this.dateChooserListener);
        this.arrowBtn.addActionListener(this.dateButtonListener);
    }

    protected void uninstallListeners() {
        this.dateBox.removePropertyChangeListener(this.dateBoxListener);
        this.dateField.removePropertyChangeListener(this.dateFieldListener);
        this.dateChooser.removePropertyChangeListener(this.dateChooserListener);
        this.arrowBtn.removeActionListener(this.dateButtonListener);
    }

    protected void initComponents() {
        this.dateField.setDate(this.dateBox.getDate());
        this.dateChooser.setDate(this.dateBox.getDate());
        this.dateField.getRootAWTComponent().setEnabled(this.dateBox.isEnabled());
        this.arrowBtn.setEnabled(this.dateBox.isEnabled());
    }

    protected void installLayout() {
        this.dateBox.setLayout(new BorderLayout());
        this.dateBox.add((Component)this.dateField.getRootAWTComponent(), "Center");
        this.dateBox.add((Component)this.arrowBtn, "East");
    }

    protected void uninstallLayout() {
        this.dateBox.removeAll();
    }

    @Override
    public JComponent getEditorComponent() {
        return this.dateField.getRootAWTComponent();
    }

    protected JButton createDateButton() {
        JButton jButton = SwingUtilities2.createButton(null, null, UIManager.getIcon("calendar"), null);
        jButton.setPreferredSize(jButton.getPreferredSize());
        return jButton;
    }

    protected DateFormattedField createDateFormattedField(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        return new DateFormattedField(new Date(), bl, bl2, bl3, bl4, bl5);
    }

    protected DateChooser createDateChooser() {
        return new DateChooser();
    }

    private class DateBoxListener
    implements PropertyChangeListener {
        private DateBoxListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("VALUE_CHANGED".equals(propertyChangeEvent.getPropertyName())) {
                Object object = propertyChangeEvent.getNewValue();
                BasicDateBoxUI.this.dateField.removePropertyChangeListener(BasicDateBoxUI.this.dateFieldListener);
                if (object instanceof Integer) {
                    BasicDateBoxUI.this.dateField.setIntValue((Integer)object);
                } else if (object instanceof MyDateRange) {
                    BasicDateBoxUI.this.dateField.setRangeValue((MyDateRange)object);
                } else {
                    BasicDateBoxUI.this.dateField.setDate((Date)object);
                    BasicDateBoxUI.this.dateChooser.removePropertyChangeListener(BasicDateBoxUI.this.dateChooserListener);
                    BasicDateBoxUI.this.dateChooser.setDate((Date)object);
                    BasicDateBoxUI.this.dateChooser.addPropertyChangeListener(BasicDateBoxUI.this.dateChooserListener);
                }
                BasicDateBoxUI.this.dateField.addPropertyChangeListener(BasicDateBoxUI.this.dateFieldListener);
            } else if ("background".equals(propertyChangeEvent.getPropertyName())) {
                BasicDateBoxUI.this.dateField.setBackground(BasicDateBoxUI.this.dateBox.getBackground());
            }
        }
    }

    private class DateButtonListener
    implements ActionListener {
        private DateButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicDateBoxUI.this.dateChooser.firePropertyChange("UPDATE_UI", false, true);
            PopupWindow popupWindow = new PopupWindow(SwingUtilities.windowForComponent(BasicDateBoxUI.this.dateBox));
            popupWindow.setAdjustPopupLocationToFitScreen(true);
            popupWindow.getContentPane().add(BasicDateBoxUI.this.dateChooser);
            popupWindow.show(BasicDateBoxUI.this.dateBox, 0, BasicDateBoxUI.this.dateBox.getHeight(), (int)BasicDateBoxUI.this.dateChooser.getPreferredSize().getWidth(), (int)BasicDateBoxUI.this.dateChooser.getPreferredSize().getHeight());
        }
    }

    private class DateChooserListener
    implements PropertyChangeListener {
        private DateChooserListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("DATE_CHANGED".equals(propertyChangeEvent.getPropertyName())) {
                BasicDateBoxUI.this.dateBox.removePropertyChangeListener(BasicDateBoxUI.this.dateBoxListener);
                BasicDateBoxUI.this.dateBox.setDate((Date)propertyChangeEvent.getNewValue());
                BasicDateBoxUI.this.dateBox.addPropertyChangeListener(BasicDateBoxUI.this.dateBoxListener);
                BasicDateBoxUI.this.dateField.removePropertyChangeListener(BasicDateBoxUI.this.dateFieldListener);
                BasicDateBoxUI.this.dateField.setDate((Date)propertyChangeEvent.getNewValue());
                BasicDateBoxUI.this.dateField.addPropertyChangeListener(BasicDateBoxUI.this.dateFieldListener);
            }
        }
    }

    private class DateFieldListener
    implements PropertyChangeListener {
        private DateFieldListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("VALUE_CHANGED".equals(propertyChangeEvent.getPropertyName())) {
                BasicDateBoxUI.this.dateBox.removePropertyChangeListener(BasicDateBoxUI.this.dateBoxListener);
                switch (BasicDateBoxUI.this.dateField.getType()) {
                    case INTEGER: {
                        BasicDateBoxUI.this.dateBox.setIntValue((Integer)propertyChangeEvent.getNewValue());
                        break;
                    }
                    case RANGE: {
                        BasicDateBoxUI.this.dateBox.setRangeValue((MyDateRange)propertyChangeEvent.getNewValue());
                        break;
                    }
                    default: {
                        BasicDateBoxUI.this.dateBox.setDate((Date)propertyChangeEvent.getNewValue());
                    }
                }
                BasicDateBoxUI.this.dateBox.addPropertyChangeListener(BasicDateBoxUI.this.dateBoxListener);
                if (BasicDateBoxUI.this.dateField.getType() == IDateValue.Types.DATE) {
                    BasicDateBoxUI.this.dateChooser.removePropertyChangeListener(BasicDateBoxUI.this.dateChooserListener);
                    BasicDateBoxUI.this.dateChooser.setDate((Date)propertyChangeEvent.getNewValue());
                    BasicDateBoxUI.this.dateChooser.addPropertyChangeListener(BasicDateBoxUI.this.dateChooserListener);
                }
            } else if ("INPUT_CHANGED".equals(propertyChangeEvent.getPropertyName())) {
                Object object = propertyChangeEvent.getNewValue();
                BasicDateBoxUI.this.dateBox.inputChanged(object instanceof String ? (String)object : null);
            }
        }
    }
}

