/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls.plaf.basic;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.listtext.swingx.controls.DateChooser;
import com.agfa.pacs.listtext.swingx.controls.plaf.DateChooserUI;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;

public class BasicDateChooserUI
extends DateChooserUI
implements ItemListener,
MouseListener,
FocusListener,
KeyListener {
    private ModelListener listener = null;
    private String[] MONTHS;
    private String[] DAYS;
    private DateChooser model = null;
    private static final Color WEEK_DAYS_FOREGROUND = ColorUtils.ensureAWTColor(ColorUtils.getPrimary7());
    private static final Color DAYS_FOREGROUND = ColorUtils.getSecondary6();
    private static final Color PREVIOUS_DAYS_FOREGROUND = ColorUtils.getSecondary4();
    private static final Color SELECTED_DAY_FOREGROUND = ColorUtils.getSecondary7();
    private static final Color SELECTED_DAY_BACKGROUND = ColorUtils.getPrimary3();
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    private static final Border FOCUSED_BORDER = BorderFactory.createLineBorder(Color.BLACK, 1);
    private static final int FIRST_YEAR = 1900;
    private static final int LAST_YEAR = 2100;
    private static final String EMPTY_TEXT = " ";
    private JLabel[][] days;
    private FocusablePanel daysGrid;
    private JComboBox<String> month;
    private JComboBox<String> year;
    private int offset;
    private int lastDay;
    private JLabel day;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDateChooserUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.model = (DateChooser)jComponent;
        this.construct();
        this.listener = new ModelListener();
        this.model.addPropertyChangeListener(this.listener);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.model.removeAll();
        this.model.removePropertyChangeListener(this.listener);
        this.listener = null;
    }

    private void initializeLocals() {
        Calendar calendar = this.model.getCalendar();
        int n = calendar.getFirstDayOfWeek();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE");
        this.DAYS = new String[7];
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n2 = 0;
        int n3 = n;
        while (n3 < n + 7) {
            gregorianCalendar.set(7, n3 % 7);
            this.DAYS[n2++] = simpleDateFormat.format(gregorianCalendar.getTime());
            ++n3;
        }
        simpleDateFormat = new SimpleDateFormat("MMMMMMMMMMMMMMM");
        this.MONTHS = new String[12];
        n3 = 0;
        while (n3 < 12) {
            gregorianCalendar.setTime(new Date(0L));
            gregorianCalendar.set(2, n3);
            this.MONTHS[n3] = simpleDateFormat.format(gregorianCalendar.getTime());
            ++n3;
        }
    }

    private void construct() {
        int n;
        this.initializeLocals();
        this.month = new JComboBox<String>(this.MONTHS);
        this.month.addItemListener(this);
        this.year = new JComboBox();
        this.month.setPreferredSize(new Dimension(GUI.getScaledInt((int)110), this.year.getPreferredSize().height));
        this.year.setPreferredSize(new Dimension(GUI.getScaledInt((int)75), this.year.getPreferredSize().height));
        int n2 = 1900;
        while (n2 <= 2100) {
            this.year.addItem(Integer.toString(n2));
            ++n2;
        }
        this.year.addItemListener(this);
        this.days = new JLabel[7][7];
        n2 = 0;
        while (n2 < 7) {
            this.days[0][n2] = new JLabel(this.DAYS[n2], 4);
            this.days[0][n2].setForeground(WEEK_DAYS_FOREGROUND);
            this.days[0][n2].setFont(this.days[0][n2].getFont().deriveFont(1));
            ++n2;
        }
        n2 = 1;
        while (n2 < 7) {
            n = 0;
            while (n < 7) {
                this.days[n2][n] = new JLabel(EMPTY_TEXT, 4);
                this.days[n2][n].setForeground(DAYS_FOREGROUND);
                this.days[n2][n].setBackground(SELECTED_DAY_BACKGROUND);
                this.days[n2][n].setBorder(EMPTY_BORDER);
                this.days[n2][n].addMouseListener(this);
                ++n;
            }
            ++n2;
        }
        JPanel jPanel = new JPanel();
        jPanel.add(this.month);
        jPanel.add(this.year);
        this.daysGrid = new FocusablePanel(new GridLayout(8, 7, 5, 0));
        this.daysGrid.addFocusListener(this);
        this.daysGrid.addKeyListener(this);
        n = 0;
        while (n < 7) {
            int n3 = 0;
            while (n3 < 7) {
                this.daysGrid.add(this.days[n][n3]);
                ++n3;
            }
            ++n;
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.daysGrid);
        this.model.setLayout(new BorderLayout(1, 1));
        this.model.add((Component)jPanel, "North");
        this.model.add((Component)jPanel2, "Center");
    }

    private int getSelectedDay() {
        if (this.day == null) {
            return -1;
        }
        try {
            return Integer.parseInt(this.day.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private void setMouseOver(JLabel jLabel, boolean bl) {
        if (!bl) {
            jLabel.setOpaque(false);
            jLabel.setBackground(SELECTED_DAY_BACKGROUND);
        } else {
            jLabel.setBackground(ColorUtils.getSecondary2());
            jLabel.setOpaque(true);
        }
    }

    private void setSelected(JLabel jLabel) {
        if (this.day != null) {
            Integer n = (Integer)this.day.getClientProperty("MONTH");
            Integer n2 = (Integer)this.day.getClientProperty("YEAR");
            Integer n3 = this.month.getSelectedIndex() + 0;
            Integer n4 = this.year.getSelectedIndex() + 1900;
            if (n != null && n < n3 || n2 != null && n2 < n4) {
                this.day.setForeground(PREVIOUS_DAYS_FOREGROUND);
            } else {
                this.day.setForeground(DAYS_FOREGROUND);
            }
            this.day.setOpaque(false);
            this.day.setBorder(EMPTY_BORDER);
        }
        this.day = jLabel;
        this.model.getCalendar().set(1, (Integer)jLabel.getClientProperty("YEAR"));
        this.model.getCalendar().set(2, (Integer)jLabel.getClientProperty("MONTH"));
        this.model.getCalendar().set(5, Integer.parseInt(jLabel.getText()));
        this.day.setForeground(SELECTED_DAY_FOREGROUND);
        this.day.setBackground(SELECTED_DAY_BACKGROUND);
        this.day.setOpaque(true);
        if (this.daysGrid.hasFocus()) {
            this.day.setBorder(FOCUSED_BORDER);
        }
        this.updateModel();
    }

    private void setSelected(int n) {
        this.setSelected(this.days[(n + this.offset - 1) / 7 + 1][(n + this.offset - 1) % 7]);
    }

    private void update() {
        int n;
        int n2;
        int n3 = this.getSelectedDay();
        int n4 = 0;
        while (n4 < 7) {
            this.days[1][n4].setText(EMPTY_TEXT);
            this.days[5][n4].setText(EMPTY_TEXT);
            this.days[6][n4].setText(EMPTY_TEXT);
            ++n4;
        }
        n4 = this.month.getSelectedIndex() + 0;
        int n5 = this.year.getSelectedIndex() + 1900;
        Calendar calendar = this.model.getCalendar();
        calendar.set(5, 1);
        calendar.set(2, n4);
        calendar.set(1, n5);
        this.offset = calendar.get(7) - calendar.getFirstDayOfWeek();
        if (this.offset < 0) {
            this.offset += 7;
        }
        this.lastDay = calendar.getActualMaximum(5);
        int n6 = 0;
        while (n6 < this.lastDay) {
            n2 = (n6 + this.offset) / 7 + 1;
            n = (n6 + this.offset) % 7;
            this.days[n2][n].setForeground(DAYS_FOREGROUND);
            this.days[n2][n].setText(String.valueOf(n6 + 1));
            this.days[n2][n].putClientProperty("MONTH", n4);
            this.days[n2][n].putClientProperty("YEAR", n5);
            ++n6;
        }
        if (n3 != -1) {
            if (n3 > this.lastDay) {
                n3 = this.lastDay;
            }
            this.setSelected(n3);
        }
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(calendar.getTime());
        calendar2.add(2, -1);
        n2 = calendar2.getActualMaximum(5);
        n = 0;
        while (n < this.offset) {
            int n7 = n / 7 + 1;
            int n8 = n % 7;
            this.days[n7][n8].setForeground(PREVIOUS_DAYS_FOREGROUND);
            this.days[n7][n8].setText(String.valueOf(n2 - this.offset + n + 1));
            this.days[n7][n8].putClientProperty("MONTH", calendar2.get(2));
            this.days[n7][n8].putClientProperty("YEAR", calendar2.get(1));
            ++n;
        }
    }

    private void updateModel() {
        this.model.removePropertyChangeListener(this.listener);
        this.model.updateDate();
        this.model.addPropertyChangeListener(this.listener);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.setSelected(this.day);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.setSelected(this.day);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.update();
        this.updateModel();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = this.getSelectedDay();
        switch (keyEvent.getKeyCode()) {
            case 37: {
                if (n <= 1) break;
                this.setSelected(n - 1);
                break;
            }
            case 39: {
                if (n >= this.lastDay) break;
                this.setSelected(n + 1);
                break;
            }
            case 38: {
                if (n <= 7) break;
                this.setSelected(n - 7);
                break;
            }
            case 40: {
                if (n > this.lastDay - 7) break;
                this.setSelected(n + 7);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        JLabel jLabel = (JLabel)mouseEvent.getSource();
        if (!jLabel.getText().equals(EMPTY_TEXT)) {
            this.setSelected(jLabel);
        }
        this.daysGrid.requestFocus();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.setMouseOver((JLabel)mouseEvent.getComponent(), true);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.setMouseOver((JLabel)mouseEvent.getComponent(), false);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void updateDate() {
        Calendar calendar = this.model.getCalendar();
        int n = calendar.get(5);
        int n2 = calendar.get(2);
        int n3 = calendar.get(1);
        if (n3 >= 1900 && n3 <= 2100) {
            this.year.setSelectedIndex(n3 - 1900);
            this.month.setSelectedIndex(n2 - 0);
            this.setSelected(n);
            calendar.set(5, this.getSelectedDay());
            calendar.set(2, this.month.getSelectedIndex() + 0);
            calendar.set(1, this.year.getSelectedIndex() + 1900);
        }
    }

    private static class FocusablePanel
    extends JPanel {
        private static final long serialVersionUID = -378586916380266409L;

        public FocusablePanel(LayoutManager layoutManager) {
            super(layoutManager);
        }

        @Override
        public boolean isFocusTraversable() {
            return true;
        }
    }

    private class ModelListener
    implements PropertyChangeListener {
        private ModelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("DATE_CHANGED")) {
                Calendar calendar = BasicDateChooserUI.this.model.getCalendar();
                int n = calendar.get(5);
                int n2 = calendar.get(2);
                int n3 = calendar.get(1);
                BasicDateChooserUI.this.year.setSelectedIndex(n3 - 1900);
                BasicDateChooserUI.this.month.setSelectedIndex(n2 - 0);
                BasicDateChooserUI.this.setSelected(n);
                calendar.set(5, BasicDateChooserUI.this.getSelectedDay());
                calendar.set(2, BasicDateChooserUI.this.month.getSelectedIndex() + 0);
                calendar.set(1, BasicDateChooserUI.this.year.getSelectedIndex() + 1900);
            } else if (propertyChangeEvent.getPropertyName().equals("UPDATE_UI")) {
                BasicDateChooserUI.this.updateDate();
            }
        }
    }
}

