/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls.plaf.basic;

import com.agfa.pacs.listtext.swingx.controls.JMultiThumbSlider;
import com.agfa.pacs.listtext.swingx.controls.Thumb;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class BasicMultiThumbSliderUI
extends BasicSliderUI {
    private Rectangle unionRect = new Rectangle();
    protected transient boolean isDragging;
    private JMultiThumbSlider multiThumbSlider;

    public BasicMultiThumbSliderUI(JMultiThumbSlider jMultiThumbSlider) {
        super(jMultiThumbSlider);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMultiThumbSliderUI((JMultiThumbSlider)jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.isDragging = false;
        this.multiThumbSlider = (JMultiThumbSlider)jComponent;
        super.installUI(jComponent);
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new MultiThumbSliderTrackListener();
    }

    @Override
    protected Dimension getThumbSize() {
        return this.multiThumbSlider.getThumbSize();
    }

    @Override
    protected void calculateThumbSize() {
        for (Thumb thumb : this.multiThumbSlider.getThumbList()) {
            Rectangle rectangle = thumb.getRectangle();
            Icon icon = thumb.getThumbRenderer();
            if (icon == null) continue;
            rectangle.setSize(icon.getIconWidth(), icon.getIconHeight());
        }
        super.calculateThumbSize();
    }

    @Override
    protected void calculateThumbLocation() {
        for (Thumb thumb : this.multiThumbSlider.getThumbList()) {
            int n;
            int n2;
            if (this.multiThumbSlider.getSnapToTicks()) {
                int n3 = this.multiThumbSlider.getMinorTickSpacing();
                if (n3 == 0) {
                    n3 = this.multiThumbSlider.getMajorTickSpacing();
                }
                if (n3 != 0) {
                    n = n2 = thumb.getModel().getValue();
                    int n4 = this.multiThumbSlider.getMinimum();
                    if ((n2 - n4) % n3 != 0) {
                        float f = (float)(n2 - n4) / (float)n3;
                        int n5 = Math.round(f);
                        n = n4 + n5 * n3;
                        thumb.getModel().setValue(n);
                    }
                }
            }
            Rectangle rectangle = thumb.getRectangle();
            if (this.multiThumbSlider.getOrientation() == 0) {
                n2 = thumb.getModel().getValue();
                n = this.xPositionForValue(n2);
                rectangle.x = n - rectangle.width / 2;
                rectangle.y = this.trackRect.y;
                continue;
            }
            n2 = this.yPositionForValue(thumb.getModel().getValue());
            rectangle.x = this.trackRect.x;
            rectangle.y = n2 - rectangle.height / 2;
        }
    }

    public void setThumbLocationAt(int n, int n2, Thumb thumb) {
        Rectangle rectangle = thumb.getRectangle();
        this.unionRect.setBounds(rectangle);
        rectangle.setLocation(n, n2);
        SwingUtilities.computeUnion(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.unionRect);
        this.multiThumbSlider.repaint(this.unionRect.x, this.unionRect.y, this.unionRect.width, this.unionRect.height);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        Rectangle rectangle = graphics.getClipBounds();
        if (!rectangle.intersects(this.trackRect) && this.multiThumbSlider.getPaintTrack()) {
            this.calculateGeometry();
        }
        if (!jComponent.isOpaque()) {
            graphics.setColor(new Color(0, 0, 0, 0));
        }
        if (this.multiThumbSlider.getPaintTrack() && rectangle.intersects(this.trackRect)) {
            this.paintTrack(graphics);
        }
        if (this.multiThumbSlider.getPaintTicks() && rectangle.intersects(this.tickRect)) {
            this.paintTicks(graphics);
        }
        if (this.multiThumbSlider.getPaintLabels() && rectangle.intersects(this.labelRect)) {
            this.paintLabels(graphics);
        }
        if (this.multiThumbSlider.hasFocus() && rectangle.intersects(this.focusRect)) {
            this.paintFocus(graphics);
        }
        for (Thumb thumb : this.multiThumbSlider.getThumbList()) {
            Rectangle rectangle2 = thumb.getRectangle();
            if (!rectangle.intersects(rectangle2)) continue;
            this.thumbRect = rectangle2;
            Icon icon = thumb.getThumbRenderer();
            icon.paintIcon(this.multiThumbSlider, graphics, this.thumbRect.x, this.thumbRect.y);
        }
    }

    @Override
    public void paintTrack(Graphics graphics) {
        Rectangle rectangle = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            int n = rectangle.height / 2 - 2;
            int n2 = rectangle.width;
            graphics.translate(rectangle.x, rectangle.y + n);
            graphics.setColor(ColorUtils.getSecondary2());
            graphics.fillRect(1, 1, n2 - 2, 3);
            graphics.translate(-rectangle.x, -(rectangle.y + n));
        } else {
            int n = rectangle.width / 2 - 2;
            int n3 = rectangle.height;
            graphics.translate(rectangle.x + n, rectangle.y);
            graphics.setColor(ColorUtils.getSecondary2());
            graphics.fillRect(1, 1, 3, n3 - 2);
            graphics.translate(-(rectangle.x + n), -rectangle.y);
        }
    }

    protected class MultiThumbSliderTrackListener
    extends BasicSliderUI.TrackListener {
        protected Thumb adjustingThumb;

        protected MultiThumbSliderTrackListener() {
            super(BasicMultiThumbSliderUI.this);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!BasicMultiThumbSliderUI.this.multiThumbSlider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            BasicMultiThumbSliderUI.this.multiThumbSlider.requestFocus();
            for (Thumb thumb : BasicMultiThumbSliderUI.this.multiThumbSlider.getThumbList()) {
                Rectangle rectangle = thumb.getRectangle();
                if (!rectangle.contains(this.currentMouseX, this.currentMouseY)) continue;
                switch (BasicMultiThumbSliderUI.this.multiThumbSlider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - rectangle.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - rectangle.x;
                    }
                }
                BasicMultiThumbSliderUI.this.isDragging = true;
                BasicMultiThumbSliderUI.this.multiThumbSlider.setValueIsAdjusting(true);
                this.adjustingThumb = thumb;
                return;
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!(BasicMultiThumbSliderUI.this.multiThumbSlider.isEnabled() && BasicMultiThumbSliderUI.this.isDragging && BasicMultiThumbSliderUI.this.multiThumbSlider.getValueIsAdjusting() && this.adjustingThumb != null)) {
                return;
            }
            int n = 0;
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            Rectangle rectangle = this.adjustingThumb.getRectangle();
            switch (BasicMultiThumbSliderUI.this.multiThumbSlider.getOrientation()) {
                case 1: {
                    int n2 = rectangle.height / 2;
                    int n3 = mouseEvent.getY() - this.offset;
                    int n4 = ((BasicMultiThumbSliderUI)BasicMultiThumbSliderUI.this).trackRect.y;
                    int n5 = ((BasicMultiThumbSliderUI)BasicMultiThumbSliderUI.this).trackRect.y + (((BasicMultiThumbSliderUI)BasicMultiThumbSliderUI.this).trackRect.height - 1);
                    n3 = Math.max(n3, n4 - n2);
                    n3 = Math.min(n3, n5 - n2);
                    BasicMultiThumbSliderUI.this.setThumbLocationAt(rectangle.x, n3, this.adjustingThumb);
                    n = n3 + n2;
                    this.adjustingThumb.getModel().setValue(BasicMultiThumbSliderUI.this.valueForYPosition(n));
                    break;
                }
                case 0: {
                    int n6 = rectangle.width / 2;
                    int n7 = mouseEvent.getX() - this.offset;
                    int n8 = ((BasicMultiThumbSliderUI)BasicMultiThumbSliderUI.this).trackRect.x;
                    int n9 = ((BasicMultiThumbSliderUI)BasicMultiThumbSliderUI.this).trackRect.x + (((BasicMultiThumbSliderUI)BasicMultiThumbSliderUI.this).trackRect.width - 1);
                    n7 = Math.max(n7, n8 - n6);
                    n7 = Math.min(n7, n9 - n6);
                    BasicMultiThumbSliderUI.this.setThumbLocationAt(n7, rectangle.y, this.adjustingThumb);
                    n = n7 + n6;
                    this.adjustingThumb.getModel().setValue(BasicMultiThumbSliderUI.this.valueForXPosition(n));
                }
            }
            BasicMultiThumbSliderUI.this.multiThumbSlider.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!BasicMultiThumbSliderUI.this.multiThumbSlider.isEnabled()) {
                return;
            }
            this.offset = 0;
            BasicMultiThumbSliderUI.this.isDragging = false;
            BasicMultiThumbSliderUI.this.multiThumbSlider.setValueIsAdjusting(false);
            BasicMultiThumbSliderUI.this.multiThumbSlider.repaint();
        }

        @Override
        public boolean shouldScroll(int n) {
            return false;
        }
    }
}

