/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls.plaf.basic;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.listtext.swingx.controls.plaf.TaskPaneTabUI;
import com.agfa.pacs.listtext.swingx.controls.taskpane.TaskPaneTab;
import com.agfa.pacs.listtext.swingx.icon.LTAIconUtils;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComponentUI;
import org.apache.commons.lang3.StringUtils;

public class BasicTaskPaneTabUI
extends TaskPaneTabUI {
    private static final String CLOSE_BUTTON_PRESSED_EVENT = "CLOSE_BUTTON_PRESSED";
    private TaskPaneTab tab = null;
    protected TaskPaneTabHeader header = null;
    private JComponent clientComponent = null;
    private TabListener tabListener = new TabListener();
    private HeaderListener headerListener = new HeaderListener();
    protected Icon expandIconArrow = null;
    protected Icon collapseIconArrow = null;
    protected Icon expandIconSquare = null;
    protected Icon collapseIconSquare = null;
    protected Icon closeIcon = null;
    private Color titleForeground = null;
    protected Color titleBackground = null;
    protected Color primaryColor = null;
    protected Color titleForegroundExpanded = null;
    protected Color titleBackgroundExpanded = null;
    protected Color primaryExpandedColor = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTaskPaneTabUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.tab = (TaskPaneTab)jComponent;
        this.installDefaults();
        this.createComponents();
        this.installListeners();
        this.initComponents();
        this.installLayout();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallLayout();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.tab = null;
    }

    protected void installDefaults() {
        this.closeIcon = LTAIconUtils.getDeleteWhiteIcon();
        this.expandIconArrow = UIManager.getIcon("triangle.down.filled");
        this.collapseIconArrow = UIManager.getIcon("triangle.up.filled");
        this.expandIconSquare = UIManager.getIcon("window.expanded");
        this.collapseIconSquare = UIManager.getIcon("window.collapsed");
        this.titleForeground = ColorUtils.getWhite();
        this.primaryColor = ColorUtils.getPrimary2();
        this.titleForegroundExpanded = ColorUtils.getWhite();
        this.titleBackgroundExpanded = this.primaryExpandedColor = this.primaryColor;
    }

    public void uninstallDefaults() {
        this.titleBackground = null;
        this.titleForeground = null;
        this.titleBackgroundExpanded = null;
        this.titleForegroundExpanded = null;
        this.primaryColor = null;
        this.primaryExpandedColor = null;
        this.expandIconArrow = null;
        this.collapseIconArrow = null;
        this.expandIconSquare = null;
        this.collapseIconSquare = null;
    }

    public void createComponents() {
        this.header = new TaskPaneTabHeader(this.tab.isExpanded() && this.titleBackgroundExpanded != null ? this.titleBackgroundExpanded : this.titleBackground, this.tab.isExpanded() && this.titleForegroundExpanded != null ? this.titleBackgroundExpanded : this.titleForeground);
    }

    public void installListeners() {
        this.tab.addPropertyChangeListener(this.tabListener);
        this.header.addMouseListener(this.headerListener);
        this.header.addPropertyChangeListener(this.headerListener);
    }

    public void uninstallListeners() {
        this.tab.removePropertyChangeListener(this.tabListener);
        this.header.removeMouseListener(this.headerListener);
        this.header.removePropertyChangeListener(this.headerListener);
    }

    protected void initComponents() {
        this.clientComponent = this.tab.getClientComponent();
        this.header.setTitle(this.tab.getTitle());
        this.header.setTitleIcon(this.getExpandCollapseIcon());
        this.header.setActionComponents(this.tab.getActionComponents());
        this.header.setCloseButtonVisible(this.tab.isCloseable());
        int n = this.tab.getHeaderSize();
        this.header.setMinimumSize(new Dimension(this.header.getMinimumSize().width, n));
        this.header.setPreferredSize(new Dimension(this.header.getPreferredSize().width, n));
        this.header.setMaximumSize(new Dimension(this.header.getMaximumSize().width, n));
    }

    protected void installLayout() {
        this.tab.setLayout(new BorderLayout());
        this.tab.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        this.tab.add((Component)this.header, "North");
        if (this.clientComponent != null) {
            this.tab.add((Component)this.clientComponent, "Center");
        }
    }

    public void uninstallLayout() {
        this.tab.removeAll();
    }

    private Icon getExpandCollapseIcon() {
        Icon icon = this.tab.getTitleIcon();
        if (icon != null) {
            return icon;
        }
        switch (this.tab.getExpandCollapseIconType()) {
            case 0: {
                return this.tab.isExpanded() ? this.expandIconArrow : this.collapseIconArrow;
            }
            case 1: {
                return this.tab.isExpanded() ? this.expandIconSquare : this.collapseIconSquare;
            }
        }
        return null;
    }

    private class HeaderListener
    extends MouseAdapter
    implements PropertyChangeListener {
        private HeaderListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && !BasicTaskPaneTabUI.this.tab.isTitleEditable()) {
                BasicTaskPaneTabUI.this.tab.setExpanded(!BasicTaskPaneTabUI.this.tab.isExpanded());
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (BasicTaskPaneTabUI.CLOSE_BUTTON_PRESSED_EVENT.equals(propertyChangeEvent.getPropertyName())) {
                BasicTaskPaneTabUI.this.tab.setClosed(true);
            }
        }
    }

    private class TabListener
    implements PropertyChangeListener {
        private static final String NAME = "name";

        private TabListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (NAME.equals(string)) {
                BasicTaskPaneTabUI.this.header.setName((String)propertyChangeEvent.getNewValue());
            } else if ("TITLE_CHANGED".equals(string)) {
                BasicTaskPaneTabUI.this.header.setTitle((String)propertyChangeEvent.getNewValue());
            } else if ("TITLE_ICON_CHANGED".equals(string)) {
                BasicTaskPaneTabUI.this.header.setTitleIcon((Icon)propertyChangeEvent.getNewValue());
            } else if ("CLIENT_COMPONENT_CHANGED".equals(string)) {
                this.setClientComponent((JComponent)propertyChangeEvent.getNewValue());
            } else if ("ACTION_COMPONENTS_CHANGED".equals(string)) {
                BasicTaskPaneTabUI.this.header.setActionComponents((List)propertyChangeEvent.getNewValue());
            } else if ("TAB_EXPANSION_FLAG_CHANGED".equals(string)) {
                this.setTabExpanded((Boolean)propertyChangeEvent.getNewValue());
            } else if ("TITLE_EDITABLE_CHANGED".equals(string) || "TITLE_EDITING_CHANGED".equals(string)) {
                BasicTaskPaneTabUI.this.header.setTitleEditing(BasicTaskPaneTabUI.this.tab.isTitleEditable() && BasicTaskPaneTabUI.this.tab.isTitleEditing());
            } else if ("HEADER_SIZE_CHANGED".equals(string)) {
                this.setHeaderSize((Integer)propertyChangeEvent.getNewValue());
            } else if ("HEADER_TITLE_FOREGROUND_CHANGED".equals(string)) {
                this.setTitleForeground((Color)propertyChangeEvent.getNewValue());
            } else if ("HEADER_TITLE_BACKGROUND_CHANGED".equals(string)) {
                this.setTitleBackground((Color)propertyChangeEvent.getNewValue());
            } else if ("HEADER_EXPANDED_TITLE_FOREGROUND_CHANGED".equals(string)) {
                this.setTitleForegroundExpanded((Color)propertyChangeEvent.getNewValue());
            } else if ("HEADER_EXPANDED_TITLE_BACKGROUND_CHANGED".equals(string)) {
                this.setTitleBackgroundExpanded((Color)propertyChangeEvent.getNewValue());
            } else if ("EXPAND_COLLAPSE_ICON_TYPE_CHANGED".equals(string)) {
                BasicTaskPaneTabUI.this.header.setTitleIcon(BasicTaskPaneTabUI.this.getExpandCollapseIcon());
            } else if ("HIGHLIGHT_TAB".equals(string)) {
                BasicTaskPaneTabUI.this.header.highlight((Boolean)propertyChangeEvent.getNewValue());
            }
        }

        private void setClientComponent(JComponent jComponent) {
            if (BasicTaskPaneTabUI.this.clientComponent != null) {
                BasicTaskPaneTabUI.this.tab.remove(BasicTaskPaneTabUI.this.clientComponent);
            }
            BasicTaskPaneTabUI.this.clientComponent = jComponent;
            if (BasicTaskPaneTabUI.this.clientComponent != null) {
                BasicTaskPaneTabUI.this.tab.add((Component)BasicTaskPaneTabUI.this.clientComponent, "Center");
            }
            BasicTaskPaneTabUI.this.tab.revalidate();
        }

        private void setHeaderSize(int n) {
            if (BasicTaskPaneTabUI.this.header.getHeight() != n) {
                BasicTaskPaneTabUI.this.header.setMinimumSize(new Dimension(BasicTaskPaneTabUI.this.header.getMinimumSize().width, n));
                BasicTaskPaneTabUI.this.header.setPreferredSize(new Dimension(BasicTaskPaneTabUI.this.header.getPreferredSize().width, n));
                BasicTaskPaneTabUI.this.header.setMaximumSize(new Dimension(BasicTaskPaneTabUI.this.header.getMaximumSize().width, n));
                BasicTaskPaneTabUI.this.tab.revalidate();
            }
        }

        private void setTabExpanded(boolean bl) {
            BasicTaskPaneTabUI.this.header.setExpanded(bl);
        }

        private void setTitleForeground(Color color) {
            if (color != null && !color.equals(BasicTaskPaneTabUI.this.titleForeground)) {
                BasicTaskPaneTabUI.this.titleForeground = color;
                BasicTaskPaneTabUI.this.header.setTitleForeground(color);
            }
        }

        private void setTitleBackground(Color color) {
            if (color != null && !color.equals(BasicTaskPaneTabUI.this.titleBackground)) {
                BasicTaskPaneTabUI.this.titleBackground = color;
                BasicTaskPaneTabUI.this.header.setTitleBackground(color);
            }
        }

        private void setTitleForegroundExpanded(Color color) {
            if (color != null && !color.equals(BasicTaskPaneTabUI.this.titleForegroundExpanded)) {
                BasicTaskPaneTabUI.this.titleForegroundExpanded = color;
                if (BasicTaskPaneTabUI.this.tab.isExpanded()) {
                    BasicTaskPaneTabUI.this.header.setTitleForeground(color);
                }
            }
        }

        private void setTitleBackgroundExpanded(Color color) {
            if (color != null && !color.equals(BasicTaskPaneTabUI.this.titleBackgroundExpanded)) {
                BasicTaskPaneTabUI.this.titleBackgroundExpanded = color;
                if (BasicTaskPaneTabUI.this.tab.isExpanded()) {
                    BasicTaskPaneTabUI.this.header.setTitleBackground(color);
                }
            }
        }
    }

    protected class TaskPaneTabHeader
    extends JPanel {
        private JPanel headerPanel = SwingUtilities2.createPanel(false, null);
        private JLabel titleLabel = new HeaderLabel();
        private JTextField titleTextField = null;
        private Vector<JComponent> actionComponents = null;
        private JButton closeBtn = null;
        private HeaderMouseListener headerMouseListener = null;

        public TaskPaneTabHeader(Color color, Color color2) {
            this.titleLabel.addMouseListener(new EditTitleListener());
            this.titleTextField = new JTextField();
            this.titleLabel.setVisible(!BasicTaskPaneTabUI.this.tab.isTitleEditing());
            this.titleTextField.setVisible(BasicTaskPaneTabUI.this.tab.isTitleEditing());
            this.headerMouseListener = new HeaderMouseListener();
            this.addMouseListener(this.headerMouseListener);
            this.addMouseMotionListener(this.headerMouseListener);
            this.actionComponents = new Vector();
            this.closeBtn = SwingUtilities2.createButton(BasicTaskPaneTabUI.this.closeIcon);
            this.closeBtn.setVisible(false);
            this.closeBtn.setPreferredSize(new Dimension(20, 20));
            this.closeBtn.setAlignmentY(0.5f);
            this.closeBtn.setName(BasicTaskPaneTabUI.this.tab.getName() != null ? String.valueOf(BasicTaskPaneTabUI.this.tab.getName()) + ".Button" : "Button");
            this.actionComponents.addElement(this.closeBtn);
            this.closeBtn.addActionListener(actionEvent -> this.firePropertyChange(BasicTaskPaneTabUI.CLOSE_BUTTON_PRESSED_EVENT, false, true));
            this.initLayout();
            this.setName(BasicTaskPaneTabUI.this.tab.getName());
            this.setOpaque(true);
        }

        public Font getTitleFont() {
            return this.titleLabel.getFont();
        }

        @Override
        public void setName(String string) {
            super.setName(string);
            this.titleLabel.setName(StringUtils.isNotBlank((CharSequence)string) ? String.valueOf(string) + ".HeaderLabel" : "HeaderLabel");
        }

        public void setTitle(String string) {
            String string2 = string != null ? string : "";
            this.titleLabel.setText(String.valueOf(string2) + "   ");
            if (!string2.equals(this.titleTextField.getText())) {
                this.titleTextField.setText(string2);
            }
            this.titleLabel.revalidate();
            this.titleLabel.repaint();
        }

        public void setTitleIcon(Icon icon) {
            if (this.titleLabel.getIcon() != icon) {
                this.titleLabel.setIcon(icon);
                this.titleLabel.repaint();
            }
        }

        public void setCloseButtonVisible(boolean bl) {
            this.closeBtn.setVisible(bl);
            this.revalidate();
        }

        public void setTitleFont(Font font) {
            if (font != null && this.titleLabel.getFont() != font) {
                this.titleLabel.setFont(font);
                this.titleTextField.setFont(font);
                this.repaint();
            }
        }

        public void setTitleForeground(Color color) {
            if (color != null && this.titleLabel.getForeground() != color) {
                this.titleLabel.setForeground(color);
                this.titleTextField.setForeground(color);
                this.setTitleTextField(color);
            }
        }

        public void setTitleBackground(Color color) {
            if (color != null && this.titleLabel.getBackground() != color) {
                this.titleLabel.setBackground(color);
                this.titleTextField.setBackground(color);
                this.setTitleTextField(color);
            }
        }

        private void setTitleTextField(Color color) {
            this.titleTextField.setSelectedTextColor(this.titleTextField.getBackground());
            this.titleTextField.setSelectionColor(this.titleTextField.getForeground());
            this.repaint();
        }

        public void setTitleEditing(boolean bl) {
            if (bl) {
                this.titleTextField.setText(this.titleLabel.getText().trim());
                this.titleTextField.setMinimumSize(this.titleTextField.getPreferredSize());
                this.titleLabel.setVisible(false);
                this.titleTextField.setVisible(true);
            } else {
                this.titleTextField.setVisible(false);
                this.titleLabel.setVisible(true);
            }
            this.revalidate();
            this.repaint();
        }

        public void setExpanded(boolean bl) {
            this.setTitleIcon(BasicTaskPaneTabUI.this.getExpandCollapseIcon());
            this.highlight(bl);
        }

        public void setActionComponents(List<JComponent> list) {
            this.actionComponents.removeAllElements();
            if (list != null) {
                this.actionComponents.addAll(list);
            }
            this.closeBtn.setName(BasicTaskPaneTabUI.this.tab.getName() != null ? String.valueOf(BasicTaskPaneTabUI.this.tab.getName()) + ".Button" : "Button");
            this.actionComponents.addElement(this.closeBtn);
            this.initLayout();
            this.revalidate();
            this.repaint();
        }

        private void highlight(boolean bl) {
            this.revalidate();
            this.repaint();
        }

        protected void initLayout() {
            this.removeAll();
            this.headerPanel.removeAll();
            this.headerPanel.setLayout(new BoxLayout(this.headerPanel, 0));
            for (JComponent jComponent : this.actionComponents) {
                jComponent.setAlignmentY(0.5f);
                Dimension dimension = jComponent.getMaximumSize();
                jComponent.setMaximumSize(new Dimension(dimension.width, Integer.MAX_VALUE));
                this.headerPanel.add(jComponent);
            }
            int n = BasicTaskPaneTabUI.this.tab.getHeaderBorderSize();
            GridBagLayout gridBagLayout = new GridBagLayout();
            gridBagLayout.setConstraints(this.titleLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(n, 0, n, 0), 0, 0));
            gridBagLayout.setConstraints(this.titleTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            gridBagLayout.setConstraints(this.headerPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(n, 2 * n, n, 2 * n), 0, 0));
            this.setLayout(gridBagLayout);
            this.add(this.titleLabel);
            this.add(this.titleTextField);
            this.add(this.headerPanel);
        }

        private class EditTitleListener
        extends MouseAdapter
        implements AWTEventListener,
        DocumentListener,
        ActionListener {
            private EditTitleListener() {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && BasicTaskPaneTabUI.this.tab.isTitleEditable() && !BasicTaskPaneTabUI.this.tab.isTitleEditing()) {
                    BasicTaskPaneTabUI.this.tab.setTitleEditing(true);
                    TaskPaneTabHeader.this.titleTextField.requestFocusInWindow();
                    TaskPaneTabHeader.this.titleTextField.select(0, TaskPaneTabHeader.this.titleTextField.getDocument().getLength());
                    TaskPaneTabHeader.this.titleTextField.addActionListener(this);
                    TaskPaneTabHeader.this.titleTextField.getDocument().addDocumentListener(this);
                    Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
                }
            }

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                Window window;
                Window window2;
                MouseEvent mouseEvent;
                if (aWTEvent instanceof MouseEvent && (mouseEvent = (MouseEvent)aWTEvent).getID() == 501 && mouseEvent.getComponent() != TaskPaneTabHeader.this.titleTextField && (window2 = mouseEvent.getComponent() instanceof Window ? (Window)mouseEvent.getComponent() : SwingUtilities.windowForComponent(mouseEvent.getComponent())) == (window = SwingUtilities.windowForComponent(TaskPaneTabHeader.this.titleTextField))) {
                    BasicTaskPaneTabUI.this.tab.setTitleEditing(false);
                    TaskPaneTabHeader.this.titleTextField.getDocument().removeDocumentListener(this);
                    TaskPaneTabHeader.this.titleTextField.removeActionListener(this);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Toolkit.getDefaultToolkit().removeAWTEventListener(EditTitleListener.this);
                        }
                    });
                }
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.updateTitle(TaskPaneTabHeader.this.titleTextField.getText());
                TaskPaneTabHeader.this.titleTextField.setMinimumSize(TaskPaneTabHeader.this.titleTextField.getPreferredSize());
                TaskPaneTabHeader.this.revalidate();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.updateTitle(TaskPaneTabHeader.this.titleTextField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.updateTitle(TaskPaneTabHeader.this.titleTextField.getText());
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BasicTaskPaneTabUI.this.tab.setTitleEditing(false);
            }

            private void updateTitle(String string) {
                String string2 = BasicTaskPaneTabUI.this.tab.getTitle();
                if (string2 == null || !string2.equals(string)) {
                    BasicTaskPaneTabUI.this.tab.setTitle(string);
                }
            }
        }

        private class HeaderLabel
        extends JLabel {
            private Font f = null;

            public HeaderLabel() {
                this.setHorizontalAlignment(2);
                this.setIconTextGap(GUI.getScaledInt((int)5));
                this.f = super.getFont();
            }

            @Override
            protected void processMouseEvent(MouseEvent mouseEvent) {
                super.processMouseEvent(mouseEvent);
                TaskPaneTabHeader.this.processMouseEvent(mouseEvent);
            }

            @Override
            protected void processMouseMotionEvent(MouseEvent mouseEvent) {
                super.processMouseMotionEvent(mouseEvent);
                TaskPaneTabHeader.this.processMouseMotionEvent(mouseEvent);
            }

            @Override
            public Font getFont() {
                return this.f;
            }

            @Override
            public void setFont(Font font) {
                this.f = font;
                super.setFont(font);
            }
        }

        private class HeaderMouseListener
        extends MouseAdapter {
            private HeaderMouseListener() {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (!BasicTaskPaneTabUI.this.tab.isTitleEditable()) {
                    if (BasicTaskPaneTabUI.this.tab.isMouseHoverEnabled()) {
                        TaskPaneTabHeader.this.setCursor(Cursor.getPredefinedCursor(12));
                    }
                    TaskPaneTabHeader.this.highlight(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (BasicTaskPaneTabUI.this.tab.isMouseHoverEnabled()) {
                    TaskPaneTabHeader.this.setCursor(Cursor.getDefaultCursor());
                }
                TaskPaneTabHeader.this.highlight(false);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (BasicTaskPaneTabUI.this.tab.isMouseHoverEnabled()) {
                    TaskPaneTabHeader.this.setCursor(Cursor.getPredefinedCursor(12));
                }
            }
        }
    }
}

