/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls.taskpane;

import com.agfa.pacs.listtext.swingx.controls.AbstractComponent;
import com.agfa.pacs.listtext.swingx.controls.plaf.TaskPaneTabUI;
import com.agfa.pacs.tools.CompareUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class TaskPaneTab
extends AbstractComponent {
    private String title = null;
    private Icon titleIcon = null;
    private JComponent clientComponent = null;
    private Vector<JComponent> actionComponents = null;
    private boolean expanded = false;
    private boolean closeable = false;
    private boolean closed = false;
    private boolean mouseHover = true;
    private boolean titleEditing = false;
    private boolean titleEditable = false;
    private int expandCollapseIconType = 1;
    public static int defaultHeaderSize = 24;
    private int headerSize;
    private int headerBorderSize = 0;
    private int headerPaintType = 0;
    private Color titleForeground = null;
    private Color titleBackground = null;
    private Color primHeaderColor = null;
    private Color secHeaderColor = null;
    private Color titleForegroundExpanded = null;
    private Color titleBackgroundExpanded = null;
    public static final int EXPAND_COLLAPSE_ICON_ARROW = 0;
    public static final int EXPAND_COLLAPSE_ICON_SQUARE = 1;
    public static final String EXPAND_COLLAPSE_ICON_TYPE_CHANGED = "EXPAND_COLLAPSE_ICON_TYPE_CHANGED";
    public static final String SECONDARY_HEADER_COLOR_CHANGED = "SECONDARY_HEADER_COLOR_CHANGED";
    public static final String PRIMARY_HEADER_COLOR_CHANGED = "PRIMARY_HEADER_COLOR_CHANGED";
    public static final String HEADER_TITLE_BACKGROUND_CHANGED = "HEADER_TITLE_BACKGROUND_CHANGED";
    public static final String HEADER_TITLE_FOREGROUND_CHANGED = "HEADER_TITLE_FOREGROUND_CHANGED";
    public static final String HEADER_EXPANDED_TITLE_BACKGROUND_CHANGED = "HEADER_EXPANDED_TITLE_BACKGROUND_CHANGED";
    public static final String HEADER_EXPANDED_TITLE_FOREGROUND_CHANGED = "HEADER_EXPANDED_TITLE_FOREGROUND_CHANGED";
    public static final String HEADER_SIZE_CHANGED = "HEADER_SIZE_CHANGED";
    public static final String TAB_CLOSURE_FLAG_CHANGED = "TAB_CLOSURE_FLAG_CHANGED";
    public static final String TAB_EXPANSION_FLAG_CHANGED = "TAB_EXPANSION_FLAG_CHANGED";
    public static final String TAB_EXPANDING_STARTED = "TAB_EXPANDING_STARTED";
    public static final String TAB_EXPANDING_FINISHED = "TAB_EXPANDING_FINISHED";
    public static final String TAB_COLLAPSING_STARTED = "TAB_COLLAPSING_STARTED";
    public static final String TAB_COLLAPSING_FINISHED = "TAB_COLLAPSING_FINISHED";
    public static final String ACTION_COMPONENTS_CHANGED = "ACTION_COMPONENTS_CHANGED";
    public static final String CLIENT_COMPONENT_CHANGED = "CLIENT_COMPONENT_CHANGED";
    public static final String TITLE_CHANGED = "TITLE_CHANGED";
    public static final String TITLE_ICON_CHANGED = "TITLE_ICON_CHANGED";
    public static final String TITLE_EDITABLE_CHANGED = "TITLE_EDITABLE_CHANGED";
    public static final String TITLE_EDITING_CHANGED = "TITLE_EDITING_CHANGED";
    public static final String HIGHLIGHT_TAB = "HIGHLIGHT_TAB";

    public TaskPaneTab(String string) {
        this(string, null, false);
    }

    public TaskPaneTab(String string, JComponent jComponent) {
        this(string, jComponent, false);
    }

    public TaskPaneTab(String string, JComponent jComponent, boolean bl) {
        this(string, jComponent, null, bl);
    }

    public TaskPaneTab(String string, JComponent jComponent, List<JComponent> list, boolean bl) {
        this("TaskPaneTab", string, jComponent, list, bl);
    }

    public TaskPaneTab(String string, String string2, JComponent jComponent, List<JComponent> list, boolean bl) {
        this.setName(string);
        this.actionComponents = new Vector();
        this.title = string2 == null ? "" : string2;
        this.clientComponent = jComponent;
        this.closeable = bl;
        this.headerSize = defaultHeaderSize;
        this.setActionComponents(list);
        this.initUI();
    }

    @Override
    public Class<?> getComponentUIClass() {
        return TaskPaneTabUI.class;
    }

    @Override
    public String getUIClassID() {
        return "TaskPaneTabUI";
    }

    @Override
    public void registerUIClassPaths(Map<String, String> map) {
        map.put("Basic", "com.agfa.pacs.listtext.swingx.controls.plaf.basic.BasicTaskPaneTabUI");
    }

    public String getTitle() {
        return this.title;
    }

    public Icon getTitleIcon() {
        return this.titleIcon;
    }

    public List<JComponent> getActionComponents() {
        return this.actionComponents;
    }

    public JComponent getClientComponent() {
        return this.clientComponent;
    }

    public JComponent getTabComponent() {
        return this;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setTitle(String string) {
        if (!CompareUtils.equals((Object)this.title, (Object)string)) {
            String string2 = this.title;
            this.title = string != null ? string : "";
            this.firePropertyChange(TITLE_CHANGED, string2, this.title);
        }
    }

    public void setTitleIcon(Icon icon) {
        Icon icon2 = this.titleIcon;
        this.titleIcon = icon;
        this.firePropertyChange(TITLE_ICON_CHANGED, icon2, this.titleIcon);
    }

    public void setClientComponent(JComponent jComponent) {
        if (this.clientComponent != jComponent) {
            JComponent jComponent2 = this.clientComponent;
            this.clientComponent = jComponent == null ? new JPanel() : jComponent;
            this.firePropertyChange(CLIENT_COMPONENT_CHANGED, jComponent2, this.clientComponent);
        }
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.updateActionComponentNames();
    }

    public void setActionComponents(List<JComponent> list) {
        this.actionComponents.removeAllElements();
        if (list != null) {
            this.actionComponents.addAll(list);
        }
        this.updateActionComponentNames();
        this.firePropertyChange(ACTION_COMPONENTS_CHANGED, null, this.actionComponents);
    }

    private void updateActionComponentNames() {
        if (this.actionComponents != null) {
            String string = this.getName() != null ? String.valueOf(this.getName()) + "." : "";
            this.actionComponents.forEach(jComponent -> {
                if (jComponent instanceof JLabel) {
                    jComponent.setName(String.valueOf(string) + "Label");
                } else if (jComponent instanceof JButton) {
                    jComponent.setName(String.valueOf(string) + "Button");
                } else if (jComponent instanceof JToggleButton) {
                    jComponent.setName(String.valueOf(string) + "ToggleButton");
                } else if (jComponent instanceof JTextField) {
                    jComponent.setName(String.valueOf(string) + "TextField");
                } else if (jComponent instanceof JComboBox) {
                    jComponent.setName(String.valueOf(string) + "ComboBox");
                } else if (jComponent instanceof JSeparator) {
                    jComponent.setName(String.valueOf(string) + "Separator");
                }
            });
            this.actionComponents.addAll(this.actionComponents);
        }
    }

    public void setExpanded(boolean bl) {
        if (this.expanded != bl) {
            this.expanded = bl;
            this.firePropertyChange(TAB_EXPANSION_FLAG_CHANGED, !this.expanded, this.expanded);
        }
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean bl) {
        if (this.closed != bl) {
            this.closed = bl;
            this.firePropertyChange(TAB_CLOSURE_FLAG_CHANGED, !this.closed, this.closed);
        }
    }

    public boolean isMouseHoverEnabled() {
        return this.mouseHover;
    }

    public void setMouseHoverEnabled(boolean bl) {
        this.mouseHover = bl;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public void setHeaderSize(int n) {
        if (this.headerSize != n) {
            int n2 = this.headerSize;
            this.headerSize = n;
            this.firePropertyChange(HEADER_SIZE_CHANGED, n2, this.headerSize);
        }
    }

    public int getHeaderBorderSize() {
        return this.headerBorderSize;
    }

    public void setHeaderBorderSize(int n) {
        if (n >= 0 && this.headerBorderSize != n) {
            this.headerBorderSize = n;
            this.revalidate();
            this.repaint();
        }
    }

    public int getHeaderPaintingType() {
        return this.headerPaintType;
    }

    public Color getTitleForeground() {
        return this.titleForeground;
    }

    public void setTitleForeground(Color color) {
        if (this.titleForeground != color) {
            Color color2 = this.titleForeground;
            this.titleForeground = color;
            this.firePropertyChange(HEADER_TITLE_FOREGROUND_CHANGED, color2, this.titleForeground);
        }
    }

    public Color getTitleBackgroundExpanded() {
        return this.titleBackgroundExpanded;
    }

    public void setTitleBackgroundExpanded(Color color) {
        if (this.titleBackgroundExpanded != color) {
            Color color2 = this.titleBackgroundExpanded;
            this.titleBackgroundExpanded = color;
            this.firePropertyChange(HEADER_EXPANDED_TITLE_BACKGROUND_CHANGED, color2, this.titleBackgroundExpanded);
        }
    }

    public Color getTitleForegroundExpanded() {
        return this.titleForegroundExpanded;
    }

    public void setTitleForegroundExpanded(Color color) {
        if (this.titleForegroundExpanded != color) {
            Color color2 = this.titleForegroundExpanded;
            this.titleForegroundExpanded = color;
            this.firePropertyChange(HEADER_EXPANDED_TITLE_FOREGROUND_CHANGED, color2, this.titleForegroundExpanded);
        }
    }

    public Color getTitleBackground() {
        return this.titleBackground;
    }

    public void setTitleBackground(Color color) {
        if (this.titleBackground != color) {
            Color color2 = this.titleBackground;
            this.titleBackground = color;
            this.firePropertyChange(HEADER_TITLE_BACKGROUND_CHANGED, color2, this.titleBackground);
        }
    }

    public void setPrimaryHeaderColor(Color color) {
        if (this.primHeaderColor != color) {
            Color color2 = this.primHeaderColor;
            this.primHeaderColor = color;
            this.firePropertyChange(PRIMARY_HEADER_COLOR_CHANGED, color2, this.primHeaderColor);
        }
    }

    public void setSecondaryHeaderColor(Color color) {
        if (this.secHeaderColor != color) {
            Color color2 = this.secHeaderColor;
            this.secHeaderColor = color;
            this.firePropertyChange(SECONDARY_HEADER_COLOR_CHANGED, color2, this.secHeaderColor);
        }
    }

    public int getExpandCollapseIconType() {
        return this.expandCollapseIconType;
    }

    public void setExpandCollapseIconType(int n) {
        if (this.expandCollapseIconType == n) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: {
                int n2 = this.expandCollapseIconType;
                this.expandCollapseIconType = n;
                this.firePropertyChange(EXPAND_COLLAPSE_ICON_TYPE_CHANGED, n2, n);
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        return new Dimension(dimension.width, this.headerSize);
    }

    public void setHighlighted(boolean bl) {
        this.firePropertyChange(HIGHLIGHT_TAB, !bl, bl);
    }

    public boolean isTitleEditable() {
        return this.titleEditable;
    }

    public void setTitleEditable(boolean bl) {
        if (this.titleEditable != bl) {
            this.titleEditable = bl;
            this.titleEditing = false;
            this.firePropertyChange(TITLE_EDITABLE_CHANGED, !bl, bl);
        }
    }

    public boolean isTitleEditing() {
        return this.titleEditing;
    }

    public void setTitleEditing(boolean bl) {
        if (this.titleEditing != bl) {
            this.titleEditing = bl;
            this.firePropertyChange(TITLE_EDITING_CHANGED, !this.titleEditing, this.titleEditing);
        }
    }
}

