/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls.timetable;

import com.agfa.hap.pacs.data.DateUtilities;
import com.agfa.pacs.listtext.swingx.controls.Messages;
import com.agfa.pacs.listtext.swingx.controls.timetable.ITimeTableItem;
import com.agfa.pacs.listtext.swingx.controls.timetable.ITimeTableItemProvider;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public final class TimeTableModel {
    private Date date;
    private TimeTableType type;
    private ITimeTableItemProvider provider;
    private TimeTableSort sort;
    private final List<ITimeTableModelListener> listeners;
    private static final TreeMap<Date, SortedSet<? extends ITimeTableItem>> emptyMap = new TreeMap();
    private static final SortedSet<? extends ITimeTableItem> emptySet = new TreeSet<ITimeTableItem>();

    public TimeTableModel() {
        this(null);
    }

    public TimeTableModel(ITimeTableItemProvider iTimeTableItemProvider) {
        this(null, iTimeTableItemProvider);
    }

    public TimeTableModel(TimeTableType timeTableType, ITimeTableItemProvider iTimeTableItemProvider) {
        this(null, null, iTimeTableItemProvider);
    }

    public TimeTableModel(Date date, TimeTableType timeTableType, ITimeTableItemProvider iTimeTableItemProvider) {
        this.date = date != null ? date : new Date();
        this.type = timeTableType != null ? timeTableType : TimeTableType.Week;
        this.sort = TimeTableSort.TIME_ASCENDING;
        this.provider = iTimeTableItemProvider;
        this.listeners = new ArrayList<ITimeTableModelListener>(4);
    }

    public ITimeTableItemProvider getProvider() {
        return this.provider;
    }

    public void setProvider(ITimeTableItemProvider iTimeTableItemProvider) {
        this.provider = iTimeTableItemProvider;
        this.notifyModelChanged();
    }

    public TimeTableType getType() {
        return this.type;
    }

    public void setType(TimeTableType timeTableType) {
        if (!this.type.equals(timeTableType)) {
            this.type = timeTableType;
            this.notifyModelChanged();
        }
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        if (!this.date.equals(date)) {
            this.date = date;
            this.notifyModelChanged();
        }
    }

    public List<Date> getDates() {
        return this.type.getDates(this.date);
    }

    public TimeTableSort getSort() {
        return this.sort;
    }

    public void setSort(TimeTableSort timeTableSort) {
        if (this.sort != timeTableSort) {
            this.sort = timeTableSort;
            this.notifyModelChanged();
        }
    }

    public SortedMap<Date, SortedSet<? extends ITimeTableItem>> getItems() {
        if (this.provider != null) {
            return this.type.getItems(this.date, this.provider);
        }
        return emptyMap;
    }

    public void addListener(ITimeTableModelListener iTimeTableModelListener) {
        if (!this.listeners.contains(iTimeTableModelListener)) {
            this.listeners.add(iTimeTableModelListener);
        }
    }

    public void removeListener(ITimeTableModelListener iTimeTableModelListener) {
        this.listeners.remove(iTimeTableModelListener);
    }

    private void notifyModelChanged() {
        if (this.listeners != null) {
            for (ITimeTableModelListener iTimeTableModelListener : this.listeners) {
                iTimeTableModelListener.modelChanged();
            }
        }
    }

    public static interface ITimeTableModelListener {
        public void modelChanged();
    }

    public static enum TimeTableSort {
        TIME_ASCENDING("Time", true),
        TIME_DESCENDING("Time", false),
        NAME_ASCENDING("Name", true),
        NAME_DESCENDING("Name", false);

        private final String msgKeySuffix;
        private final boolean ascending;

        private TimeTableSort(String string2, boolean bl) {
            this.msgKeySuffix = string2;
            this.ascending = bl;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public String toSymbolString() {
            return Messages.getString("TimeTable.SortedBy." + this.msgKeySuffix) + " " + Messages.getString("TimeTable.SortDirection." + (this.ascending ? "Ascending.Symbol" : "Descending.Symbol"));
        }

        public String toString() {
            return Messages.getString("TimeTable.SortedBy." + this.msgKeySuffix) + " " + Messages.getString("TimeTable.SortDirection." + (this.ascending ? "Ascending" : "Descending"));
        }
    }

    public static abstract class TimeTableType {
        private String name;
        public static final TimeTableType Days7 = new TimeTableType("Days7"){

            @Override
            public List<Date> getDates(Date date) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(DateUtilities.resetTime((Date)date));
                calendar.add(5, -3);
                ArrayList<Date> arrayList = new ArrayList<Date>(7);
                int n = 0;
                while (n < 7) {
                    arrayList.add(calendar.getTime());
                    calendar.add(5, 1);
                    ++n;
                }
                return arrayList;
            }
        };
        public static final TimeTableType Week = new TimeTableType("Week"){

            @Override
            public List<Date> getDates(Date date) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(DateUtilities.resetTime((Date)date));
                while (calendar.get(7) != 2) {
                    calendar.add(5, -1);
                }
                ArrayList<Date> arrayList = new ArrayList<Date>(7);
                int n = 0;
                while (n < 7) {
                    arrayList.add(calendar.getTime());
                    calendar.add(5, 1);
                    ++n;
                }
                return arrayList;
            }
        };
        public static final TimeTableType Month = new TimeTableType("Month"){

            @Override
            public List<Date> getDates(Date date) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(DateUtilities.resetTime((Date)date));
                ArrayList<Date> arrayList = new ArrayList<Date>(7);
                int n = 1;
                while (n < calendar.getActualMinimum(5)) {
                    calendar.set(5, n);
                    arrayList.add(calendar.getTime());
                    ++n;
                }
                return arrayList;
            }
        };

        private TimeTableType(String string) {
            this.name = string;
        }

        public final String name() {
            return this.name;
        }

        public abstract List<Date> getDates(Date var1);

        public final SortedMap<Date, SortedSet<? extends ITimeTableItem>> getItems(Date date, ITimeTableItemProvider iTimeTableItemProvider) {
            List<Date> list = this.getDates(date);
            TreeMap<Date, SortedSet<? extends ITimeTableItem>> treeMap = new TreeMap<Date, SortedSet<? extends ITimeTableItem>>();
            Iterator<Date> iterator = list.iterator();
            while (iterator.hasNext()) {
                Date date2;
                SortedSet sortedSet = iTimeTableItemProvider.getScheduledItems(date2 = iterator.next());
                treeMap.put(date2, sortedSet != null ? sortedSet : emptySet);
            }
            return treeMap;
        }
    }
}

