/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.controls.timetable;

import com.agfa.hap.pacs.data.DateUtilities;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.listtext.swingx.controls.timetable.ITimeTableItem;
import com.agfa.pacs.listtext.swingx.controls.timetable.ITimeTablePopupListener;
import com.agfa.pacs.listtext.swingx.controls.timetable.TimeTable;
import com.agfa.pacs.listtext.swingx.controls.timetable.TimeTableItemComparator;
import com.agfa.pacs.listtext.swingx.controls.timetable.TimeTableModel;
import com.agfa.pacs.listtext.swingx.controls.timetable.TimeTableUtils;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class TimeTableWeekTable
extends JTable
implements TimeTable.ITimeTableContent {
    private ITimeTableItem hoveredItem;
    private ITimeTablePopupListener popupListener;

    TimeTableWeekTable() {
        this((TimeTableModel)null);
    }

    TimeTableWeekTable(TimeTableModel timeTableModel) {
        super(new TimeTableWeekTableModel(timeTableModel));
        this.setBackground(ColorUtils.getBlack());
        this.getTableHeader().setDefaultRenderer(new DefaultHeaderRenderer(this));
        this.getTableHeader().setPreferredSize(GUI.getScaledDimension((int)10, (int)40));
        this.getTableHeader().setReorderingAllowed(false);
        this.setRowHeight(GUI.getScaledInt((int)50));
        this.setItemRenderer(new DefaultTimeTableItemRenderer());
        this.setAutoResizeMode(4);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(false);
        this.setShowHorizontalLines(false);
        this.setFillsViewportHeight(true);
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
    }

    @Override
    public TableCellRenderer getItemRenderer() {
        return this.getDefaultRenderer(ITimeTableItem.class);
    }

    @Override
    public void setItemRenderer(TableCellRenderer tableCellRenderer) {
        this.setDefaultRenderer(ITimeTableItem.class, tableCellRenderer);
    }

    @Override
    public TimeTableWeekTableModel getModel() {
        return (TimeTableWeekTableModel)super.getModel();
    }

    @Override
    public JTable getContentComponent() {
        return this;
    }

    @Override
    public void init(TimeTableModel timeTableModel) {
        this.getModel().init(timeTableModel);
        this.createDefaultColumnsFromModel();
    }

    public ITimeTablePopupListener getPopupListener() {
        return this.popupListener;
    }

    public void setPopupListener(ITimeTablePopupListener iTimeTablePopupListener) {
        this.popupListener = iTimeTablePopupListener;
    }

    private static boolean isWeekend(JTable jTable, int n) {
        if (jTable instanceof TimeTableWeekTable) {
            Date date = ((TimeTableWeekTable)jTable).getModel().dateForColumn(n);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar.get(7) == 7 || calendar.get(7) == 1;
        }
        return false;
    }

    private static boolean isToday(JTable jTable, int n) {
        if (jTable instanceof TimeTableWeekTable) {
            Date date = ((TimeTableWeekTable)jTable).getModel().dateForColumn(n);
            Date date2 = DateUtilities.resetTime((Date)new Date());
            return date2.equals(DateUtilities.resetTime((Date)date));
        }
        return false;
    }

    private ITimeTableItem itemAtPoint(Point point) {
        Object object;
        int n = this.convertColumnIndexToModel(this.columnAtPoint(point));
        int n2 = this.convertRowIndexToModel(this.rowAtPoint(point));
        if (n2 >= 0 && (object = this.getValueAt(n2, n)) instanceof ITimeTableItem) {
            return (ITimeTableItem)object;
        }
        return null;
    }

    public static class DefaultHeaderRenderer
    implements TableCellRenderer {
        private static final ThreadLocal<DateFormat> dayFormat = new LocalDayFormat();
        private static final ThreadLocal<DateFormat> dateFormat = new LocalDateFormat();
        private TableCellRenderer installedRenderer;

        public DefaultHeaderRenderer(JTable jTable) {
            this.installedRenderer = jTable.getTableHeader().getDefaultRenderer();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.installedRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            component.setBackground(ColorUtils.getSecondary2());
            if (object != null) {
                try {
                    Date date = new Date(Long.valueOf(object.toString()));
                    if (component instanceof JLabel) {
                        ((JLabel)component).setText(DefaultHeaderRenderer.toCaption(date));
                    }
                    if (TimeTableWeekTable.isToday(jTable, n2)) {
                        Color color = ColorUtils.getSelection3();
                        if (color == null) {
                            color = Color.ORANGE;
                        }
                        component.setForeground(color);
                    } else if (TimeTableWeekTable.isWeekend(jTable, n2)) {
                        component.setForeground(component.getForeground().darker());
                    }
                }
                catch (Exception exception) {}
            }
            return component;
        }

        private static String toCaption(Date date) {
            StringBuilder stringBuilder = new StringBuilder();
            if (date != null) {
                stringBuilder.append("<html>");
                stringBuilder.append("<b>").append(dayFormat.get().format(date)).append("</b>");
                stringBuilder.append("<br/>");
                stringBuilder.append(dateFormat.get().format(date));
                stringBuilder.append("</html>");
            }
            return stringBuilder.toString();
        }
    }

    public static class DefaultTimeTableItemRenderer
    extends JPanel
    implements TableCellRenderer {
        private static final ThreadLocal<DateFormat> timeFormat = new LocalTimeFormat();
        private static final String PROP_ITEM_BACKGROUND_COLOR = "item.background.color";
        private static final String PROP_ITEM_FOREGROUND_COLOR = "item.foreground.color";
        private static final int BORDER = GUI.getScaledInt((int)2);
        private JLabel line1;
        private JLabel line2;
        private Border lineBorder;
        private Color bgDefault = ColorUtils.getSecondary1();

        public DefaultTimeTableItemRenderer() {
            this.setLayout(new GridLayout(2, 1));
            this.line1 = new JLabel();
            this.add(this.line1);
            this.line2 = new JLabel();
            this.add(this.line2);
            this.lineBorder = BorderFactory.createEmptyBorder(0, BORDER, 0, BORDER);
            this.line1.setBorder(this.lineBorder);
            this.line2.setBorder(this.lineBorder);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ITimeTableItem iTimeTableItem = (ITimeTableItem)object;
            this.setBackground(TimeTableWeekTable.isWeekend(jTable, n2) ? ColorUtils.applyAlpha(ColorUtils.getSecondary2(), 196) : this.bgDefault);
            this.line1.setHorizontalAlignment(0);
            this.line1.setVerticalAlignment(3);
            this.line2.setHorizontalAlignment(0);
            this.line2.setVerticalAlignment(1);
            if (iTimeTableItem == null) {
                this.putClientProperty(PROP_ITEM_BACKGROUND_COLOR, null);
                this.putClientProperty(PROP_ITEM_FOREGROUND_COLOR, null);
                this.line1.setForeground(jTable.getForeground());
                this.line1.setFont(jTable.getFont());
                this.setToolTipText(null);
                this.line1.setText(null);
                this.line2.setText(null);
            } else {
                boolean bl3 = iTimeTableItem == ((TimeTableWeekTable)jTable).hoveredItem;
                Color color = this.getItemBackground(jTable, iTimeTableItem, bl3);
                Color color2 = this.getItemForeground(jTable, iTimeTableItem, bl3);
                Font font = this.getItemFont(jTable, iTimeTableItem, bl3);
                this.putClientProperty(PROP_ITEM_BACKGROUND_COLOR, color);
                this.putClientProperty(PROP_ITEM_FOREGROUND_COLOR, color2);
                this.setToolTipText(DefaultTimeTableItemRenderer.toCaption(iTimeTableItem));
                this.line1.setForeground(color2);
                this.line1.setFont(font);
                this.line1.setText(iTimeTableItem.getCaption());
                this.line2.setForeground(color2);
                this.line2.setFont(font);
                this.line2.setText(timeFormat.get().format(iTimeTableItem.getStartDateTime()));
            }
            return this;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Color color = (Color)this.getClientProperty(PROP_ITEM_BACKGROUND_COLOR);
            if (color != null) {
                Color color2 = graphics.getColor();
                graphics.setColor(color);
                graphics.fillRect(BORDER, BORDER, this.getWidth() - 2 * BORDER - 1, this.getHeight() - 2 * BORDER - 1);
                graphics.setColor(color.brighter());
                graphics.drawRect(BORDER, BORDER, this.getWidth() - 2 * BORDER - 1, this.getHeight() - 2 * BORDER - 1);
                graphics.setColor(color2);
            }
        }

        protected Color getItemBackground(JTable jTable, ITimeTableItem iTimeTableItem, boolean bl) {
            if (iTimeTableItem.isSelected()) {
                return ColorUtils.getSelection1();
            }
            return bl ? ColorUtils.getPrimary1() : ColorUtils.getPrimary2();
        }

        protected Color getItemForeground(JTable jTable, ITimeTableItem iTimeTableItem, boolean bl) {
            Color color = null;
            if (iTimeTableItem.isSelected()) {
                return UIManager.getColor("Table.selectionForeground");
            }
            color = jTable.getForeground();
            if (bl) {
                color = color.brighter();
            }
            return color;
        }

        protected Font getItemFont(JTable jTable, ITimeTableItem iTimeTableItem, boolean bl) {
            Font font = UIManager.getFont("TableHeader.font");
            if (font == null) {
                font = jTable.getFont();
            }
            return font;
        }

        static String toCaption(ITimeTableItem iTimeTableItem) {
            StringBuilder stringBuilder = new StringBuilder();
            if (iTimeTableItem != null) {
                stringBuilder.append("<html><p align='center'>");
                stringBuilder.append(iTimeTableItem.getCaption());
                stringBuilder.append("<br/>");
                stringBuilder.append("<i>").append(timeFormat.get().format(iTimeTableItem.getStartDateTime())).append("</i>");
                stringBuilder.append("</p></html>");
            }
            return stringBuilder.toString();
        }
    }

    private static class LocalDateFormat
    extends ThreadLocal<DateFormat> {
        private LocalDateFormat() {
        }

        @Override
        protected DateFormat initialValue() {
            return DateFormat.getDateInstance(2);
        }
    }

    private static class LocalDayFormat
    extends ThreadLocal<DateFormat> {
        private LocalDayFormat() {
        }

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("EEE");
        }
    }

    private static class LocalTimeFormat
    extends ThreadLocal<DateFormat> {
        private LocalTimeFormat() {
        }

        @Override
        protected DateFormat initialValue() {
            return DateFormat.getTimeInstance(3);
        }
    }

    private static class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.handlePopupRequest(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.handlePopupRequest(mouseEvent);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                Component component = mouseEvent.getComponent();
                if (component instanceof TimeTableWeekTable) {
                    ITimeTableItem iTimeTableItem;
                    TimeTableWeekTable timeTableWeekTable = (TimeTableWeekTable)component;
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && (iTimeTableItem = timeTableWeekTable.itemAtPoint(mouseEvent.getPoint())) != null) {
                        iTimeTableItem.setSelected(!iTimeTableItem.isSelected());
                        timeTableWeekTable.revalidate();
                        timeTableWeekTable.repaint();
                    }
                }
            } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.handlePopupRequest(mouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            TimeTableWeekTable timeTableWeekTable;
            ITimeTableItem iTimeTableItem;
            Component component = mouseEvent.getComponent();
            if (component instanceof TimeTableWeekTable && (iTimeTableItem = (timeTableWeekTable = (TimeTableWeekTable)component).itemAtPoint(mouseEvent.getPoint())) != timeTableWeekTable.hoveredItem) {
                timeTableWeekTable.hoveredItem = iTimeTableItem;
                timeTableWeekTable.repaint();
            }
        }

        private void handlePopupRequest(MouseEvent mouseEvent) {
            ITimeTableItem iTimeTableItem;
            TimeTableWeekTable timeTableWeekTable;
            ITimeTablePopupListener iTimeTablePopupListener;
            Component component = mouseEvent.getComponent();
            if (component instanceof TimeTableWeekTable && (iTimeTablePopupListener = (timeTableWeekTable = (TimeTableWeekTable)component).getPopupListener()) != null && (iTimeTableItem = timeTableWeekTable.itemAtPoint(mouseEvent.getPoint())) != null) {
                iTimeTablePopupListener.handlePopupRequest(mouseEvent, iTimeTableItem);
            }
        }
    }

    private static class TimeTableWeekTableModel
    extends AbstractTableModel {
        private static final long TIME_RESOLUTION_MSEC = 3600000L;
        private List<Date> dates = new ArrayList<Date>(7);
        private List<Row> rows = new ArrayList<Row>();

        TimeTableWeekTableModel(TimeTableModel timeTableModel) {
            this.init(timeTableModel);
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return this.dates.size();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return ITimeTableItem.class;
        }

        @Override
        public String getColumnName(int n) {
            if (n >= 0 && n < this.dates.size()) {
                return Long.toString(this.dates.get(n).getTime());
            }
            return null;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Row row = this.rows.get(n);
            if (row != null) {
                return row.getItem(this.dates.get(n2));
            }
            return null;
        }

        public void init(TimeTableModel timeTableModel) {
            this.dates.clear();
            this.rows.clear();
            if (timeTableModel != null) {
                Set<ITimeTableItem> set;
                Object object;
                Object object2;
                Object object32;
                this.dates.addAll(timeTableModel.getDates());
                SortedMap<Date, SortedSet<? extends ITimeTableItem>> sortedMap = timeTableModel.getItems();
                TreeMap<TimeTableItemKey, TreeSet<ITimeTableItem>> treeMap = new TreeMap<TimeTableItemKey, TreeSet<ITimeTableItem>>(TimeTableItemKey.getComparator(timeTableModel.getSort()));
                for (Object object32 : sortedMap.values()) {
                    object2 = object32.iterator();
                    while (object2.hasNext()) {
                        ITimeTableItem iTimeTableItem = (ITimeTableItem)object2.next();
                        object = TimeTableItemKey.get(iTimeTableItem);
                        set = (Set)treeMap.get(object);
                        if (set == null) {
                            set = new TreeSet<ITimeTableItem>(TimeTableItemComparator.getDateTimeComparator());
                            treeMap.put((TimeTableItemKey)object, (TreeSet<ITimeTableItem>)set);
                        }
                        set.add(iTimeTableItem);
                    }
                }
                object32 = new HashMap();
                for (Object object4 : treeMap.values()) {
                    object = object4.iterator();
                    while (object.hasNext()) {
                        object2 = (ITimeTableItem)object.next();
                        set = TimeTableUtils.startDate((ITimeTableItem)object2);
                        TimeTableItemKey timeTableItemKey = TimeTableItemKey.get((ITimeTableItem)object2);
                        Row row = null;
                        Row row2 = (Row)object32.get(timeTableItemKey);
                        if (row2 != null && !row2.hasItem((Date)((Object)set))) {
                            row = row2;
                        }
                        if (row == null) {
                            row = new Row();
                            this.rows.add(row);
                            if (!object32.containsKey(timeTableItemKey)) {
                                object32.put(timeTableItemKey, row);
                            }
                        }
                        row.setItem((Date)((Object)set), (ITimeTableItem)object2);
                    }
                }
            }
            this.fireTableDataChanged();
        }

        Date dateForColumn(int n) {
            return this.dates.get(n);
        }

        private static final class Row {
            private final Map<Date, ITimeTableItem> items = new HashMap<Date, ITimeTableItem>(7);

            private Row() {
            }

            public boolean hasItem(Date date) {
                return this.items.get(date) != null;
            }

            public ITimeTableItem getItem(Date date) {
                return this.items.get(date);
            }

            public void setItem(Date date, ITimeTableItem iTimeTableItem) {
                this.items.put(date, iTimeTableItem);
            }
        }

        private static final class TimeTableItemKey {
            private static Map<TimeTableModel.TimeTableSort, Comparator<TimeTableItemKey>> comparators = new EnumMap<TimeTableModel.TimeTableSort, Comparator<TimeTableItemKey>>(TimeTableModel.TimeTableSort.class);
            private final String caption;
            private final Date startTime;
            private final long timeBin;

            private TimeTableItemKey(String string, Date date, long l) {
                this.caption = string;
                this.startTime = date;
                this.timeBin = l;
            }

            public static TimeTableItemKey get(ITimeTableItem iTimeTableItem) {
                return new TimeTableItemKey(iTimeTableItem.getCaption(), TimeTableUtils.startTime(iTimeTableItem), TimeTableItemKey.snapItem(iTimeTableItem));
            }

            public static synchronized Comparator<TimeTableItemKey> getComparator(TimeTableModel.TimeTableSort timeTableSort) {
                if (comparators.get((Object)timeTableSort) == null) {
                    switch (timeTableSort) {
                        case NAME_ASCENDING: {
                            comparators.put(timeTableSort, TimeTableItemKey.nameComparator(true));
                            break;
                        }
                        case NAME_DESCENDING: {
                            comparators.put(timeTableSort, TimeTableItemKey.nameComparator(false));
                            break;
                        }
                        case TIME_ASCENDING: {
                            comparators.put(timeTableSort, TimeTableItemKey.timeComparator(true));
                            break;
                        }
                        default: {
                            comparators.put(timeTableSort, TimeTableItemKey.timeComparator(false));
                        }
                    }
                }
                return comparators.get((Object)timeTableSort);
            }

            public boolean equals(Object object) {
                if (object instanceof TimeTableItemKey) {
                    return this.hashCode() == object.hashCode();
                }
                return super.equals(object);
            }

            public int hashCode() {
                return new HashCodeBuilder().append((Object)this.caption).append(this.timeBin).build();
            }

            private static long snapItem(ITimeTableItem iTimeTableItem) {
                return Math.max(0L, TimeTableUtils.millis(iTimeTableItem) - 1800000L) / 3600000L;
            }

            private static Comparator<TimeTableItemKey> timeComparator(final boolean bl) {
                return new Comparator<TimeTableItemKey>(){

                    @Override
                    public int compare(TimeTableItemKey timeTableItemKey, TimeTableItemKey timeTableItemKey2) {
                        int n = bl ? timeTableItemKey.startTime.compareTo(timeTableItemKey2.startTime) : timeTableItemKey2.startTime.compareTo(timeTableItemKey.startTime);
                        return n == 0 ? -1 : n;
                    }
                };
            }

            private static Comparator<TimeTableItemKey> nameComparator(final boolean bl) {
                return new Comparator<TimeTableItemKey>(){

                    @Override
                    public int compare(TimeTableItemKey timeTableItemKey, TimeTableItemKey timeTableItemKey2) {
                        int n = bl ? timeTableItemKey.caption.compareTo(timeTableItemKey2.caption) : timeTableItemKey2.caption.compareTo(timeTableItemKey.caption);
                        return n == 0 ? -1 : n;
                    }
                };
            }
        }
    }
}

