/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.icon;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.util.ImageUtils;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.listtext.swingx.icon.PIconFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public abstract class IconUtil {
    private static final PIconFactory ICON_FACTORY = PIconFactory.createdFixedSizeIconFactory(false, new int[0]);
    private static final PIcon ADD_ICON = ICON_FACTORY.loadIcon(IconUtil.class, "/nice/icons/add.svg");
    private static final PIcon COPY_ICON = ICON_FACTORY.loadIcon(IconUtil.class, "/nice/icons/copy.svg");
    private static final PIcon EDIT_ICON = ICON_FACTORY.loadIcon(IconUtil.class, "/nice/icons/edit.svg");
    private static final PIcon ERROR_ICON = ICON_FACTORY.loadIcon(IconUtil.class, "/nice/icons/error.svg");
    private static final PIcon EXPORT_ICON = ICON_FACTORY.loadIcon(IconUtil.class, "/nice/icons/export.svg");
    private static final PIcon IMPORT_ICON = ICON_FACTORY.loadIcon(IconUtil.class, "/nice/icons/import.svg");
    private static final PIcon INFORMATION_ICON = ICON_FACTORY.loadIcon(IconUtil.class, "/nice/icons/info.svg");
    private static final PIcon NEARLINE_ICON = ICON_FACTORY.loadIcon(IconUtil.class, "/nice/icons/nearline.svg");
    private static final PIcon OFFLINE_ICON = ICON_FACTORY.loadIcon(IconUtil.class, "/nice/icons/offline.svg");
    private static final PIcon OPEN_ICON = ICON_FACTORY.loadIcon(IconUtil.class, "/nice/icons/open.svg");
    private static final PIcon PASTE_ICON = ICON_FACTORY.loadIcon(IconUtil.class, "/nice/icons/paste.svg");
    private static final PIcon QUESTION_ICON = ICON_FACTORY.loadIcon(IconUtil.class, "/nice/icons/question.svg");
    private static final PIcon SLOW_ICON = ICON_FACTORY.loadIcon(IconUtil.class, "/nice/icons/slow.svg");
    private static final PIcon TRASH_BIN_ICON = ICON_FACTORY.loadIcon(IconUtil.class, "/nice/icons/trashBin.svg");
    private static final PIcon WARNING_ICON = ICON_FACTORY.loadIcon(IconUtil.class, "/nice/icons/warning.svg");
    private static final int OPEN_ICON_DEFAULT_HEIGHT = 19;

    public static Icon getIcon(IconInfo iconInfo) {
        return UIManager.getIcon(iconInfo.getKey());
    }

    public static ImageIcon getAddIcon(int n) {
        return ADD_ICON.scaleToHeight(n);
    }

    public static ImageIcon getCopyIcon(int n) {
        return COPY_ICON.scaleToHeight(n);
    }

    public static ImageIcon getEditIcon(int n) {
        return EDIT_ICON.scaleToHeight(n);
    }

    public static Icon getErrorIcon(int n) {
        return ERROR_ICON.scaleToHeight(n);
    }

    public static ImageIcon getExportIcon(int n) {
        return EXPORT_ICON.scaleToHeight(n);
    }

    public static ImageIcon getImportIcon(int n) {
        return IMPORT_ICON.scaleToHeight(n);
    }

    public static Icon getInformationIcon(int n) {
        return INFORMATION_ICON.scaleToHeight(n);
    }

    public static Icon getNearlineIcon(int n) {
        return NEARLINE_ICON.scaleToHeight(n);
    }

    public static Icon getQuestionIcon(int n) {
        return QUESTION_ICON.scaleToHeight(n);
    }

    public static Icon getSlowIcon(int n) {
        return SLOW_ICON.scaleToHeight(n);
    }

    public static ImageIcon getTrashBinIcon(int n) {
        return TRASH_BIN_ICON.scaleToHeight(n);
    }

    public static Icon getOfflineIcon(int n) {
        return OFFLINE_ICON.scaleToHeight(n);
    }

    public static Icon getOpenIcon() {
        return OPEN_ICON.scaleToHeight((int)(19.0 * GUI.getScaleFactor()));
    }

    public static ImageIcon getPasteIcon(int n) {
        return PASTE_ICON.scaleToHeight(n);
    }

    public static Icon getWarningIcon(int n) {
        return WARNING_ICON.scaleToHeight(n);
    }

    public static ImageIcon scaleIcon(Icon icon, float f, Component component) {
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        int n3 = Math.round((float)n * f);
        int n4 = Math.round((float)n2 * f);
        return IconUtil.scaleIcon(icon, n3, n4, component);
    }

    public static ImageIcon scaleIcon(Icon icon, int n, int n2, Component component) {
        if (icon instanceof ImageIcon) {
            return IconUtil.scaleImageIcon((ImageIcon)icon, n, n2);
        }
        int n3 = icon.getIconWidth();
        int n4 = icon.getIconHeight();
        ImageGraphics imageGraphics = IconUtil.prepareGraphicsForImageScaling(n3, n4, n, n2, component != null ? component.getBackground() : null);
        icon.paintIcon(null, imageGraphics.graphics, 0, 0);
        imageGraphics.graphics.dispose();
        return new ImageIcon(imageGraphics.image);
    }

    public static ImageIcon scaleImageIcon(ImageIcon imageIcon, float f) {
        int n = imageIcon.getIconWidth();
        int n2 = imageIcon.getIconHeight();
        n = Math.round((float)n * f);
        n2 = Math.round((float)n2 * f);
        return IconUtil.scaleImageIcon(imageIcon, n, n2);
    }

    public static ImageIcon scaleImageIcon(ImageIcon imageIcon, int n, int n2) {
        Image image = imageIcon.getImage();
        image = IconUtil.scaleImage(image, n, n2);
        return new ImageIcon(image);
    }

    public static ImageIcon scaleImageIconForDiagnosticMonitor(ImageIcon imageIcon) {
        return IconUtil.scaleImageIcon(imageIcon, (float)GUI.getScaleDiagnosticFactor());
    }

    public static Icon scaleIconForDiagnosticMonitor(Icon icon) {
        if (icon instanceof PIcon) {
            return icon;
        }
        return IconUtil.scaleIcon(icon, (float)GUI.getScaleDiagnosticFactor(), null);
    }

    public static Icon scaleIconForLTA(Icon icon) {
        return IconUtil.scaleIcon(icon, (float)GUI.getScaleFactor(), null);
    }

    public static Image scaleImage(Image image, int n, int n2) {
        ImageGraphics imageGraphics = IconUtil.prepareGraphicsForImageScaling(image.getWidth(null), image.getHeight(null), n, n2, null);
        imageGraphics.graphics.drawImage(image, 0, 0, null);
        imageGraphics.graphics.dispose();
        return imageGraphics.image;
    }

    public static Image toImage(Icon icon) {
        return IconUtil.toImage(icon, null);
    }

    public static Image toImage(Icon icon, Component component) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics graphics = bufferedImage.getGraphics();
        icon.paintIcon(component, graphics, 0, 0);
        return bufferedImage;
    }

    public static Icon mergeIconsSideBySide(Icon icon, Icon icon2, int n) {
        if (icon2 == null) {
            return icon;
        }
        if (icon == null) {
            return icon2;
        }
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth() + icon2.getIconWidth() + n, Math.max(icon.getIconHeight(), icon2.getIconHeight()), 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(IconUtil.toImage(icon), 0, bufferedImage.getHeight() / 2 - icon.getIconHeight() / 2, null);
        graphics.drawImage(IconUtil.toImage(icon2), icon.getIconWidth() + n + 1, bufferedImage.getHeight() / 2 - icon2.getIconHeight() / 2, null);
        return new ImageIcon(bufferedImage);
    }

    public static Icon emptyIcon(final int n, final int n2) {
        return new Icon(){

            @Override
            public void paintIcon(Component component, Graphics graphics, int n3, int n22) {
            }

            @Override
            public int getIconWidth() {
                return n;
            }

            @Override
            public int getIconHeight() {
                return n2;
            }
        };
    }

    private static ImageGraphics prepareGraphicsForImageScaling(int n, int n2, int n3, int n4, Color color) {
        double d;
        double d2;
        assert (n3 > 0 || n4 > 0) : "Can not scale without target";
        if (n3 <= 0) {
            d = d2 = (double)n4 / (double)n2;
            n3 = (int)Math.round((double)n * d);
        } else if (n4 <= 0) {
            d2 = d = (double)n3 / (double)n;
            n4 = (int)Math.round((double)n2 * d2);
        } else {
            d = (double)n3 / (double)n;
            d2 = (double)n4 / (double)n2;
        }
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.scale(d, d2);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        if (color != null) {
            graphics2D.setColor(color);
        }
        return new ImageGraphics(graphics2D, bufferedImage);
    }

    public static ImageIcon darkenIcon(ImageIcon imageIcon, float f) {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2;
        if (imageIcon == null) {
            return null;
        }
        if (imageIcon.getImage() instanceof BufferedImage) {
            bufferedImage2 = (BufferedImage)imageIcon.getImage();
            bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), bufferedImage2.getType());
        } else {
            bufferedImage = bufferedImage2 = ImageUtils.toType((Image)imageIcon.getImage(), (int)6);
        }
        IconUtil.darkenLightenImage(bufferedImage2, bufferedImage, f);
        return new ImageIcon(bufferedImage);
    }

    private static void darkenLightenImage(BufferedImage bufferedImage, BufferedImage bufferedImage2, float f) {
        int[] nArray = bufferedImage.getRaster().getPixels(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), (int[])null);
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = (int)((float)nArray[n] * f) & 0xFF;
            nArray[n + 1] = (int)((float)nArray[n + 1] * f) & 0xFF;
            nArray[n + 2] = (int)((float)nArray[n + 2] * f) & 0xFF;
            n += 4;
        }
        bufferedImage2.getRaster().setPixels(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), nArray);
    }

    public static enum IconInfo {
        WARNING_SMALL("icon.warning.small"),
        SYNC("icon.sync"),
        SYNC_TO_IA("icon.syncToIA"),
        SYNC_FROM_IA("icon.syncFromIA");

        private final String key;

        private IconInfo(String string2) {
            this.key = string2;
        }

        public String getKey() {
            return this.key;
        }
    }

    private static class ImageGraphics {
        public final Graphics2D graphics;
        public final Image image;

        ImageGraphics(Graphics2D graphics2D, Image image) {
            this.graphics = graphics2D;
            this.image = image;
        }
    }
}

