/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.icon;

import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.listtext.swingx.icon.PIconRequest;
import com.agfa.pacs.listtext.swingx.icon.PIconRequestQueue;
import com.agfa.pacs.listtext.swingx.icon.impl.AbstractPIcon;
import com.agfa.pacs.listtext.swingx.icon.impl.PBitmapIcon;
import com.agfa.pacs.listtext.swingx.icon.impl.PIconFile;
import com.agfa.pacs.listtext.swingx.icon.impl.PIconURL;
import com.agfa.pacs.listtext.swingx.icon.impl.PIconXmlDefinition;
import com.agfa.pacs.listtext.swingx.icon.impl.PVectorIcon;
import com.agfa.pacs.logging.ALogger;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class PIconLoader {
    public static final String DEFAULT_ICON_PATH = "/icons/";
    private static final PIconLoader INSTANCE = new PIconLoader();
    private static final String SVG_EXTENSION = ".svg";
    private static final String MONOCHROME_SUFFIX = "_bw";
    private static final ALogger log = ALogger.getLogger(PIconLoader.class);
    private final PIconRequestQueue queue = new PIconRequestQueue();

    private PIconLoader() {
        this.startIconLoadingThreads(1);
    }

    public static PIconLoader getInstance() {
        return INSTANCE;
    }

    public static String updatePath(String string) {
        if (string != null && !string.startsWith("/")) {
            string = DEFAULT_ICON_PATH + string;
        }
        return string;
    }

    public void priorize(PIcon pIcon) {
        this.queue.priorize(pIcon);
    }

    PIcon loadSvgIconFromXml(String string, String string2, int ... nArray) {
        PVectorIcon pVectorIcon = new PVectorIcon(string);
        this.queue.add(pVectorIcon, new PIconXmlDefinition(string, string2, nArray));
        return pVectorIcon;
    }

    public PIcon loadIconFromFileSynchronously(File file, int ... nArray) throws IOException {
        PIcon pIcon = this.createPIcon(file.getAbsolutePath(), file.getName());
        pIcon.load(new PIconFile(file, nArray));
        return pIcon;
    }

    PIcon loadIcon(ClassLoader classLoader, String string, boolean bl, int ... nArray) {
        String string2 = PIconLoader.updatePath(string);
        return this.loadUncachedIcon(classLoader, string2, bl, nArray);
    }

    private PIcon loadUncachedIcon(ClassLoader classLoader, String string, boolean bl, int ... nArray) {
        URL uRL = PIconLoader.getIconURL(classLoader, string, bl);
        if (uRL == null) {
            return null;
        }
        PIcon pIcon = this.createPIcon(string, string);
        this.queue.add(pIcon, new PIconURL(uRL, nArray));
        return pIcon;
    }

    private PIcon createPIcon(String string, String string2) {
        AbstractPIcon abstractPIcon = string.endsWith(SVG_EXTENSION) ? new PVectorIcon(string2) : new PBitmapIcon(string2);
        return abstractPIcon;
    }

    private static URL getIconURL(ClassLoader classLoader, String string, boolean bl) {
        int n;
        if (classLoader == null || string == null) {
            return null;
        }
        URL uRL = null;
        if (bl && (n = string.lastIndexOf(46)) > 0) {
            String string2 = String.valueOf(string.substring(0, n)) + MONOCHROME_SUFFIX + string.substring(n);
            uRL = classLoader.getResource(string2);
        }
        if (uRL == null) {
            uRL = classLoader.getResource(string);
        }
        if (uRL == null) {
            log.warn("Resolving URL for icon loading failed: " + string);
        }
        return uRL;
    }

    private void startIconLoadingThreads(int n) {
        int n2 = 0;
        while (n2 < n) {
            new PIconLoadingThread(n2).start();
            ++n2;
        }
    }

    private class PIconLoadingThread
    extends Thread {
        PIconLoadingThread(int n) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("IconLoadingThread-");
            stringBuilder.append(n);
            this.setName(stringBuilder.toString());
            this.setDaemon(true);
            this.setPriority(1);
        }

        @Override
        public void run() {
            PIconRequest pIconRequest = null;
            while (true) {
                try {
                    while (true) {
                        pIconRequest = PIconLoader.this.queue.take();
                        pIconRequest.process();
                    }
                }
                catch (Throwable throwable) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Error while processing icon request");
                    if (pIconRequest != null) {
                        stringBuilder.append(" for '");
                        stringBuilder.append(pIconRequest);
                        stringBuilder.append('\'');
                    }
                    stringBuilder.append('.');
                    log.error(stringBuilder.toString(), throwable);
                    continue;
                }
                break;
            }
        }
    }
}

