/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.icon;

import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.listtext.swingx.icon.PIconRequest;
import com.agfa.pacs.listtext.swingx.icon.PIconSource;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;

class PIconRequestQueue {
    private final BlockingDeque<PIcon> queue = new LinkedBlockingDeque<PIcon>();
    private final Map<PIcon, PIconSource> iconSources = new ConcurrentHashMap<PIcon, PIconSource>();

    PIconRequestQueue() {
    }

    void add(PIcon pIcon, PIconSource pIconSource) {
        this.iconSources.put(pIcon, pIconSource);
        this.queue.addLast(pIcon);
    }

    void priorize(PIcon pIcon) {
        if (this.queue.remove(pIcon)) {
            this.queue.addFirst(pIcon);
        }
    }

    PIconRequest take() {
        while (true) {
            try {
                PIcon pIcon = this.queue.take();
                return new PIconRequest(pIcon, this.iconSources.get(pIcon));
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

