/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.impl;

import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.listtext.swingx.icon.PIconFactory;
import com.agfa.pacs.logging.ALogger;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class BackgroundFader {
    private static final ALogger LOGGER = ALogger.getLogger(BackgroundFader.class);
    private static final PIcon BACKGROUND_IMAGE = BackgroundFader.loadBackgroundImage();
    private static final int DEFAULT_BACKGROUND_IMAGE_HEIGHT = 100;
    private final Component parent;
    private final Component[] additionalFadingComponents;
    private ImageIcon backgroundImage;
    private float alpha;
    private int xCoordinate;
    private int yCoordinate;

    public BackgroundFader(Component component, Component ... componentArray) {
        this.parent = component;
        this.additionalFadingComponents = BackgroundFader.filterNullValue(componentArray);
        this.updateAdditionalFadingComponents();
    }

    private static Component[] filterNullValue(Component ... componentArray) {
        if (componentArray == null) {
            return new Component[0];
        }
        return (Component[])Arrays.stream(componentArray).filter(Objects::nonNull).toArray(Component[]::new);
    }

    public void paintBackground(Graphics graphics) {
        ImageIcon imageIcon;
        if (this.alpha > 0.0f && (imageIcon = this.getBackgroundImage()) != null && graphics instanceof Graphics2D) {
            this.paintBackground((Graphics2D)graphics, imageIcon);
        }
    }

    private void paintBackground(Graphics2D graphics2D, ImageIcon imageIcon) {
        Composite composite = graphics2D.getComposite();
        try {
            try {
                graphics2D.setComposite(AlphaComposite.getInstance(3, this.alpha));
                graphics2D.drawImage(imageIcon.getImage(), this.xCoordinate, this.yCoordinate, null);
            }
            catch (RuntimeException runtimeException) {
                LOGGER.debug("Painting background failed", (Throwable)runtimeException);
                graphics2D.setComposite(composite);
            }
        }
        finally {
            graphics2D.setComposite(composite);
        }
    }

    private ImageIcon getBackgroundImage() {
        if (this.backgroundImage == null) {
            this.backgroundImage = this.scaleBackgroundImage(100);
        }
        return this.backgroundImage;
    }

    private ImageIcon scaleBackgroundImage(int n) {
        try {
            if (BACKGROUND_IMAGE != null) {
                return BACKGROUND_IMAGE.scaleToHeight(n);
            }
        }
        catch (RuntimeException runtimeException) {
            LOGGER.debug("Scaling background image failed", (Throwable)runtimeException);
        }
        return null;
    }

    private static PIcon loadBackgroundImage() {
        try {
            return PIconFactory.createdFixedSizeIconFactory(false, 100).loadIcon(BackgroundFader.class, "/icons/background.png");
        }
        catch (RuntimeException runtimeException) {
            LOGGER.debug("Loading background image failed", (Throwable)runtimeException);
            return null;
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float f) {
        this.alpha = Math.min(Math.max(0.0f, f), 1.0f);
        this.updateAdditionalFadingComponents();
        this.parent.repaint();
    }

    private void updateAdditionalFadingComponents() {
        Component[] componentArray = this.additionalFadingComponents;
        int n = this.additionalFadingComponents.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            component.setForeground(this.derive(component.getForeground()));
            component.repaint();
            ++n2;
        }
    }

    private Color derive(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(this.alpha * 255.0f));
    }

    public void setBackgroundImageHeight(int n) {
        this.backgroundImage = this.scaleBackgroundImage(n);
    }

    public void setBackgroundImageLocation(int n, int n2, int n3, int n4) {
        ImageIcon imageIcon = this.getBackgroundImage();
        if (imageIcon != null) {
            this.xCoordinate = this.getXCoordinate(n, n3, imageIcon);
            this.yCoordinate = this.getYCoordinate(n2, n4, imageIcon);
        }
    }

    private int getXCoordinate(int n, int n2, Icon icon) {
        switch (n2) {
            case 2: {
                return n;
            }
            case 4: {
                return n - icon.getIconWidth();
            }
        }
        return n - icon.getIconWidth() / 2;
    }

    private int getYCoordinate(int n, int n2, Icon icon) {
        switch (n2) {
            case 1: {
                return n;
            }
            case 3: {
                return n - icon.getIconHeight();
            }
        }
        return n - icon.getIconHeight() / 2;
    }
}

