/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.impl;

import com.agfa.pacs.base.swing.busylabel.JXBusyLabel;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.listtext.swingx.controls.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class BusyLayeredPane
extends JPanel {
    private final JLayeredPane layeredPane = new JLayeredPane();
    private final EnumMap<State, JComponent> layers = new EnumMap(State.class);
    private final JXBusyLabel busyLabel;

    public BusyLayeredPane(JComponent jComponent) {
        this(jComponent, Messages.getString("BusyLayeredPane.Empty.Text"), Messages.getString("BusyLayeredPane.Busy.Text"));
    }

    public BusyLayeredPane(JComponent jComponent, String string) {
        this(jComponent, Messages.getString("BusyLayeredPane.Empty.Text"), string);
    }

    public BusyLayeredPane(JComponent jComponent, String string, String string2) {
        this(jComponent, BusyLayeredPane.createLayer(string), string2);
    }

    public BusyLayeredPane(JComponent jComponent, JComponent jComponent2, String string) {
        super(new BorderLayout());
        this.layers.put(State.DATA, jComponent);
        this.layers.put(State.EMPTY, jComponent2);
        this.layers.put(State.BUSY, new JPanel(new BorderLayout()));
        this.busyLabel = new JXBusyLabel();
        this.initLayeredPane(string);
    }

    private static JComponent createLayer(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalAlignment(0);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "Center");
        return jPanel;
    }

    private void initLayeredPane(String string) {
        this.busyLabel.setText(string);
        this.busyLabel.setHorizontalAlignment(0);
        this.layers.get((Object)State.BUSY).add((Component)this.busyLabel, "Center");
        LayeredPaneListener layeredPaneListener = new LayeredPaneListener();
        this.layeredPane.addComponentListener(layeredPaneListener);
        this.addHierarchyListener(layeredPaneListener);
        for (Map.Entry<State, JComponent> object : this.layers.entrySet()) {
            this.layeredPane.setLayer(object.getValue(), object.getKey().ordinal());
        }
        for (JComponent jComponent : this.layers.values()) {
            this.layeredPane.add(jComponent);
        }
        for (Map.Entry entry : this.layers.entrySet()) {
            ((JComponent)entry.getValue()).setVisible(entry.getKey() == State.EMPTY);
        }
        this.add((Component)this.layeredPane, "Center");
    }

    @Override
    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        if (this.layers != null) {
            for (JComponent jComponent : this.layers.values()) {
                jComponent.setOpaque(bl);
            }
        }
    }

    public void setState(State state) {
        EventUtil.invoke(() -> {
            this.switchToState(state);
            this.revalidate();
            this.repaint();
        });
    }

    void switchToState(State state) {
        this.busyLabel.setBusy(state == State.BUSY);
        for (Map.Entry<State, JComponent> entry : this.layers.entrySet()) {
            entry.getValue().setVisible(entry.getKey() == state);
        }
    }

    private class LayeredPaneListener
    extends ComponentAdapter
    implements HierarchyListener {
        private LayeredPaneListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (componentEvent.getComponent() == BusyLayeredPane.this.layeredPane) {
                Dimension dimension = componentEvent.getComponent().getSize();
                for (JComponent jComponent : BusyLayeredPane.this.layers.values()) {
                    jComponent.setSize(dimension);
                }
                BusyLayeredPane.this.layeredPane.revalidate();
                BusyLayeredPane.this.layeredPane.repaint();
            }
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if (hierarchyEvent.getID() == 1400 && (hierarchyEvent.getChangeFlags() & 1L) != 0L && BusyLayeredPane.this.getParent() == null) {
                BusyLayeredPane.this.layeredPane.setSize(0, 0);
            }
        }
    }

    public static enum State {
        DATA,
        EMPTY,
        BUSY;

    }
}

