/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.impl;

import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.swingx.controls.Messages;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.swing.JLabel;

public class StudyListComponent
extends JLabel {
    public StudyListComponent(SortedMap<String, List<IStudyInfo>> sortedMap) {
        super(StudyListComponent.createStudiesList(sortedMap));
    }

    public StudyListComponent(List<IStudyInfo> list) {
        super(StudyListComponent.createStudiesList(list));
    }

    private static String createStudiesList(SortedMap<String, List<IStudyInfo>> sortedMap) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<ul>");
        for (Map.Entry<String, List<IStudyInfo>> entry : sortedMap.entrySet()) {
            stringBuilder.append("<li>");
            stringBuilder.append(entry.getKey());
            StudyListComponent.appendStudies(stringBuilder, entry.getValue());
            stringBuilder.append("</li>");
        }
        stringBuilder.append("</ul>");
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private static String createStudiesList(List<IStudyInfo> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        StudyListComponent.appendStudies(stringBuilder, list);
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private static void appendStudies(StringBuilder stringBuilder, List<IStudyInfo> list) {
        stringBuilder.append("<ul>");
        for (IStudyInfo iStudyInfo : list) {
            stringBuilder.append("<li>");
            stringBuilder.append('\'');
            stringBuilder.append(iStudyInfo.getAttributes().getString(528432));
            stringBuilder.append('\'');
            Date date = iStudyInfo.getDate(524320);
            if (date != null) {
                stringBuilder.append(' ');
                stringBuilder.append(Messages.getString("StudyListComponent.from"));
                stringBuilder.append(' ');
                stringBuilder.append(DateTimeUtils.date2String((Date)date));
            }
            stringBuilder.append("</li>");
        }
        stringBuilder.append("</ul>");
    }
}

