/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class FlowLayout2
implements LayoutManager2 {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int orientation;
    private int gap;
    private List<ComponentConstraintPair> comps = null;

    public FlowLayout2() {
        this(0, 0);
    }

    public FlowLayout2(int n, int n2) {
        this.setOrientation(n);
        this.gap = n2;
        this.comps = new Vector<ComponentConstraintPair>();
    }

    public void setGap(int n) {
        this.gap = n;
    }

    public int getGap() {
        return this.gap;
    }

    public void setOrientation(int n) throws IllegalArgumentException {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Orientation must be either FlowLayout2.HORIZONTAL or FlowLayout2.VERTICAL");
        }
        this.orientation = n;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public List<Component> getComponents() {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (ComponentConstraintPair componentConstraintPair : this.comps) {
            arrayList.add(componentConstraintPair.component);
        }
        return arrayList;
    }

    public Constraint getConstraint(Component component) {
        for (ComponentConstraintPair componentConstraintPair : this.comps) {
            if (componentConstraintPair.component != component) continue;
            return componentConstraintPair.constraint;
        }
        return null;
    }

    public void setConstraint(Component component, Object object) {
        if (component == null) {
            return;
        }
        if (object == null) {
            object = new PreferredSizeConstraint();
        } else if (!(object instanceof Constraint)) {
            throw new IllegalArgumentException("Invalid Constraint");
        }
        boolean bl = false;
        for (ComponentConstraintPair componentConstraintPair : this.comps) {
            if (componentConstraintPair.component != component) continue;
            componentConstraintPair.constraint = (Constraint)object;
            bl = true;
            break;
        }
        if (!bl) {
            this.comps.add(new ComponentConstraintPair(component, (Constraint)object));
        }
    }

    public int getComponentIndex(Component component) {
        ComponentConstraintPair componentConstraintPair = this.getComponentConstraintPair(component);
        if (componentConstraintPair != null) {
            return this.comps.indexOf(componentConstraintPair);
        }
        return -1;
    }

    public void moveComponent(Component component, int n) {
        int n2 = this.getComponentIndex(component);
        if (n2 < 0 || n2 >= this.comps.size()) {
            return;
        }
        if (n < 0 || n >= this.comps.size()) {
            return;
        }
        if (n2 == n) {
            return;
        }
        ComponentConstraintPair componentConstraintPair = this.comps.get(n2);
        this.comps.remove(n2);
        this.comps.add(n, componentConstraintPair);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        this.setConstraint(component, object);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        if (component == null) {
            return;
        }
        for (ComponentConstraintPair componentConstraintPair : this.comps) {
            if (componentConstraintPair.component != component) continue;
            this.comps.remove(componentConstraintPair);
            break;
        }
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        int n = 0;
        int n2 = this.orientation == 0 ? insets.left : insets.top;
        int n3 = this.orientation == 0 ? dimension.width : dimension.height;
        int n4 = this.computeMaximizedComponentSize(container);
        Dimension dimension2 = null;
        Dimension dimension3 = null;
        for (ComponentConstraintPair componentConstraintPair : this.comps) {
            if (!componentConstraintPair.component.isVisible()) continue;
            dimension2 = componentConstraintPair.component.getMinimumSize();
            dimension3 = componentConstraintPair.component.getPreferredSize();
            if (this.orientation == 0) {
                if (componentConstraintPair.constraint instanceof MinimizedSizeConstraint) {
                    n = componentConstraintPair.component.getMinimumSize().width;
                    componentConstraintPair.component.setBounds(n2, insets.top, n, dimension.height);
                } else if (componentConstraintPair.constraint instanceof PreferredSizeConstraint) {
                    n = Math.max(dimension2.width, Math.min(n3, dimension3.width));
                    componentConstraintPair.component.setBounds(n2, insets.top, n, dimension.height);
                } else if (componentConstraintPair.constraint instanceof SizeConstraint) {
                    n = Math.max(dimension2.width, Math.min(n3, ((SizeConstraint)componentConstraintPair.constraint).size));
                    componentConstraintPair.component.setBounds(n2, insets.top, n, dimension.height);
                } else if (componentConstraintPair.constraint instanceof MaximizedSizeConstraint) {
                    n = Math.max(dimension2.width, Math.min(n3, n4));
                    componentConstraintPair.component.setBounds(n2, insets.top, n, dimension.height);
                }
            } else {
                if (componentConstraintPair.constraint instanceof MinimizedSizeConstraint) {
                    n = componentConstraintPair.component.getMinimumSize().height;
                    componentConstraintPair.component.setBounds(insets.left, n2, dimension.width, n);
                }
                if (componentConstraintPair.constraint instanceof PreferredSizeConstraint) {
                    n = Math.max(dimension2.height, Math.min(n3, dimension3.height));
                    componentConstraintPair.component.setBounds(insets.left, n2, dimension.width, n);
                } else if (componentConstraintPair.constraint instanceof SizeConstraint) {
                    n = Math.max(dimension2.height, Math.min(n3, ((SizeConstraint)componentConstraintPair.constraint).size));
                    componentConstraintPair.component.setBounds(insets.left, n2, dimension.width, n);
                } else if (componentConstraintPair.constraint instanceof MaximizedSizeConstraint) {
                    n = Math.max(dimension2.height, Math.min(n3, n4));
                    componentConstraintPair.component.setBounds(insets.left, n2, dimension.width, n);
                }
            }
            n2 += n + this.gap;
            n3 -= n + this.gap;
        }
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension();
        int n = 0;
        for (ComponentConstraintPair object2 : this.comps) {
            if (!object2.component.isVisible()) continue;
            Dimension dimension2 = object2.component.getMinimumSize();
            if (this.orientation == 0) {
                dimension.width += dimension2.width;
                dimension.height = Math.max(dimension.height, dimension2.height);
            } else {
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height += object2.component.getMinimumSize().height;
            }
            ++n;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        if (n > 0) {
            if (this.orientation == 0) {
                dimension.width += this.gap * (n - 1);
            } else {
                dimension.height += this.gap * (n - 1);
            }
        }
        return dimension;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension();
        Dimension dimension2 = null;
        Dimension dimension3 = null;
        int n = 0;
        for (ComponentConstraintPair object2 : this.comps) {
            if (!object2.component.isVisible()) continue;
            dimension2 = object2.component.getMinimumSize();
            dimension3 = object2.component.getPreferredSize();
            if (this.orientation == 0) {
                if (object2.constraint instanceof MinimizedSizeConstraint) {
                    dimension.width += dimension2.width;
                } else if (object2.constraint instanceof PreferredSizeConstraint) {
                    dimension.width += Math.max(dimension2.width, dimension3.width);
                } else if (object2.constraint instanceof SizeConstraint) {
                    dimension.width += Math.max(dimension2.width, ((SizeConstraint)object2.constraint).size);
                } else if (object2.constraint instanceof MaximizedSizeConstraint) {
                    dimension.width += Math.max(dimension2.width, dimension3.width);
                }
                dimension.height = Math.max(dimension.height, dimension3.height);
            } else if (this.orientation == 1) {
                if (object2.constraint instanceof MinimizedSizeConstraint) {
                    dimension.height += dimension2.height;
                } else if (object2.constraint instanceof PreferredSizeConstraint) {
                    dimension.height += Math.max(dimension2.height, dimension3.height);
                } else if (object2.constraint instanceof SizeConstraint) {
                    dimension.height += Math.max(dimension2.height, ((SizeConstraint)object2.constraint).size);
                } else if (object2.constraint instanceof MaximizedSizeConstraint) {
                    dimension.height += Math.max(dimension2.height, dimension3.height);
                }
                dimension.width = Math.max(dimension.width, dimension3.width);
            }
            ++n;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        if (n > 0) {
            if (this.orientation == 0) {
                dimension.width += this.gap * (n - 1);
            } else {
                dimension.height += this.gap * (n - 1);
            }
        }
        return dimension;
    }

    private ComponentConstraintPair getComponentConstraintPair(Component component) {
        for (ComponentConstraintPair componentConstraintPair : this.comps) {
            if (componentConstraintPair.component != component) continue;
            return componentConstraintPair;
        }
        return null;
    }

    public int getLayoutComponentSize(Container container, Component component) {
        ComponentConstraintPair componentConstraintPair = this.getComponentConstraintPair(component);
        if (componentConstraintPair != null) {
            if (!component.isVisible()) {
                return 0;
            }
            Dimension dimension = component.getMinimumSize();
            Dimension dimension2 = component.getPreferredSize();
            if (this.orientation == 0) {
                if (componentConstraintPair.constraint instanceof MinimizedSizeConstraint) {
                    return dimension.width;
                }
                if (componentConstraintPair.constraint instanceof PreferredSizeConstraint) {
                    return Math.max(dimension.width, dimension2.width);
                }
                if (componentConstraintPair.constraint instanceof SizeConstraint) {
                    return Math.max(dimension.width, ((SizeConstraint)componentConstraintPair.constraint).size);
                }
                if (componentConstraintPair.constraint instanceof MaximizedSizeConstraint) {
                    return Math.max(dimension.width, this.computeMaximizedComponentSize(container));
                }
            } else {
                if (componentConstraintPair.constraint instanceof MinimizedSizeConstraint) {
                    return dimension.height;
                }
                if (componentConstraintPair.constraint instanceof PreferredSizeConstraint) {
                    return Math.max(dimension.height, dimension2.height);
                }
                if (componentConstraintPair.constraint instanceof SizeConstraint) {
                    return Math.max(dimension.height, ((SizeConstraint)componentConstraintPair.constraint).size);
                }
                if (componentConstraintPair.constraint instanceof MaximizedSizeConstraint) {
                    return Math.max(dimension.height, this.computeMaximizedComponentSize(container));
                }
            }
        }
        return 0;
    }

    private int computeKnownSize(Container container, boolean bl) {
        Insets insets = container.getInsets();
        int n = this.orientation == 0 ? insets.left + insets.right : insets.top + insets.bottom;
        Dimension dimension = null;
        Dimension dimension2 = null;
        int n2 = 0;
        for (ComponentConstraintPair componentConstraintPair : this.comps) {
            if (!componentConstraintPair.component.isVisible()) continue;
            dimension = componentConstraintPair.component.getMinimumSize();
            dimension2 = componentConstraintPair.component.getPreferredSize();
            if (this.orientation == 0) {
                if (componentConstraintPair.constraint instanceof MinimizedSizeConstraint) {
                    n += dimension.width;
                } else if (componentConstraintPair.constraint instanceof PreferredSizeConstraint) {
                    n += Math.max(dimension.width, dimension2.width);
                } else if (componentConstraintPair.constraint instanceof SizeConstraint) {
                    n += Math.max(dimension.width, ((SizeConstraint)componentConstraintPair.constraint).size);
                } else if (componentConstraintPair.constraint instanceof MaximizedSizeConstraint) {
                    if (bl) {
                        n += dimension.width;
                    } else {
                        --n2;
                    }
                }
            } else if (componentConstraintPair.constraint instanceof MinimizedSizeConstraint) {
                n += dimension.height;
            } else if (componentConstraintPair.constraint instanceof PreferredSizeConstraint) {
                n += Math.max(dimension.height, dimension2.height);
            } else if (componentConstraintPair.constraint instanceof SizeConstraint) {
                n += Math.max(dimension.height, ((SizeConstraint)componentConstraintPair.constraint).size);
            } else if (componentConstraintPair.constraint instanceof MaximizedSizeConstraint) {
                if (bl) {
                    n += dimension.height;
                } else {
                    --n2;
                }
            }
            ++n2;
        }
        if (n2 > 0) {
            n += this.gap * (n2 - 1);
        }
        return n;
    }

    private int computeMaximizedComponentSize(Container container) {
        int n;
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        int n2 = this.computeKnownSize(container, false);
        int n3 = this.orientation == 0 ? dimension.width - n2 : dimension.height - n2;
        int n4 = this.getMaximizedComponents().size();
        int n5 = n = this.comps.size() > 0 ? 1 : 0;
        if (n4 > 0) {
            int n6 = (n4 - 1 + n) * this.gap;
            return (n3 - n6) / n4;
        }
        return n3;
    }

    private List<ComponentConstraintPair> getMaximizedComponents() {
        Vector<ComponentConstraintPair> vector = new Vector<ComponentConstraintPair>();
        for (ComponentConstraintPair componentConstraintPair : this.comps) {
            if (!componentConstraintPair.component.isVisible() || !(componentConstraintPair.constraint instanceof MaximizedSizeConstraint)) continue;
            vector.addElement(componentConstraintPair);
        }
        return vector;
    }

    private static class ComponentConstraintPair {
        public Component component = null;
        public Constraint constraint = null;

        public ComponentConstraintPair(Component component, Constraint constraint) {
            this.component = component;
            this.constraint = constraint;
        }
    }

    public abstract class Constraint {
    }

    public class MaximizedSizeConstraint
    extends Constraint {
    }

    public class MinimizedSizeConstraint
    extends Constraint {
    }

    public class PreferredSizeConstraint
    extends Constraint {
    }

    public class SizeConstraint
    extends Constraint {
        public int size = 0;

        public SizeConstraint(int n) {
            this.size = n;
        }
    }
}

