/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class RowLayout
implements LayoutManager {
    private int vgap = 10;
    private boolean stretch = false;

    public RowLayout(int n, boolean bl) {
        this.vgap = n >= 0 ? n : 0;
        this.stretch = bl;
    }

    public RowLayout(int n) {
        this(n, false);
    }

    public RowLayout() {
        this(10);
    }

    public boolean isStretchingEnabled() {
        return this.stretch;
    }

    public void setStretchingEnabled(boolean bl) {
        this.stretch = bl;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        int n3 = n;
        int n4 = n2;
        if (!this.stretch) {
            Component[] componentArray = container.getComponents();
            int n5 = componentArray.length;
            int n6 = 0;
            while (n6 < n5) {
                Component component = componentArray[n6];
                if (component.isVisible()) {
                    Dimension dimension = component.getMinimumSize();
                    n3 = (int)Math.max((double)n3, dimension.getWidth() + (double)n);
                    n4 = (int)((double)n4 + (dimension.getHeight() + (double)this.vgap));
                }
                ++n6;
            }
        }
        return new Dimension(n3, n4);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        int n3 = n;
        int n4 = n2;
        if (!this.stretch) {
            Component[] componentArray = container.getComponents();
            int n5 = componentArray.length;
            int n6 = 0;
            while (n6 < n5) {
                Component component = componentArray[n6];
                if (component.isVisible()) {
                    Dimension dimension = component.getPreferredSize();
                    n3 = Math.max(n3, dimension.width + n);
                    n4 = (int)((double)n4 + (dimension.getHeight() + (double)this.vgap));
                }
                ++n6;
            }
        } else {
            n3 += container.getPreferredSize().width;
            n4 += container.getPreferredSize().height;
        }
        return new Dimension(n3, n4);
    }

    @Override
    public void layoutContainer(Container container) {
        block7: {
            Component[] componentArray;
            int n;
            int n2;
            int n3;
            int n4;
            block6: {
                Insets insets = container.getInsets();
                n4 = insets.left;
                n3 = insets.top;
                n2 = container.getWidth() - insets.left - insets.right;
                n = container.getHeight() - insets.top - insets.bottom;
                componentArray = container.getComponents();
                if (this.stretch) break block6;
                Component[] componentArray2 = componentArray;
                int n5 = componentArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    Component component = componentArray2[n6];
                    if (component.isVisible()) {
                        Dimension dimension = component.getPreferredSize();
                        component.setBounds(n4, n3, n2, dimension.height);
                        n3 += dimension.height + this.vgap;
                    }
                    ++n6;
                }
                break block7;
            }
            int n7 = 0;
            Component[] componentArray3 = componentArray;
            int n8 = componentArray.length;
            int n9 = 0;
            while (n9 < n8) {
                Component component = componentArray3[n9];
                if (component.isVisible()) {
                    ++n7;
                }
                ++n9;
            }
            if (n7 <= 0) break block7;
            int n10 = (n - (n7 - 1) * this.vgap) / n7;
            Component[] componentArray4 = componentArray;
            int n11 = componentArray.length;
            n8 = 0;
            while (n8 < n11) {
                Component component = componentArray4[n8];
                if (component.isVisible()) {
                    component.setBounds(n4, n3, n2, n10);
                    n3 += n10 + this.vgap;
                }
                ++n8;
            }
        }
    }
}

