/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.plaf;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.listtext.swingx.plaf.NiceTheme;
import com.agfa.pacs.listtext.swingx.plaf.Skin;
import com.agfa.pacs.listtext.swingx.plaf.synth.NiceLookAndFeel;
import com.agfa.pacs.logging.ALogger;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import javax.swing.UIManager;

public class LookAndFeelManager {
    private static final ALogger log = ALogger.getLogger(LookAndFeelManager.class);
    private static LookAndFeelManager instance;
    private NiceTheme theme;

    private LookAndFeelManager() {
    }

    public static synchronized LookAndFeelManager getInstance() {
        if (instance == null) {
            instance = new LookAndFeelManager();
        }
        return instance;
    }

    NiceTheme getTheme() {
        return this.theme;
    }

    boolean isLightTheme() {
        return instance.getTheme().getSkin() == Skin.LIGHT;
    }

    public boolean isMonochromeLookAndFeel() {
        return this.theme.isMonochrome();
    }

    public synchronized void initLookAndFeel() {
        NiceTheme niceTheme = NiceTheme.readThemeFromConfig();
        if (ConfigurationProviderFactory.getConfig().getBoolean("impaxee.workstation.MONITORS.Monochrome") || this.isMonochromeMonitorInUse()) {
            niceTheme = niceTheme.getSkin() == Skin.DARK ? NiceTheme.NICE_GREY_DARK : NiceTheme.NICE_GREY_LIGHT;
            log.info("Set GREY THEME because the option to use monochrome monitors is enabled or at least one monochrome monitor is used.");
        }
        this.initLookAndFeel(niceTheme);
    }

    public synchronized void initLookAndFeel(NiceTheme niceTheme) {
        try {
            if (EventQueue.isDispatchThread()) {
                this.initLookAndFeelImpl(niceTheme);
            } else {
                EventQueue.invokeAndWait(() -> this.initLookAndFeelImpl(niceTheme));
            }
        }
        catch (Exception exception) {
            log.error("Initializing Swing LookAndFeel failed", (Throwable)exception);
        }
    }

    private void initLookAndFeelImpl(NiceTheme niceTheme) {
        try {
            NiceLookAndFeel niceLookAndFeel = new NiceLookAndFeel();
            niceLookAndFeel.load(LookAndFeelManager.class.getResource(niceTheme.getSynthXMLPath()));
            UIManager.setLookAndFeel(niceLookAndFeel);
            this.theme = niceTheme;
        }
        catch (Exception exception) {
            log.error("Initializing Swing LookAndFeel failed", (Throwable)exception);
        }
    }

    private boolean isMonochromeMonitorInUse() {
        if (Product.isHeadless()) {
            return false;
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        if (graphicsDeviceArray != null) {
            int n = 0;
            while (n < graphicsDeviceArray.length) {
                if (!GUI.isOnColorMonitor((GraphicsConfiguration)graphicsDeviceArray[n].getDefaultConfiguration())) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }
}

