/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.plaf;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.listtext.swingx.controls.Messages;
import com.agfa.pacs.listtext.swingx.plaf.LookAndFeelManager;
import com.agfa.pacs.listtext.swingx.plaf.Skin;
import com.agfa.pacs.listtext.swingx.plaf.WorklistSkin;

public enum NiceTheme {
    NICE_BLUE_DARK(0, "blue.dark", "/nice/NiceBlue.xml", false, Skin.DARK, WorklistSkin.DARK),
    NICE_BLUE_LIGHT(1, "blue.light", "/nice/NiceBlue.xml", false, Skin.LIGHT, WorklistSkin.LIGHT),
    NICE_GREY_DARK(3, "grey", "/nice/NiceGrey.xml", true, Skin.DARK, WorklistSkin.DARK),
    NICE_GREY_LIGHT(4, "grey", "/nice/NiceGrey.xml", true, Skin.LIGHT, WorklistSkin.LIGHT);

    private static final String LAF_CONFIG_KEY = "listtext.lta.ui.laf";
    private final String name;
    private final int configId;
    private final String synthXMLPath;
    private final boolean isMonochrome;
    private final Skin skin;
    private final WorklistSkin.IWorklistSkin worklistSkin;

    private NiceTheme(int n2, String string2, String string3, boolean bl, Skin skin, WorklistSkin.IWorklistSkin iWorklistSkin) {
        this.configId = n2;
        this.name = string2;
        this.synthXMLPath = string3;
        this.isMonochrome = bl;
        this.skin = skin;
        this.worklistSkin = iWorklistSkin;
    }

    public static synchronized NiceTheme get() {
        return LookAndFeelManager.getInstance().getTheme();
    }

    static NiceTheme readThemeFromConfig() {
        NiceTheme niceTheme = null;
        if (ConfigurationProviderFactory.getConfig().exists(LAF_CONFIG_KEY)) {
            niceTheme = NiceTheme.valueOf((int)ConfigurationProviderFactory.getConfig().getLong(LAF_CONFIG_KEY));
        }
        if (niceTheme == null) {
            niceTheme = NICE_BLUE_DARK;
        }
        return niceTheme;
    }

    public static String[] stringValues() {
        NiceTheme[] niceThemeArray = NiceTheme.values();
        String[] stringArray = new String[niceThemeArray.length];
        int n = 0;
        while (n < niceThemeArray.length) {
            stringArray[n] = niceThemeArray[n].toString();
            ++n;
        }
        return stringArray;
    }

    public String getName() {
        return this.name;
    }

    public int getConfigId() {
        return this.configId;
    }

    public String getSynthXMLPath() {
        return this.synthXMLPath;
    }

    public boolean isMonochrome() {
        return this.isMonochrome;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public WorklistSkin.IWorklistSkin getWorklistSkin() {
        return this.worklistSkin;
    }

    public String toString() {
        return Messages.getString("NiceTheme." + this.name());
    }

    public static NiceTheme valueOf(String string) {
        return Enum.valueOf(NiceTheme.class, string);
    }
}

