/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.plaf;

import com.agfa.pacs.listtext.swingx.icon.LTAIconUtils;
import com.agfa.pacs.listtext.swingx.plaf.LookAndFeelManager;
import com.agfa.pacs.listtext.swingx.util.graphics.ColorUtils;
import com.agfa.pacs.listtext.swingx.util.graphics.FontUtils;
import java.awt.Color;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.UIManager;

public class WorklistSkin {
    public static final IWorklistSkin DARK = new DarkWorklistSkin();
    public static final IWorklistSkin LIGHT = new LightWorklistSkin();

    private static class DarkWorklistSkin
    implements IWorklistSkin {
        private DarkWorklistSkin() {
        }

        @Override
        public Icon getCollapsedIcon() {
            return LTAIconUtils.getPlusSquareIcon();
        }

        @Override
        public Icon getCollapsedRolloverIcon() {
            return LTAIconUtils.getPlusRolloverIcon();
        }

        @Override
        public Icon getExpandedIcon() {
            return LTAIconUtils.getMinusSquareIcon();
        }

        @Override
        public Icon getExpandedRolloverIcon() {
            return LTAIconUtils.getMinusRolloverIcon();
        }
    }

    public static interface IWorklistSkin {
        public static final /* synthetic */ int[] $SWITCH_TABLE$com$agfa$pacs$listtext$swingx$plaf$WorklistSkin$IWorklistSkin$Gender;

        default public Icon getCollapsedIcon() {
            return null;
        }

        default public Icon getCollapsedRolloverIcon() {
            return null;
        }

        default public Icon getExpandedIcon() {
            return null;
        }

        default public Icon getExpandedRolloverIcon() {
            return null;
        }

        default public Icon getSnapshotIcon() {
            return LTAIconUtils.getCameraIcon();
        }

        default public Icon getLinkedIcon() {
            return LTAIconUtils.getLinkedIcon();
        }

        default public Icon getGenderIcon(Gender gender) {
            switch (gender) {
                case MALE: {
                    return LTAIconUtils.getMaleBlueIcon();
                }
                case FEMALE: {
                    return LTAIconUtils.getFemaleBlueIcon();
                }
                case TRANSGENDER: {
                    return LTAIconUtils.getTransgenderBlueIcon();
                }
            }
            return LTAIconUtils.getGenderUnknownBlueIcon();
        }

        default public Color getLoadButtonBackground(boolean bl, boolean bl2) {
            if (bl2) {
                return ColorUtils.getPrimary3();
            }
            return ColorUtils.getSecondary1();
        }

        default public float getNonSelectionFontSize(RowStyle rowStyle, int n, int n2, int n3, boolean bl) {
            Font font = FontUtils.getAgfaFontDefault();
            if (font != null) {
                return font.getSize2D();
            }
            return 10.0f;
        }

        default public float getSelectionFontSize(RowStyle rowStyle, int n, int n2, int n3, boolean bl) {
            return this.getNonSelectionFontSize(rowStyle, n, n2, n3, bl);
        }

        default public int getNonSelectionFontStyle(RowStyle rowStyle, int n, int n2, int n3, boolean bl) {
            boolean bl2 = false;
            if (bl || n == 0) {
                bl2 = true;
            }
            return bl2 ? 1 : 0;
        }

        default public int getSelectionFontStyle(RowStyle rowStyle, int n, int n2, int n3, boolean bl) {
            return this.getNonSelectionFontStyle(rowStyle, n, n2, n3, bl);
        }

        default public Color getNonSelectionForegroundColor(RowStyle rowStyle, int n, int n2, int n3, boolean bl, boolean bl2) {
            if (bl) {
                return ColorUtils.ensureAWTColor(ColorUtils.getSecondary1());
            }
            switch (n) {
                case 0: {
                    return ColorUtils.ensureAWTColor(ColorUtils.getPrimary6());
                }
                case 1: {
                    return ColorUtils.ensureAWTColor(ColorUtils.getSecondary5());
                }
            }
            return ColorUtils.ensureAWTColor(ColorUtils.getSecondary5());
        }

        default public Color getSelectionForegroundColor(RowStyle rowStyle, int n, int n2, int n3, boolean bl, boolean bl2) {
            Color color = ColorUtils.getWhite();
            if (bl2 && n == 0) {
                color = ColorUtils.getPrimary8();
            }
            if (color == null) {
                color = UIManager.getColor("Table.selectionForeground");
            }
            return ColorUtils.ensureAWTColor(color);
        }

        default public Color getSelectionWarningForegroundColor(RowStyle rowStyle, int n, int n2, int n3, boolean bl, boolean bl2) {
            Color color = null;
            color = bl2 ? (bl ? ColorUtils.getError2() : ColorUtils.getWhite()) : this.getWarningColor(bl);
            return ColorUtils.ensureAWTColor(color);
        }

        default public Color getNonSelectionWarningForegroundColor(RowStyle rowStyle, int n, int n2, int n3, boolean bl, boolean bl2) {
            Color color = null;
            color = bl2 ? ColorUtils.getError2() : this.getWarningColor(bl);
            return ColorUtils.ensureAWTColor(color);
        }

        default public Color getWarningColor(boolean bl) {
            if (LookAndFeelManager.getInstance().isLightTheme()) {
                return bl ? ColorUtils.getWhite() : ColorUtils.getBlack();
            }
            return bl ? ColorUtils.getBlack() : ColorUtils.getWhite();
        }

        default public Color getNonSelectionBackgroundColor(RowStyle rowStyle, int n, int n2, int n3, boolean bl, boolean bl2) {
            Color color = null;
            if (bl) {
                return bl2 ? ColorUtils.getSelection5() : ColorUtils.getSecondary5();
            }
            Color color2 = ColorUtils.getSecondary1();
            if (color2 == null) {
                color2 = UIManager.getColor("Table.background");
            }
            if (RowStyle.ALTERNATE_PER_ROW == rowStyle) {
                float f = 0.6f;
                boolean bl3 = n2 % 2 == 0;
                color = bl3 ? color2 : ColorUtils.brighter(color2, f);
                if (color == null) {
                    color = UIManager.getColor("Table.background");
                    if (!bl3 && color != null) {
                        color = color.brighter();
                    }
                }
            } else if (RowStyle.CONTINUOUS_PER_LEVEL == rowStyle) {
                switch (n) {
                    case 0: {
                        color = color2;
                        break;
                    }
                    case 1: {
                        color = ColorUtils.brighter(color2, 0.6f);
                        break;
                    }
                    case 2: {
                        color = ColorUtils.brighter(color2, 0.4f);
                        break;
                    }
                    default: {
                        color = ColorUtils.brighter(color2, 0.4f);
                        break;
                    }
                }
            } else {
                color = color2;
            }
            return color;
        }

        default public Color getSelectionBackgroundColor(RowStyle rowStyle, int n, int n2, int n3, boolean bl, boolean bl2) {
            Color color = null;
            if (bl) {
                color = this.getNonSelectionBackgroundColor(rowStyle, n, n2, n3, bl, bl2);
            } else {
                Color color2 = color = bl2 ? ColorUtils.getSelection1() : ColorUtils.getSecondary3();
                if (color == null) {
                    color = UIManager.getColor("Table.selectionBackground");
                }
            }
            return color;
        }

        public static enum Gender {
            MALE,
            FEMALE,
            TRANSGENDER,
            UNKNOWN;

        }
    }

    private static class LightWorklistSkin
    implements IWorklistSkin {
        private LightWorklistSkin() {
        }

        @Override
        public Icon getCollapsedIcon() {
            return LTAIconUtils.getPlusIcon();
        }

        @Override
        public Icon getCollapsedRolloverIcon() {
            return LTAIconUtils.getPlusRolloverIcon();
        }

        @Override
        public Icon getExpandedIcon() {
            return LTAIconUtils.getMinusIcon();
        }

        @Override
        public Icon getExpandedRolloverIcon() {
            return LTAIconUtils.getMinusRolloverIcon();
        }

        @Override
        public Icon getSnapshotIcon() {
            return LTAIconUtils.getCameraBlackIcon();
        }

        @Override
        public Icon getLinkedIcon() {
            return LTAIconUtils.getLinkedBlackIcon();
        }

        @Override
        public Icon getGenderIcon(IWorklistSkin.Gender gender) {
            switch (gender) {
                case MALE: {
                    return LTAIconUtils.getMaleBlackIcon();
                }
                case FEMALE: {
                    return LTAIconUtils.getFemaleBlackIcon();
                }
                case TRANSGENDER: {
                    return LTAIconUtils.getTransgenderBlackIcon();
                }
            }
            return LTAIconUtils.getGenderUnknownBlackIcon();
        }

        @Override
        public Color getLoadButtonBackground(boolean bl, boolean bl2) {
            if (bl2) {
                return ColorUtils.getPrimary3();
            }
            return ColorUtils.getSecondary4();
        }

        @Override
        public Color getNonSelectionForegroundColor(RowStyle rowStyle, int n, int n2, int n3, boolean bl, boolean bl2) {
            if (bl) {
                if (LookAndFeelManager.getInstance().isLightTheme()) {
                    return ColorUtils.ensureAWTColor(bl2 ? ColorUtils.getSecondary2() : ColorUtils.getWhite());
                }
                return ColorUtils.ensureAWTColor(ColorUtils.getSecondary1());
            }
            return ColorUtils.ensureAWTColor(ColorUtils.getSecondary2());
        }

        @Override
        public Color getSelectionForegroundColor(RowStyle rowStyle, int n, int n2, int n3, boolean bl, boolean bl2) {
            return this.getNonSelectionForegroundColor(rowStyle, n, n2, n3, bl, bl2);
        }

        @Override
        public Color getNonSelectionBackgroundColor(RowStyle rowStyle, int n, int n2, int n3, boolean bl, boolean bl2) {
            Color color = null;
            if (bl) {
                if (bl2) {
                    return ColorUtils.getSelection5();
                }
                if (LookAndFeelManager.getInstance().isLightTheme()) {
                    return ColorUtils.getSecondary2();
                }
                return ColorUtils.getSecondary5();
            }
            Color color2 = ColorUtils.getSecondary5();
            if (color2 == null) {
                color2 = UIManager.getColor("Table.background");
            }
            if (RowStyle.ALTERNATE_PER_ROW == rowStyle) {
                float f = 0.8f;
                boolean bl3 = n2 % 2 == 0;
                color = bl3 ? color2 : ColorUtils.brighter(color2, f);
                if (color == null) {
                    color = UIManager.getColor("Table.background");
                    if (!bl3 && color != null) {
                        color = color.brighter();
                    }
                }
            } else if (RowStyle.CONTINUOUS_PER_LEVEL == rowStyle) {
                switch (n) {
                    case 0: {
                        color = color2;
                        break;
                    }
                    case 1: {
                        color = ColorUtils.brighter(color2, 0.85f);
                        break;
                    }
                    case 2: {
                        color = ColorUtils.brighter(color2, 0.65f);
                        break;
                    }
                    default: {
                        color = ColorUtils.brighter(color2, 0.65f);
                        break;
                    }
                }
            } else {
                color = color2;
            }
            return color;
        }

        @Override
        public Color getSelectionBackgroundColor(RowStyle rowStyle, int n, int n2, int n3, boolean bl, boolean bl2) {
            Color color = null;
            if (bl) {
                color = this.getNonSelectionBackgroundColor(rowStyle, n, n2, n3, bl, bl2);
            } else {
                color = ColorUtils.getSelection2();
                if (color == null) {
                    color = UIManager.getColor("Table.selectionBackground");
                }
            }
            return color;
        }
    }

    public static enum RowStyle {
        ALTERNATE_PER_ROW,
        CONTINUOUS_PER_LEVEL;

    }
}

