/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.plaf.synth;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class NiceLineBorder
implements Border {
    private final NiceBorderColor borderColor;
    private final NiceBorderThickness borderThickness;

    public NiceLineBorder(NiceBorderColor niceBorderColor, NiceBorderThickness niceBorderThickness) {
        this.borderColor = niceBorderColor;
        this.borderThickness = niceBorderThickness;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        int n5 = this.borderThickness.getTop();
        Color color2 = this.borderColor.getTop();
        if (color2 != null && n5 > 0) {
            graphics.setColor(color2);
            graphics.fillRect(n, n2, n3, n5);
        }
        n5 = this.borderThickness.getLeft();
        color2 = this.borderColor.getLeft();
        if (color2 != null && n5 > 0) {
            graphics.setColor(color2);
            graphics.fillRect(n, n2, n5, n4);
        }
        n5 = this.borderThickness.getRight();
        color2 = this.borderColor.getRight();
        if (color2 != null && n5 > 0) {
            graphics.setColor(color2);
            graphics.fillRect(n + n3 - n5, n2, n5, n4);
        }
        n5 = this.borderThickness.getBottom();
        color2 = this.borderColor.getBottom();
        if (color2 != null && n5 > 0) {
            graphics.setColor(color2);
            graphics.fillRect(n, n2 + n4 - n5, n3, n5);
        }
        graphics.setColor(color);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.borderThickness;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public static class NiceBorderColor {
        private Color top;
        private Color left;
        private Color bottom;
        private Color right;

        public NiceBorderColor(Color color) {
            this(color, color, color, color);
        }

        public NiceBorderColor(Color color, Color color2, Color color3, Color color4) {
            this.top = color;
            this.left = color2;
            this.bottom = color3;
            this.right = color4;
        }

        public Color getTop() {
            return this.top;
        }

        public Color getLeft() {
            return this.left;
        }

        public Color getBottom() {
            return this.bottom;
        }

        public Color getRight() {
            return this.right;
        }

        public Color getColor() {
            if (this.top != null) {
                return this.top;
            }
            if (this.left != null) {
                return this.left;
            }
            if (this.bottom != null) {
                return this.bottom;
            }
            if (this.right != null) {
                return this.right;
            }
            return null;
        }

        public void applyAlpha(int n) {
            if (n >= 0 && n <= 255) {
                this.top = new Color(this.top.getRed(), this.top.getGreen(), this.top.getBlue(), n);
                this.left = new Color(this.left.getRed(), this.left.getGreen(), this.left.getBlue(), n);
                this.bottom = new Color(this.bottom.getRed(), this.bottom.getGreen(), this.bottom.getBlue(), n);
                this.right = new Color(this.right.getRed(), this.right.getGreen(), this.right.getBlue(), n);
            }
        }
    }

    public static class NiceBorderThickness
    extends Insets {
        public NiceBorderThickness(int n) {
            this(n, n, n, n);
        }

        public NiceBorderThickness(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
        }

        public int getTop() {
            return this.top;
        }

        public int getLeft() {
            return this.left;
        }

        public int getBottom() {
            return this.bottom;
        }

        public int getRight() {
            return this.right;
        }
    }
}

