/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.swingx.plaf.synth;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.DefaultSynthStyle;

public class NiceListCellRenderer
implements ListCellRenderer<Object> {
    private ListCellRenderer<Object> delegate;
    private boolean initialized;
    private Color rolloverBackground;
    private Color rolloverForeground;
    private MouseHandler mouseHandler;

    public NiceListCellRenderer(ListCellRenderer<Object> listCellRenderer) {
        this.delegate = listCellRenderer;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends Object> jList, Object object, int n, boolean bl, boolean bl2) {
        Component component = this.delegate.getListCellRendererComponent(jList, object, n, bl, bl2);
        if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            this.initializeIfNeeded(jList);
            if ((this.rolloverBackground != null || this.rolloverForeground != null) && this.mouseHandler != null && this.mouseHandler.isMouseOverRow(n)) {
                if (this.rolloverBackground != null) {
                    jLabel.setBackground(this.rolloverBackground);
                }
                if (this.rolloverForeground != null) {
                    jLabel.setForeground(this.rolloverForeground);
                }
            }
        }
        return component;
    }

    private void initializeIfNeeded(JList<?> jList) {
        if (!this.initialized) {
            try {
                this.mouseHandler = MouseHandler.install(jList);
                SynthStyle synthStyle = SynthLookAndFeel.getStyle(jList, Region.LIST);
                if (synthStyle instanceof DefaultSynthStyle) {
                    DefaultSynthStyle defaultSynthStyle = (DefaultSynthStyle)synthStyle;
                    this.rolloverBackground = defaultSynthStyle.getColor(jList, Region.LIST, 2, ColorType.TEXT_BACKGROUND);
                    this.rolloverForeground = defaultSynthStyle.getColor(jList, Region.LIST, 2, ColorType.TEXT_FOREGROUND);
                }
            }
            finally {
                this.initialized = true;
            }
        }
    }

    private static class MouseHandler
    extends MouseAdapter {
        private JList<?> list;
        private int hoveredRow = -1;

        private MouseHandler(JList<?> jList) {
            this.list = jList;
        }

        public static MouseHandler install(JList<?> jList) {
            MouseHandler mouseHandler = new MouseHandler(jList);
            jList.addMouseListener(mouseHandler);
            jList.addMouseMotionListener(mouseHandler);
            return mouseHandler;
        }

        public boolean isMouseOverRow(int n) {
            return n >= 0 && this.hoveredRow == n;
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.hoveredRow = -1;
            this.list.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            this.hoveredRow = this.convertLocationToIndex(point);
            this.list.repaint();
        }

        private int convertLocationToIndex(Point point) {
            int n = this.list.locationToIndex(point);
            Rectangle rectangle = this.list.getCellBounds(n, n);
            if (rectangle != null && !rectangle.contains(point)) {
                n = -1;
            }
            return n;
        }
    }
}

